/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.serviceaccess;

import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.metamodel.Table;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.services.localization.LocalizationResourceAccessor;
import com.sap.caf.rt.services.serviceaccess.CAFServiceAccessBeanImpl;
import com.sap.caf.rt.ui.cool.metadata.AspectActionDescriptor;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.FieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.KeyAspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.QueryDescriptor;
import com.sap.caf.rt.ui.cool.metadata.RelationDescriptor;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.StructureDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptorFactory;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ResourceException;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class MetamodelHelper {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper == null ? (class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper = MetamodelHelper.class$("com.sap.caf.rt.services.serviceaccess.MetamodelHelper")) : class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper));
    private static final boolean testMode = false;
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String APPLICATION = (class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper == null ? (class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper = MetamodelHelper.class$("com.sap.caf.rt.services.serviceaccess.MetamodelHelper")) : class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper).getName();
    private static final String jARMRequest = "CAF:RT:oal" + APPLICATION;
    private Map descriptors = new HashMap();
    private Locale accessServiceLocale = null;
    private Map structureDescriptorsCashe = new HashMap();
    private Map aspectDescriptorsCashe = new HashMap();
    private Map keyAspectDescriptorsCashe = new HashMap();
    private static final Integer CARDINALITY_N = new Integer(-1);
    private static final Integer PATTERN_CUSTOM = new Integer(0);
    private static final Integer PATTERN_CREATE = new Integer(1);
    private static final Integer PATTERN_FIND_BY = new Integer(5);
    private static final Integer PATTERN_BW_EXTRACT_OPERATION = new Integer(8);
    private static final String ASPECT_SUBMIT_ACTION_NAME = "$submit$";
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static final String STRING_TYPE = "STRING";
    private Map aspectsApplicationAndProviderNames = new HashMap();
    private static final String INVALID_ATTRIBUTE_DICT_TYPE_0 = "";
    private static final String INVALID_ATTRIBUTE_DICT_TYPE_1 = "*";
    public static final String FIND_BY_MULTIPLE_PARAMS_NAME = "findByMultipleParameters";
    public static final String FIND_BY_KM_PROPERTY_SEARCH_NAME = "findByKMPropertySearch";
    public static final String SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME = "searchidxForBOInRelatedDoc";
    private static final String CATEGORY_NAME_START = "CATEGORY_";
    private static final String PARAM_NAME_CATEGORY_DESCRIPTION = "description";
    private static final String PARAM_NAME_CATEGORY_ID = "id";
    private static final String CATEGORY_SERVICE_JNDI_NAME = "localejbs/sap.com/caf.tc/CategoryService";
    public static final String IS_BW_EXTRACT_OPERATION = "is_BW_EXTRACT_OPERATION";
    private TypedFieldDescriptorFactory tfdFactory = new TypedFieldDescriptorFactory();
    public static final String BE_TABLE_PARAM_NAME = "BE_TABLE";
    public static final String BE_DO_MOFID_PARAM_NAME = "BE_DO_MOFID";
    public static final String MOF_INTERFACE_TYPE_PARAM_NAME = "MOFInterfaceType";
    public static final String MOF_INTERFACE_TYPE_VALUE_BEI = "BusinessEntityInterface";
    public static final String MOF_INTERFACE_TYPE_VALUE_AI = "ApplicationInterface";
    static /* synthetic */ Class class$com$sap$caf$rt$services$serviceaccess$MetamodelHelper;
    static /* synthetic */ Class class$java$lang$String;

    public MetamodelHelper(Locale locale) {
        this.accessServiceLocale = locale;
    }

    public ServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleId) {
        return (ServiceModuleDescriptor)this.descriptors.get(serviceModuleId);
    }

    public Collection getServiceModuleNames() {
        return Collections.unmodifiableCollection(this.descriptors.keySet());
    }

    public boolean serviceExists(String serviceModuleName) {
        return this.descriptors.containsKey(serviceModuleName);
    }

    public String getServiceJNDI_KEY(String serviceModuleId) {
        return "localejbs/" + serviceModuleId;
    }

    public void reloadMetamodel() throws DataAccessException {
        try {
            this.reloadMetamodel(null);
        }
        catch (DataAccessException e) {
            location.catching((Throwable)((Object)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadMetamodel(String metamodelPath) throws DataAccessException {
        String method = "reloadMetamodel(String)";
        CAFPublicLogger.entering(null, jARMRequest, "reloadMetamodel(String)", location, 1);
        this.descriptors.clear();
        this.structureDescriptorsCashe.clear();
        this.aspectDescriptorsCashe.clear();
        this.keyAspectDescriptorsCashe.clear();
        this.aspectsApplicationAndProviderNames.clear();
        try {
            long time = System.currentTimeMillis();
            IConnection connection = RepositoryConnection.getConnection();
            long time2 = System.currentTimeMillis();
            Collection applications = this.getApplications(connection);
            long time3 = System.currentTimeMillis();
            this.transform(applications);
            long time4 = System.currentTimeMillis();
            location.debugT("** Connect to MMR repository time = " + (time2 - time));
            location.debugT("** Get Applications time = " + (time3 - time2));
            location.debugT("** Transformation time = " + (time4 - time3));
            location.debugT("***** Time = " + (time4 - time));
            Object var14_9 = null;
            this.structureDescriptorsCashe.clear();
            this.aspectDescriptorsCashe.clear();
            this.keyAspectDescriptorsCashe.clear();
            this.aspectsApplicationAndProviderNames.clear();
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            this.structureDescriptorsCashe.clear();
            this.aspectDescriptorsCashe.clear();
            this.keyAspectDescriptorsCashe.clear();
            this.aspectsApplicationAndProviderNames.clear();
            CAFPublicLogger.exiting(null, jARMRequest, "reloadMetamodel(String)", location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, jARMRequest, "reloadMetamodel(String)", location, 1);
    }

    private Collection getApplications(IConnection connection) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("com");
        typeList.add("sap");
        typeList.add("caf");
        typeList.add("metamodel");
        typeList.add("Application");
        List c = null;
        try {
            c = connection.queryM1(typeList, null, true);
        }
        catch (ResourceException ex) {
            location.catching((Throwable)ex);
            return c;
        }
        return c;
    }

    public void transform(Collection applications) {
        ArrayList interfaces = new ArrayList();
        Iterator appIt = applications.iterator();
        while (appIt.hasNext()) {
            Application application = (Application)appIt.next();
            interfaces.addAll(this.processApplcation(application));
        }
        this.processAllRelations(interfaces);
    }

    public List processApplcation(Application application) {
        ArrayList allInterfaces = new ArrayList();
        String method = "processApplication(Application)";
        try {
            if (application != null) {
                ArrayList businessInterfaces = new ArrayList();
                ArrayList applicationInterfaces = new ArrayList();
                Iterator it = application.getBaseObjects().iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof BusinessEntityInterface) {
                        businessInterfaces.add(obj);
                        continue;
                    }
                    if (!(obj instanceof ApplicationInterface)) continue;
                    applicationInterfaces.add(obj);
                }
                int businessInterfacesSize = businessInterfaces.size();
                for (int i = 0; i < businessInterfacesSize; ++i) {
                    this.processMOFInterface((MOFInterface)businessInterfaces.get(i));
                }
                int applicationInterfacesSize = applicationInterfaces.size();
                for (int i = 0; i < applicationInterfacesSize; ++i) {
                    this.processMOFInterface((MOFInterface)applicationInterfaces.get(i));
                }
                allInterfaces.addAll(businessInterfaces);
                allInterfaces.addAll(applicationInterfaces);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(400, location, "processApplication(Application)", e);
        }
        return allInterfaces;
    }

    public void processAllRelations(List allInterfaces) {
        int allInterfacesSize = allInterfaces.size();
        for (int i = 0; i < allInterfacesSize; ++i) {
            this.processAspectsRelations((MOFInterface)allInterfaces.get(i), allInterfaces);
        }
    }

    public void processAspectsRelations(MOFInterface mofInterfaceImpl, List allInterfaces) {
        ServiceModuleDescriptor serviceModuleDescriptor = (ServiceModuleDescriptor)this.descriptors.get(this.getObjectKey(mofInterfaceImpl));
        ClassLoader serviceClassLoader = this.getClassLoader(serviceModuleDescriptor);
        List operations = mofInterfaceImpl.getOperations();
        int size = operations.size();
        for (int i = 0; i < size; ++i) {
            List inputParameters;
            Operation operation = (Operation)operations.get(i);
            if (operation == null || !this.checkOperation(operation)) continue;
            DataStructure aspect = this.getAspect(mofInterfaceImpl, operation);
            if (aspect != null) {
                this.addRelationDescriptors(aspect, serviceModuleDescriptor, serviceClassLoader, allInterfaces);
            }
            Message inputMessage = operation.getInput();
            if (mofInterfaceImpl instanceof BusinessEntityInterface && this.isCRUDOperation(operation) || inputMessage == null || (inputParameters = inputMessage.getMessageParts()) == null) continue;
            int inputSize = inputParameters.size();
            for (int k = 0; k < inputSize; ++k) {
                DataStructure parameterAspect;
                Attribute attr = (Attribute)inputParameters.get(k);
                if (attr == null || (parameterAspect = attr.getReferencedObject()) == null) continue;
                this.addRelationDescriptors(parameterAspect, serviceModuleDescriptor, serviceClassLoader, allInterfaces);
            }
        }
    }

    private DataStructure getAspect(MOFInterface mofInterfaceImpl, Operation operation) {
        block5: {
            List inputMessageAttributes;
            Message inputMessage;
            block4: {
                if (mofInterfaceImpl instanceof BusinessEntityInterface) {
                    return ((BusinessEntityInterface)mofInterfaceImpl).getBusinessEntity();
                }
                Message outputMessage = operation.getOutput();
                if (outputMessage == null) break block4;
                List outputMessageAttributes = outputMessage.getMessageParts();
                if (outputMessageAttributes == null) break block5;
                int size = outputMessageAttributes.size();
                for (int j = 0; j < size; ++j) {
                    DataStructure refObj;
                    Attribute attr = (Attribute)outputMessageAttributes.get(j);
                    if (attr == null || (refObj = attr.getReferencedObject()) == null) continue;
                    return refObj;
                }
                break block5;
            }
            if (operation != null && operation.getPatternType() != null && (operation.getPatternType() == 3 || operation.getPatternType() == 4) && (inputMessage = operation.getInput()) != null && (inputMessageAttributes = inputMessage.getMessageParts()) != null) {
                int size = inputMessageAttributes.size();
                for (int j = 0; j < size; ++j) {
                    DataStructure refObj;
                    Attribute attr = (Attribute)inputMessageAttributes.get(j);
                    if (attr == null || (refObj = attr.getReferencedObject()) == null) continue;
                    return refObj;
                }
            }
        }
        return null;
    }

    public void processMOFInterface(MOFInterface mofInterfaceImpl) {
        String method = "processMOFInterface(MofInterface)";
        try {
            String objectKey = this.getObjectKey(mofInterfaceImpl);
            ServiceModuleDescriptor serviceModuleDescriptor = new ServiceModuleDescriptor(objectKey, mofInterfaceImpl.getShortText(), "configuration", "configuration desc", this.accessServiceLocale);
            this.descriptors.put(objectKey, serviceModuleDescriptor);
            ClassLoader serviceClassLoader = this.getClassLoader(serviceModuleDescriptor);
            if (mofInterfaceImpl instanceof BusinessEntityInterface) {
                Table masterTable;
                serviceModuleDescriptor.addAttribute(MOF_INTERFACE_TYPE_PARAM_NAME, MOF_INTERFACE_TYPE_VALUE_BEI);
                DataObject dataObject = ((BusinessEntityInterface)mofInterfaceImpl).getBusinessEntity();
                if (dataObject != null && (masterTable = dataObject.getMasterTable()) != null) {
                    serviceModuleDescriptor.addAttribute(BE_TABLE_PARAM_NAME, masterTable.getTableName());
                }
            } else if (mofInterfaceImpl instanceof ApplicationInterface) {
                serviceModuleDescriptor.addAttribute(MOF_INTERFACE_TYPE_PARAM_NAME, MOF_INTERFACE_TYPE_VALUE_AI);
            }
            this.addAttributeIfServiceIsClassifiable(mofInterfaceImpl, serviceModuleDescriptor);
            List operations = mofInterfaceImpl.getOperations();
            int size = operations.size();
            for (int i = 0; i < size; ++i) {
                try {
                    Attribute outputAttr;
                    List outputMessageParts;
                    Object inputParameters;
                    Operation operation = (Operation)operations.get(i);
                    boolean isFindByMultipleParametersOperation = false;
                    if (operation == null) continue;
                    if (!this.checkOperation(operation)) {
                        if (!FIND_BY_MULTIPLE_PARAMS_NAME.equals(operation.getObjectName()) && !PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) continue;
                        isFindByMultipleParametersOperation = true;
                    }
                    DataStructure aspect = this.getAspect(mofInterfaceImpl, operation);
                    Message outputMessage = operation.getOutput();
                    Message inputMessage = operation.getInput();
                    if (aspect != null) {
                        Attribute outputAttr2;
                        List outputMessageParts2;
                        StructureDescriptor inputStructure;
                        Boolean isSearchAndRetrieval;
                        if (mofInterfaceImpl instanceof BusinessEntityInterface) {
                            serviceModuleDescriptor.addAttribute("BusinessEntityName", this.getDataObjectNameFromAspect(aspect));
                        }
                        inputParameters = this.getStructureDescriptor(aspect, serviceModuleDescriptor, serviceClassLoader);
                        KeyAspectDescriptor keyAspectDescriptor = this.getKeyAspectDescriptor(aspect, serviceModuleDescriptor, serviceClassLoader, true);
                        AspectDescriptor resultDescriptor = this.getAspectDescriptor(serviceModuleDescriptor, aspect, (StructureDescriptor)inputParameters, keyAspectDescriptor, true, null);
                        if (mofInterfaceImpl instanceof BusinessEntityInterface && (isSearchAndRetrieval = ((BusinessEntityInterface)mofInterfaceImpl).isSearchAndRetrieval()) != null && isSearchAndRetrieval.booleanValue()) {
                            this.addKMMethods(serviceModuleDescriptor, serviceClassLoader, keyAspectDescriptor, (StructureDescriptor)inputParameters, resultDescriptor);
                        }
                        if (PATTERN_FIND_BY.equals(operation.getPatternType()) || PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) {
                            inputStructure = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operation.getObjectName(), operation, isFindByMultipleParametersOperation);
                            QueryDescriptor queryDescriptor = new QueryDescriptor(operation.getObjectName(), operation.getShortText(), keyAspectDescriptor, inputStructure, resultDescriptor, serviceModuleDescriptor);
                            if (isFindByMultipleParametersOperation) {
                                Integer implCheck;
                                queryDescriptor.addAttribute(FIND_BY_MULTIPLE_PARAMS_NAME, "true");
                                Permission perm = operation.getPermission();
                                if (perm != null && (implCheck = perm.getImplicitCheck()) != null && implCheck == 1) {
                                    queryDescriptor.addAttribute("implicitCheck", "true");
                                }
                            }
                            serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
                            if (PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType())) {
                                queryDescriptor.addAttribute(IS_BW_EXTRACT_OPERATION, "true");
                            }
                        } else if (this.isCRUDOperation(operation)) {
                            inputStructure = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operation.getObjectName(), operation, false);
                            String operationType = INVALID_ATTRIBUTE_DICT_TYPE_0;
                            int patternType = operation.getPatternType();
                            if (patternType == 1) {
                                operationType = "create";
                            } else if (patternType == 2) {
                                operationType = "read";
                            } else if (patternType == 3) {
                                operationType = "update";
                            } else if (patternType == 4) {
                                operationType = "delete";
                            }
                            serviceModuleDescriptor.addOperationDescriptor(resultDescriptor.getName(), new AspectActionDescriptor(operation.getObjectName(), inputStructure), operationType);
                        } else if (outputMessage == null || outputMessage.getMessageParts() == null || outputMessage.getMessageParts().size() == 0) {
                            inputStructure = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operation.getObjectName(), operation, false);
                            resultDescriptor.addAspectActionDescriptor(new AspectActionDescriptor(operation.getObjectName(), inputStructure, resultDescriptor));
                        } else if (outputMessage != null && (outputMessageParts2 = outputMessage.getMessageParts()) != null && outputMessageParts2.size() > 0 && (outputAttr2 = (Attribute)outputMessageParts2.get(0)) != null && outputAttr2.getReferencedObject() != null) {
                            StructureDescriptor inputStructure2 = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operation.getObjectName(), operation, false);
                            QueryDescriptor queryDescriptor = new QueryDescriptor(operation.getObjectName(), operation.getShortText(), keyAspectDescriptor, inputStructure2, resultDescriptor, serviceModuleDescriptor);
                            serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
                        }
                        List attrs = aspect.getAttributes();
                        int attrSize = attrs.size();
                        for (int j = 0; j < attrSize; ++j) {
                            Attribute attr = (Attribute)attrs.get(j);
                            if (attr == null || !CARDINALITY_N.equals(attr.getMaxOccurs()) || attr.getReferencedObject() != null) continue;
                            this.processCollectionAttribute(attr, aspect, resultDescriptor, serviceModuleDescriptor);
                        }
                    } else if (outputMessage != null && (outputMessageParts = outputMessage.getMessageParts()) != null && outputMessageParts.size() > 0 && (outputAttr = (Attribute)outputMessageParts.get(0)) != null && outputAttr.getReferencedObject() == null) {
                        String operationName = operation.getObjectName();
                        String outputAttrName = outputAttr.getObjectName();
                        String structName = "ASPECT_" + operationName + "_" + outputAttrName;
                        FieldDescriptor[] fields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null), this.tfdFactory.getTypedFieldDescriptor("value", null, outputAttr.getTypeJavaDdic(), this.getClassLoader(serviceModuleDescriptor), this.accessServiceLocale)};
                        StructureDescriptor attrsDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
                        FieldDescriptor[] keyfields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null)};
                        StructureDescriptor structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, keyfields);
                        KeyAspectDescriptor keyAttrsDescriptor = new KeyAspectDescriptor(serviceModuleDescriptor, "KEY_" + structName, "Dinamically_created_aspect", structureDescriptor);
                        AspectDescriptor aspectDescriptor = new AspectDescriptor(serviceModuleDescriptor, operationName + "_" + outputAttrName, outputAttr.getShortText(), attrsDescriptor, keyAttrsDescriptor);
                        aspectDescriptor.addAttribute("generic", "true");
                        this.createEmptySubmitAction(aspectDescriptor, serviceModuleDescriptor);
                        StructureDescriptor inputStructure = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operationName, operation, false);
                        FieldDescriptor[] inputKeyfields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null)};
                        StructureDescriptor inputStructureDescriptor = new StructureDescriptor(serviceModuleDescriptor, "INPUT_" + structName, inputKeyfields);
                        KeyAspectDescriptor inputKeyAttrsDescriptor = new KeyAspectDescriptor(serviceModuleDescriptor, "INPUT_KEY_" + structName, "Dinamically_created_aspect", inputStructureDescriptor);
                        QueryDescriptor queryDescriptor = new QueryDescriptor(operationName, operation.getShortText(), inputKeyAttrsDescriptor, inputStructure, aspectDescriptor, serviceModuleDescriptor);
                        serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
                    }
                    if (mofInterfaceImpl instanceof BusinessEntityInterface && this.isCRUDOperation(operation) || inputMessage == null || (inputParameters = inputMessage.getMessageParts()) == null) continue;
                    int inputSize = inputParameters.size();
                    for (int k = 0; k < inputSize; ++k) {
                        DataStructure parameterAspect;
                        Attribute attr = (Attribute)inputParameters.get(k);
                        if (attr == null || (parameterAspect = attr.getReferencedObject()) == null) continue;
                        StructureDescriptor parameterAspectStructure = this.getStructureDescriptor(parameterAspect, serviceModuleDescriptor, serviceClassLoader);
                        KeyAspectDescriptor parameterAspectKeyDescriptor = this.getKeyAspectDescriptor(parameterAspect, serviceModuleDescriptor, serviceClassLoader, true);
                        AspectDescriptor resultDescriptor = this.getAspectDescriptor(serviceModuleDescriptor, parameterAspect, parameterAspectStructure, parameterAspectKeyDescriptor, true, null);
                    }
                    continue;
                }
                catch (Exception e) {
                    CAFPublicLogger.traceThrowable(500, location, "processMOFInterface(MofInterface)", e);
                }
            }
            if (mofInterfaceImpl instanceof ApplicationInterface) {
                IAspectDescriptor[] aspectDescrs;
                AspectDescriptor app_desc = (AspectDescriptor)serviceModuleDescriptor.getAspectDescriptor(mofInterfaceImpl.getObjectName());
                if (app_desc == null) {
                    app_desc = this.createAspectDescriptorForActionsSupport(serviceModuleDescriptor, mofInterfaceImpl);
                }
                if ((aspectDescrs = serviceModuleDescriptor.getAspectDescriptors()) != null) {
                    for (int j = 0; j < aspectDescrs.length; ++j) {
                        AspectDescriptor desc = (AspectDescriptor)aspectDescrs[j];
                        for (int i = 0; i < size; ++i) {
                            try {
                                Operation operation = (Operation)operations.get(i);
                                if (!PATTERN_CUSTOM.equals(operation.getPatternType()) || operation.getOutput() != null && operation.getOutput().getMessageParts() != null && operation.getOutput().getMessageParts().size() != 0) continue;
                                String operationName = operation.getObjectName();
                                StructureDescriptor inputStructure = this.getOperationStructureDescriptor(serviceModuleDescriptor, serviceClassLoader, serviceModuleDescriptor.getName() + "_" + operationName, operation, false);
                                desc.addAspectActionDescriptor(new AspectActionDescriptor(operationName, inputStructure, desc));
                                continue;
                            }
                            catch (Exception e) {
                                CAFPublicLogger.traceThrowable(500, location, "processMOFInterface(MofInterface)", e);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(500, location, "processMOFInterface(MofInterface)", e);
        }
    }

    private AspectDescriptor createAspectDescriptorForActionsSupport(ServiceModuleDescriptor serviceModuleDescriptor, MOFInterface mofInterface) {
        String aspectDescriptorName = mofInterface.getObjectName();
        FieldDescriptor[] fields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null)};
        StructureDescriptor attrsDescriptor = new StructureDescriptor(serviceModuleDescriptor, aspectDescriptorName, fields);
        FieldDescriptor[] keyfields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null)};
        StructureDescriptor structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, aspectDescriptorName, keyfields);
        KeyAspectDescriptor keyAttrsDescriptor = new KeyAspectDescriptor(serviceModuleDescriptor, "KEY_" + aspectDescriptorName, "Aspect_descriptor_for_actions_support", structureDescriptor);
        AspectDescriptor aspectDescriptor = new AspectDescriptor(serviceModuleDescriptor, aspectDescriptorName, "Aspect_descriptor_for_actions_support", attrsDescriptor, keyAttrsDescriptor);
        this.createEmptySubmitAction(aspectDescriptor, serviceModuleDescriptor);
        return aspectDescriptor;
    }

    private StructureDescriptor getOperationStructureDescriptor(ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, String structName, Operation operation, boolean isFindByMultipleParametersOperation) {
        MOFInterface mofInterface;
        FieldDescriptor[] fields = null;
        if (isFindByMultipleParametersOperation) {
            mofInterface = operation.getMOFInterface();
            DataStructure dataStructure = this.getAspect(mofInterface, operation);
            if (dataStructure != null) {
                List attrs;
                ArrayList<FieldDescriptor> fieldsList = new ArrayList<FieldDescriptor>();
                List keys = dataStructure.getKeys();
                if (keys != null) {
                    int size = keys.size();
                    for (int i = 0; i < size; ++i) {
                        Attribute attr = (Attribute)keys.get(i);
                        if (attr == null) continue;
                        if (!KEY_ATTRIBUTE_NAME.equals(attr.getObjectName())) {
                            fieldsList.add(this.getFieldDescriptor(attr, operation, serviceModuleDescriptor, serviceClassLoader));
                            continue;
                        }
                        fieldsList.add(this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, serviceClassLoader));
                    }
                }
                if ((attrs = dataStructure.getAttributes()) != null) {
                    Attribute attr;
                    int i;
                    int size = attrs.size();
                    for (i = 0; i < size; ++i) {
                        attr = (Attribute)attrs.get(i);
                        if (attr == null || MetamodelHelper.isComplexAttribute(attr)) continue;
                        fieldsList.add(this.getFieldDescriptor(attr, operation, serviceModuleDescriptor, serviceClassLoader));
                    }
                    for (i = 0; i < size; ++i) {
                        DataStructure ref;
                        List complexAttrs;
                        attr = (Attribute)attrs.get(i);
                        if (attr == null || !MetamodelHelper.isComplexAttribute(attr) || (complexAttrs = (ref = attr.getReferencedObject()).getAttributes()) == null) continue;
                        int complexSize = complexAttrs.size();
                        for (int j = 0; j < complexSize; ++j) {
                            Attribute subattr = (Attribute)complexAttrs.get(j);
                            if (subattr == null) continue;
                            FieldDescriptor fd = this.getFieldDescriptor(subattr, operation, serviceModuleDescriptor, serviceClassLoader);
                            fd.addAttribute("isComplexSubattribute", "true");
                            fd.addAttribute("sourceAttributeName", attr.getObjectName());
                            fd.addAttribute("targetAttributeName", subattr.getObjectName());
                            fd.setName(this.getFieldNameForComplexSubattribute(attr.getObjectName(), subattr.getObjectName(), fieldsList));
                            fieldsList.add(fd);
                        }
                    }
                }
                fields = fieldsList.toArray(new FieldDescriptor[0]);
            }
        } else if (PATTERN_CREATE.equals(operation.getPatternType())) {
            mofInterface = operation.getMOFInterface();
            DataObject dataStructure = null;
            if (mofInterface instanceof BusinessEntityInterface) {
                dataStructure = ((BusinessEntityInterface)mofInterface).getBusinessEntity();
            } else {
                Object retVal;
                int outputMessagePartsSize;
                List outputMessageParts;
                Message output = operation.getOutput();
                if (output != null && (outputMessageParts = output.getMessageParts()) != null && (outputMessagePartsSize = outputMessageParts.size()) > 0 && (retVal = outputMessageParts.get(0)) != null) {
                    dataStructure = ((Attribute)retVal).getReferencedObject();
                }
            }
            if (dataStructure != null) {
                List attrs;
                ArrayList<FieldDescriptor> fieldsList = new ArrayList<FieldDescriptor>();
                List keys = dataStructure.getKeys();
                if (keys != null) {
                    int size = keys.size();
                    for (int i = 0; i < size; ++i) {
                        Attribute attr = (Attribute)keys.get(i);
                        if (attr == null || attr.getReferencedObject() != null || KEY_ATTRIBUTE_NAME.equalsIgnoreCase(attr.getObjectName())) continue;
                        fieldsList.add(this.getFieldDescriptor(attr, operation, serviceModuleDescriptor, serviceClassLoader));
                    }
                }
                if ((attrs = dataStructure.getAttributes()) != null) {
                    int size = attrs.size();
                    for (int i = 0; i < size; ++i) {
                        Integer minOccurs;
                        Attribute attr = (Attribute)attrs.get(i);
                        if (attr == null || (minOccurs = attr.getMinOccurs()) == null || minOccurs != 1) continue;
                        fieldsList.add(this.getFieldDescriptor(attr, operation, serviceModuleDescriptor, serviceClassLoader));
                    }
                }
                fields = fieldsList.toArray(new FieldDescriptor[0]);
            }
        } else {
            int inputParamSize;
            List inputMessageParts;
            Message inputMessage = operation.getInput();
            if (inputMessage != null && (inputMessageParts = inputMessage.getMessageParts()) != null && (inputParamSize = inputMessageParts.size()) > 0) {
                ArrayList<FieldDescriptor> fieldsList = new ArrayList<FieldDescriptor>();
                MOFInterface mofInterface2 = operation.getMOFInterface();
                DataObject dataStructure = null;
                if (mofInterface2 instanceof BusinessEntityInterface) {
                    dataStructure = ((BusinessEntityInterface)mofInterface2).getBusinessEntity();
                } else {
                    Object retVal;
                    List outputMessageParts;
                    Message outputMessage = operation.getOutput();
                    if (outputMessage != null && (outputMessageParts = outputMessage.getMessageParts()) != null && outputMessageParts.size() > 0 && (retVal = outputMessageParts.get(0)) != null) {
                        dataStructure = ((Attribute)retVal).getReferencedObject();
                    }
                }
                for (int i = 0; i < inputParamSize; ++i) {
                    int pointIndex;
                    Attribute attr = (Attribute)inputMessageParts.get(i);
                    if (attr == null) continue;
                    if (attr.getReferencedObject() == null) {
                        fieldsList.add(this.getFieldDescriptor(attr, operation, serviceModuleDescriptor, serviceClassLoader));
                        continue;
                    }
                    if (!PATTERN_FIND_BY.equals(operation.getPatternType()) && !PATTERN_BW_EXTRACT_OPERATION.equals(operation.getPatternType()) || dataStructure == null) continue;
                    String attrName = attr.getObjectName();
                    Attribute dataStructureAttribute = this.getAttributeForName((DataStructure)dataStructure, attrName);
                    if (dataStructureAttribute == null) {
                        location.errorT("Invalid metadata: attribute with name " + attrName + " not found in the object " + dataStructure.getObjectName() + ".");
                    }
                    TypedFieldDescriptor fd = (TypedFieldDescriptor)this.getFieldDescriptor(dataStructureAttribute, operation, serviceModuleDescriptor, serviceClassLoader);
                    if (attrName != null && (pointIndex = attrName.indexOf(46)) != -1) {
                        fd.setName(attrName.replace('.', '_'));
                    }
                    fieldsList.add(fd);
                }
                fields = fieldsList.toArray(new FieldDescriptor[0]);
            }
        }
        if (fields == null) {
            fields = new FieldDescriptor[]{};
        }
        StructureDescriptor descr = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
        return descr;
    }

    private String getFieldNameForComplexSubattribute(String sourceAttrName, String targetAttrName, List fieldDescs) {
        String separator = "_";
        String name = sourceAttrName + separator + targetAttrName;
        HashSet<String> fieldsNames = new HashSet<String>();
        int size = fieldDescs.size();
        for (int i = 0; i < size; ++i) {
            FieldDescriptor fd = (FieldDescriptor)fieldDescs.get(i);
            fieldsNames.add(fd.getName());
        }
        boolean isNameGenerated = false;
        while (!isNameGenerated) {
            isNameGenerated = true;
            if (!fieldsNames.contains(name)) continue;
            separator = separator + "_";
            name = sourceAttrName + separator + targetAttrName;
            isNameGenerated = false;
        }
        return name;
    }

    private Attribute getAttributeForName(DataStructure dataStructure, String name) {
        List attributes;
        List keys;
        int pointIndex = -1;
        if (name != null) {
            pointIndex = name.indexOf(".");
        }
        if ((keys = dataStructure.getKeys()) != null) {
            int keysSize = keys.size();
            for (int i = 0; i < keysSize; ++i) {
                DataStructure ds;
                Attribute attr = (Attribute)keys.get(i);
                if (pointIndex == -1) {
                    if (attr == null || !name.equals(attr.getObjectName())) continue;
                    return attr;
                }
                if (attr == null || !name.substring(0, pointIndex).equals(attr.getObjectName()) || (ds = attr.getReferencedObject()) == null) continue;
                return this.getAttributeForName(ds, name.substring(pointIndex + 1));
            }
        }
        if ((attributes = dataStructure.getAttributes()) != null) {
            int attributesSize = attributes.size();
            for (int i = 0; i < attributesSize; ++i) {
                DataStructure ds;
                Attribute attr = (Attribute)attributes.get(i);
                if (pointIndex == -1) {
                    if (attr == null || !name.equals(attr.getObjectName())) continue;
                    return attr;
                }
                if (attr == null || !name.substring(0, pointIndex).equals(attr.getObjectName()) || (ds = attr.getReferencedObject()) == null) continue;
                return this.getAttributeForName(ds, name.substring(pointIndex + 1));
            }
        }
        return null;
    }

    private void processCollectionAttribute(Attribute attr, DataStructure aspect, AspectDescriptor sourceAspectDescriptor, ServiceModuleDescriptor serviceModuleDescriptor) {
        String method = "processCollectionAttribute(Attribute, DataStructure, AspectDescriptor, ServiceModuleDescriptor)";
        try {
            String structName = "COLLECTION_ASPECT_" + aspect.getObjectName();
            String attributeName = attr.getObjectName();
            FieldDescriptor[] fields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null), this.tfdFactory.getTypedFieldDescriptor("value", null, attr.getTypeJavaDdic(), this.getClassLoader(serviceModuleDescriptor), this.accessServiceLocale)};
            StructureDescriptor targetAttrsDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
            FieldDescriptor[] keyfields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null)};
            StructureDescriptor structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, keyfields);
            KeyAspectDescriptor keyAspectDescriptor = new KeyAspectDescriptor(serviceModuleDescriptor, "COLLECTION_ASPECT_KEY_" + aspect.getObjectName(), aspect.getShortText(), structureDescriptor);
            AspectDescriptor targetAspectDescriptor = new AspectDescriptor(serviceModuleDescriptor, aspect.getObjectName() + "_" + attributeName, attr.getShortText(), targetAttrsDescriptor, keyAspectDescriptor);
            targetAspectDescriptor.addAttribute("collection_support", "true");
            this.createEmptySubmitAction(targetAspectDescriptor, serviceModuleDescriptor);
            CMICardinality cardinality = null;
            if (attr.getMinOccurs() == 0 && attr.getMaxOccurs() == -1) {
                cardinality = CMICardinality.CARDINALITY_MANY;
            } else if (attr.getMinOccurs() == 1 && attr.getMaxOccurs() == -1) {
                cardinality = CMICardinality.CARDINALITY_ONE_TO_MANY;
            }
            RelationDescriptor relationDescriptor = new RelationDescriptor(attributeName, cardinality, sourceAspectDescriptor, targetAspectDescriptor);
            relationDescriptor.addAttribute("source_ref_attribute", attributeName);
            relationDescriptor.addAttribute("collection_support", "true");
            relationDescriptor.addAttribute("generic", "true");
            serviceModuleDescriptor.addRelationDescriptor(relationDescriptor);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(500, location, "processCollectionAttribute(Attribute, DataStructure, AspectDescriptor, ServiceModuleDescriptor)", e);
        }
    }

    public String getObjectKey(MOFInterface mofInterfaceImpl) {
        if (mofInterfaceImpl != null) {
            StringBuffer descriptorKeyPrefix = new StringBuffer();
            Application app = mofInterfaceImpl.getApplication();
            descriptorKeyPrefix.append(app.getProviderName());
            descriptorKeyPrefix.append("/");
            descriptorKeyPrefix.append(app.getObjectName());
            descriptorKeyPrefix.append("/");
            descriptorKeyPrefix.append(mofInterfaceImpl.getObjectName());
            return descriptorKeyPrefix.toString();
        }
        return INVALID_ATTRIBUTE_DICT_TYPE_0;
    }

    public String getDataObjectNameFromAspect(DataStructure aspect) {
        BusinessEntityInterface mofInterfaceImpl;
        if (aspect instanceof DataObject && (mofInterfaceImpl = ((DataObject)aspect).getBusinessEntityInterface()) != null) {
            StringBuffer descriptorKeyPrefix = new StringBuffer();
            Application app = mofInterfaceImpl.getApplication();
            descriptorKeyPrefix.append(app.getProviderName());
            descriptorKeyPrefix.append("/");
            descriptorKeyPrefix.append(app.getObjectName());
            descriptorKeyPrefix.append("/");
            descriptorKeyPrefix.append(aspect.getObjectName());
            return descriptorKeyPrefix.toString();
        }
        return INVALID_ATTRIBUTE_DICT_TYPE_0;
    }

    private void addRelationDescriptors(DataStructure aspect, ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, List allInterfaces) {
        String method = "addRelationDescriptors(DataStructure, ServiceModuleDescriptor, ClassLoader, List)";
        try {
            AspectDescriptor sourceAspectDescriptor = this.getAspectDescriptor(serviceModuleDescriptor, aspect, null, null, true, null);
            List aspectAttributes = aspect.getAttributes();
            int size = aspectAttributes.size();
            for (int k = 0; k < size; ++k) {
                DataStructure refObject;
                Attribute attribute = (Attribute)aspectAttributes.get(k);
                if (attribute == null || (refObject = attribute.getReferencedObject()) == null) continue;
                String attributeName = attribute.getObjectName();
                AspectDescriptor targetAspectDescriptor = this.getAspectDescriptor(allInterfaces, refObject, serviceModuleDescriptor);
                CMICardinality cardinality = null;
                if (attribute.getMinOccurs() == 0) {
                    if (attribute.getMaxOccurs() == 1) {
                        cardinality = CMICardinality.CARDINALITY_ZERO_TO_ONE;
                    } else if (attribute.getMaxOccurs() == -1) {
                        cardinality = CMICardinality.CARDINALITY_MANY;
                    }
                } else if (attribute.getMaxOccurs() == 1) {
                    cardinality = CMICardinality.CARDINALITY_ONE;
                } else if (attribute.getMaxOccurs() == -1) {
                    cardinality = CMICardinality.CARDINALITY_ONE_TO_MANY;
                }
                if (targetAspectDescriptor == null) {
                    StructureDescriptor inputParameters = this.getStructureDescriptor(refObject, serviceModuleDescriptor, serviceClassLoader);
                    KeyAspectDescriptor keyAspectDescriptor = this.getKeyAspectDescriptor(refObject, serviceModuleDescriptor, serviceClassLoader, false);
                    targetAspectDescriptor = this.getAspectDescriptor(serviceModuleDescriptor, refObject, inputParameters, keyAspectDescriptor, false, aspect.getObjectName() + "_" + attributeName);
                }
                RelationDescriptor relationDescriptor = new RelationDescriptor(attributeName, cardinality, sourceAspectDescriptor, targetAspectDescriptor);
                relationDescriptor.addAttribute("source_ref_attribute", attributeName);
                if (MetamodelHelper.isComplexAttribute(attribute)) {
                    relationDescriptor.addAttribute("complex_attribute", "true");
                    targetAspectDescriptor.addAttribute("complex_attribute", "true");
                }
                if (!(aspect instanceof DataObject) && !(refObject instanceof DataObject)) {
                    relationDescriptor.addAttribute("complex_attribute", "true");
                    targetAspectDescriptor.addAttribute("complex_attribute", "true");
                }
                serviceModuleDescriptor.addRelationDescriptor(relationDescriptor);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(400, location, "addRelationDescriptors(DataStructure, ServiceModuleDescriptor, ClassLoader, List)", e);
        }
    }

    public static boolean isComplexAttribute(Attribute attr) {
        if (attr == null) {
            return false;
        }
        DataStructure dataStructure = attr.getReferencedObject();
        return dataStructure != null && dataStructure instanceof DataObject && ((DataObject)dataStructure).getBusinessEntityInterface() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AspectDescriptor getAspectDescriptor(List mofInterfaces, DataStructure aspect, ServiceModuleDescriptor serviceModuleDescriptor) {
        String method = "getAspectDescriptor(List, DataStructure, ServiceModuleDescriptor)";
        CAFPublicLogger.entering(null, jARMRequest, "getAspectDescriptor(List, DataStructure, ServiceModuleDescriptor)", location, 2);
        try {
            String aspectAppId;
            String appId;
            IAspectDescriptor aspectDesc;
            String aspectName = aspect.getObjectName();
            Application application = aspect.getApplication();
            if (application == null && aspect instanceof DataObject) {
                BusinessEntityInterface businessEntity = ((DataObject)aspect).getBusinessEntityInterface();
                if (businessEntity == null) {
                    AspectDescriptor aspectDescriptor = null;
                    return aspectDescriptor;
                }
                application = businessEntity.getApplication();
            }
            if ((aspectDesc = serviceModuleDescriptor.getAspectDescriptor(aspectName)) != null && (appId = (String)this.aspectsApplicationAndProviderNames.get(aspectDesc)) != null && appId.equals(aspectAppId = application.getProviderName() + "/" + application.getObjectName())) {
                AspectDescriptor aspectDescriptor = (AspectDescriptor)aspectDesc;
                return aspectDescriptor;
            }
            StringBuffer descriptorKeyPrefix = new StringBuffer();
            descriptorKeyPrefix.append(application.getProviderName());
            descriptorKeyPrefix.append("/");
            descriptorKeyPrefix.append(application.getObjectName());
            descriptorKeyPrefix.append("/");
            String prefix = descriptorKeyPrefix.toString();
            int size = mofInterfaces.size();
            for (int i = 0; i < size; ++i) {
                ServiceModuleDescriptor desc;
                MOFInterface entity = (MOFInterface)mofInterfaces.get(i);
                if (!(entity instanceof BusinessEntityInterface)) continue;
                String serviceName = this.getObjectKey(entity);
                if (!(prefix + entity.getObjectName()).equals(serviceName) || (desc = this.getServiceModuleDescriptor(serviceName)).getAspectDescriptor(aspectName) == null) continue;
                AspectDescriptor aspectDescriptor = (AspectDescriptor)desc.getAspectDescriptor(aspectName);
                return aspectDescriptor;
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(400, location, "getAspectDescriptor(List, DataStructure, ServiceModuleDescriptor)", e);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "getAspectDescriptor(List, DataStructure, ServiceModuleDescriptor)", location, 2);
        }
        return null;
    }

    private StructureDescriptor getStructureDescriptor(DataStructure dataStructure, ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader) {
        String method = "getStructureDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader)";
        CAFPublicLogger.entering(null, jARMRequest, "getStructureDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader)", location, 1);
        String structureKey = serviceModuleDescriptor.getName() + "/ASPECT_" + dataStructure.getObjectName();
        StructureDescriptor structureDescriptor = (StructureDescriptor)this.structureDescriptorsCashe.get(structureKey);
        if (structureDescriptor == null) {
            List keys = dataStructure.getKeys();
            List attributes = dataStructure.getAttributes();
            int ks = keys.size();
            ArrayList<FieldDescriptor> fieldsList = new ArrayList<FieldDescriptor>();
            for (int i = 0; i < ks; ++i) {
                Attribute attribute = (Attribute)keys.get(i);
                if (attribute == null || attribute.getReferencedObject() != null || CARDINALITY_N.equals(attribute.getMaxOccurs())) continue;
                String customType = attribute.getTypeJavaDdic();
                fieldsList.add(this.getFieldDescriptor(attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
            }
            if (fieldsList.size() == 0 && dataStructure instanceof DataObject) {
                fieldsList.add(this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null));
            }
            int attrSize = attributes.size();
            for (int i = 0; i < attrSize; ++i) {
                Attribute attribute = (Attribute)attributes.get(i);
                if (attribute == null || attribute.getReferencedObject() != null || CARDINALITY_N.equals(attribute.getMaxOccurs())) continue;
                String customType = attribute.getTypeJavaDdic();
                fieldsList.add(this.getFieldDescriptor(attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
            }
            if ("true".equals(serviceModuleDescriptor.getAttributeStringValue("isClassifiable")) && dataStructure instanceof DataObject && ((DataObject)dataStructure).getBusinessEntityInterface() != null) {
                this.addCategoriesToFieldsList(fieldsList, serviceModuleDescriptor, serviceClassLoader, dataStructure.getObjectName());
            }
            FieldDescriptor[] fields = fieldsList.toArray(new FieldDescriptor[0]);
            String structName = "ASPECT_" + dataStructure.getObjectName();
            structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
            this.structureDescriptorsCashe.put(structureKey, structureDescriptor);
        }
        CAFPublicLogger.exiting(null, jARMRequest, "getStructureDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader)", location, 1);
        return structureDescriptor;
    }

    private KeyAspectDescriptor getKeyAspectDescriptor(DataStructure dataStructure, ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, boolean isUseCashing) {
        String method = "getKeyAspectDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader, boolean)";
        CAFPublicLogger.entering(null, jARMRequest, "getKeyAspectDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader, boolean)", location, 2);
        if (isUseCashing && this.keyAspectDescriptorsCashe.containsKey(serviceModuleDescriptor.getName() + "/KEY_" + dataStructure.getObjectName())) {
            CAFPublicLogger.exiting(null, jARMRequest, "getKeyAspectDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader, boolean)", location, 2);
            return (KeyAspectDescriptor)this.keyAspectDescriptorsCashe.get(serviceModuleDescriptor.getName() + "/KEY_" + dataStructure.getObjectName());
        }
        List attributes = dataStructure.getKeys();
        ArrayList<FieldDescriptor> fieldsList = new ArrayList<FieldDescriptor>();
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            if (attribute == null || attribute.getReferencedObject() != null || CARDINALITY_N.equals(attribute.getMaxOccurs()) || !KEY_ATTRIBUTE_NAME.equals(attribute.getObjectName()) && size != 1) continue;
            fieldsList.add(this.getFieldDescriptor(attribute, dataStructure, serviceModuleDescriptor, serviceClassLoader));
        }
        if (fieldsList.size() == 0 && dataStructure instanceof DataObject) {
            fieldsList.add(this.tfdFactory.getTypedFieldDescriptor(KEY_ATTRIBUTE_NAME, STRING_TYPE, null));
        }
        FieldDescriptor[] fields = fieldsList.toArray(new FieldDescriptor[0]);
        String structName = "ASPECT_KEY_" + dataStructure.getObjectName();
        StructureDescriptor structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
        KeyAspectDescriptor keyAspectDescriptor = new KeyAspectDescriptor(serviceModuleDescriptor, "KEY_" + dataStructure.getObjectName(), dataStructure.getShortText(), structureDescriptor);
        if (isUseCashing) {
            this.keyAspectDescriptorsCashe.put(serviceModuleDescriptor.getName() + "/KEY_" + dataStructure.getObjectName(), keyAspectDescriptor);
        }
        CAFPublicLogger.exiting(null, jARMRequest, "getKeyAspectDescriptor(DataStructure, ServiceModuleDescriptor, ClassLoader, boolean)", location, 2);
        return keyAspectDescriptor;
    }

    private FieldDescriptor getFieldDescriptor(Attribute attribute, DataStructure structure, ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader) {
        return this.getFieldDescriptor(attribute, serviceModuleDescriptor, this.getCustomizedPropertyDescription(serviceModuleDescriptor.getName(), structure.getObjectName(), attribute.getObjectName(), serviceClassLoader), serviceClassLoader);
    }

    private FieldDescriptor getFieldDescriptor(Attribute attribute, Operation operation, ServiceModuleDescriptor serviceModuleDescr, ClassLoader serviceClassLoader) {
        return this.getFieldDescriptor(attribute, serviceModuleDescr, this.getCustomizedParameterDescription(serviceModuleDescr.getName(), operation.getObjectName(), operation.getPatternType(), attribute.getObjectName(), serviceClassLoader), serviceClassLoader);
    }

    private FieldDescriptor getFieldDescriptor(Attribute attribute, ServiceModuleDescriptor serviceModuleDescriptor, String customText, ClassLoader serviceClassLoader) {
        TypedFieldDescriptor fieldDescriptor = this.tfdFactory.getTypedFieldDescriptor(attribute.getObjectName(), null, attribute.getTypeJavaDdic(), serviceClassLoader, this.accessServiceLocale);
        String attrShortText = attribute.getShortText();
        fieldDescriptor.setTextInfo(customText != null ? customText : attrShortText, attrShortText, null, attribute.getLongText());
        return fieldDescriptor;
    }

    private String getCustomizedPropertyDescription(String serviceName, String aspectName, String propName, ClassLoader serviceClassLoader) {
        String method = "getCustomizedPropertyDescription(String, String, String, ClassLoader)";
        try {
            return this.getCustomizedPropertyDescription(serviceName, LocalizationResourceAccessor.getResourceName(serviceName, aspectName, null, null, propName), serviceClassLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCustomizedParameterDescription(String serviceName, String methodName, int methodType, String paramName, ClassLoader serviceClassLoader) {
        String method = "getCustomizedParameterDescription(String, String, int, String, ClassLoader)";
        try {
            String actionName = null;
            String queryName = null;
            if (methodType == 0) {
                actionName = methodName;
            } else if (methodType == 5 || methodType == 8) {
                queryName = methodName;
            } else {
                return null;
            }
            return this.getCustomizedPropertyDescription(serviceName, LocalizationResourceAccessor.getResourceName(serviceName, null, queryName, actionName, paramName), serviceClassLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCustomizedPropertyDescription(String serviceName, String resourceKey, ClassLoader serviceClassLoader) throws Exception {
        return LocalizationResourceAccessor.getCustomizedText(this.accessServiceLocale, resourceKey, serviceName, serviceClassLoader);
    }

    private AspectDescriptor getAspectDescriptor(ServiceModuleDescriptor serviceModuleDesc, DataStructure aspect, StructureDescriptor structure, KeyAspectDescriptor key, boolean isUseCashing, String complexAttributeAspectName) {
        String method = "getAspectDescriptor(ServiceModuleDescriptor, DataStructure, StructureDescriptor, KeyAspectDescriptor, boolean, String)";
        CAFPublicLogger.entering(null, jARMRequest, "getAspectDescriptor(ServiceModuleDescriptor, DataStructure, StructureDescriptor, KeyAspectDescriptor, boolean, String)", location, 2);
        String name = aspect.getObjectName();
        String description = aspect.getShortText();
        if (complexAttributeAspectName != null) {
            name = complexAttributeAspectName;
        }
        if (isUseCashing && this.aspectDescriptorsCashe.containsKey(serviceModuleDesc.getName() + "/" + name)) {
            CAFPublicLogger.exiting(null, jARMRequest, "getAspectDescriptor(ServiceModuleDescriptor, DataStructure, StructureDescriptor, KeyAspectDescriptor, boolean, String)", location, 2);
            return (AspectDescriptor)this.aspectDescriptorsCashe.get(serviceModuleDesc.getName() + "/" + name);
        }
        AspectDescriptor aspectDescriptor = new AspectDescriptor(serviceModuleDesc, name, description, structure, key);
        if (aspect instanceof DataObject) {
            aspectDescriptor.addAttribute(BE_DO_MOFID_PARAM_NAME, aspect.getObjectId());
        }
        if (isUseCashing) {
            this.aspectDescriptorsCashe.put(serviceModuleDesc.getName() + "/" + name, aspectDescriptor);
            Application app = aspect.getApplication();
            if (app == null && aspect instanceof DataObject) {
                app = ((DataObject)aspect).getBusinessEntityInterface().getApplication();
            }
            if (app != null) {
                this.aspectsApplicationAndProviderNames.put(aspectDescriptor, app.getProviderName() + "/" + app.getObjectName());
            }
        }
        this.createEmptySubmitAction(aspectDescriptor, serviceModuleDesc);
        CAFPublicLogger.exiting(null, jARMRequest, "getAspectDescriptor(ServiceModuleDescriptor, DataStructure, StructureDescriptor, KeyAspectDescriptor, boolean, String)", location, 2);
        return aspectDescriptor;
    }

    private void createEmptySubmitAction(AspectDescriptor aspectDescriptor, ServiceModuleDescriptor serviceModuleDescriptor) {
        FieldDescriptor[] fields = new FieldDescriptor[]{};
        String structName = "STRUCTURE_$submit$";
        StructureDescriptor structureDescriptor = new StructureDescriptor(serviceModuleDescriptor, structName, fields);
        aspectDescriptor.addAspectActionDescriptor(new AspectActionDescriptor(ASPECT_SUBMIT_ACTION_NAME, structureDescriptor, aspectDescriptor));
    }

    private ClassLoader getClassLoader(ServiceModuleDescriptor serviceModuleDescriptor) {
        String method = "getClassLoader(ServiceModuleDescriptor)";
        CAFPublicLogger.entering(null, JARM_REQUEST, "getClassLoader(ServiceModuleDescriptor)", location);
        ClassLoader result = null;
        String jndiName = this.getServiceJNDI_KEY(serviceModuleDescriptor.getName());
        try {
            InitialContext ic = new InitialContext();
            Object lh = ic.lookup(jndiName);
            result = lh.getClass().getClassLoader();
        }
        catch (NamingException e) {
            CAFPublicLogger.traceThrowable(500, location, "getClassLoader(ServiceModuleDescriptor)", e);
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, "getClassLoader(ServiceModuleDescriptor)", location);
        return result;
    }

    private boolean isCRUDOperation(Operation operation) {
        Integer patternType;
        return operation != null && (patternType = operation.getPatternType()) != null && patternType >= 1 && patternType <= 4;
    }

    private boolean checkOperation(Operation op) {
        if (!this.isCRUDOperation(op)) {
            List inputMessageAttributes;
            String attrType;
            Attribute attr;
            int j;
            int size;
            List outputMessageAttributes;
            Message outputMessage = op.getOutput();
            Message inputMessage = op.getInput();
            if (outputMessage != null && (outputMessageAttributes = outputMessage.getMessageParts()) != null) {
                size = outputMessageAttributes.size();
                for (j = 0; j < size; ++j) {
                    attr = (Attribute)outputMessageAttributes.get(j);
                    if (attr == null) continue;
                    attrType = attr.getTypeJavaDdic();
                    if (attr.getReferencedObject() != null || attrType != null && !INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) && !INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType)) continue;
                    return false;
                }
            }
            if (inputMessage != null && (inputMessageAttributes = inputMessage.getMessageParts()) != null) {
                size = inputMessageAttributes.size();
                for (j = 0; j < size; ++j) {
                    attr = (Attribute)inputMessageAttributes.get(j);
                    if (attr == null) continue;
                    attrType = attr.getTypeJavaDdic();
                    if (attr.getReferencedObject() != null || attrType != null && !INVALID_ATTRIBUTE_DICT_TYPE_0.equals(attrType) && !INVALID_ATTRIBUTE_DICT_TYPE_1.equals(attrType)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction() throws Exception {
        String method = "startTransaction()";
        CAFPublicLogger.entering(null, jARMRequest, "startTransaction()", location, 2);
        try {
            UserTransaction t = CAFServiceAccessBeanImpl.getTransaction();
            if (!CAFServiceAccessBeanImpl.isTransactionAlive(t)) {
                t.begin();
            }
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "startTransaction()", location, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCategoriesToFieldsList(List fieldsList, ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, String dataObjectName) {
        String method = "addCategoriesToFieldsList(List, ServiceModuleDescriptor, ClassLoader)";
        CAFPublicLogger.entering(null, jARMRequest, "addCategoriesToFieldsList(List, ServiceModuleDescriptor, ClassLoader)", location, 2);
        try {
            this.startTransaction();
            Collection categories = this.getServiceModuleCategories(serviceModuleDescriptor);
            if (categories != null) {
                int categoryNameCounter = 0;
                Iterator iter = categories.iterator();
                while (iter.hasNext()) {
                    IDependentObject currentCategory = (IDependentObject)iter.next();
                    String paramName = CATEGORY_NAME_START + categoryNameCounter;
                    String categoryID = (String)currentCategory.getProperty(PARAM_NAME_CATEGORY_ID);
                    if (categoryID != null && !INVALID_ATTRIBUTE_DICT_TYPE_0.equals(categoryID)) {
                        String categoryDescription = (String)currentCategory.getProperty(PARAM_NAME_CATEGORY_DESCRIPTION);
                        String cType = "category" + categoryID;
                        TypedFieldDescriptor fd = this.tfdFactory.getTypedFieldDescriptor(paramName, null, cType, serviceClassLoader, this.accessServiceLocale);
                        String customText = this.getCustomizedPropertyDescription(serviceModuleDescriptor.getName(), dataObjectName, fd.getName(), serviceClassLoader);
                        fd.setTextInfo(customText != null ? customText : categoryDescription, categoryDescription, categoryDescription, cType);
                        fd.setCategoryID(categoryID);
                        fieldsList.add(fd);
                    }
                    ++categoryNameCounter;
                }
            }
        }
        catch (Exception ex) {
            CAFPublicLogger.traceThrowable(400, location, "addCategoriesToFieldsList(List, ServiceModuleDescriptor, ClassLoader)", ex);
        }
        finally {
            CAFPublicLogger.exiting(null, jARMRequest, "addCategoriesToFieldsList(List, ServiceModuleDescriptor, ClassLoader)", location, 2);
        }
    }

    private Collection getServiceModuleCategories(ServiceModuleDescriptor serviceModuleDescriptor) {
        String method = "getServiceModuleCategories(ServiceModuleDescriptor)";
        Collection result = null;
        try {
            InitialContext ic = new InitialContext();
            Object home = ic.lookup(CATEGORY_SERVICE_JNDI_NAME);
            Method cr_meth = home.getClass().getMethod("create", new Class[0]);
            Object createdService = cr_meth.invoke(home, new Object[0]);
            Method findCatByName_meth = createdService.getClass().getMethod("findCategoryByBOName", class$java$lang$String == null ? (class$java$lang$String = MetamodelHelper.class$("java.lang.String")) : class$java$lang$String);
            if (findCatByName_meth != null) {
                String bOName = serviceModuleDescriptor.getAttributeStringValue("BusinessEntityName");
                result = (Collection)findCatByName_meth.invoke(createdService, bOName);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable(500, location, "getServiceModuleCategories(ServiceModuleDescriptor)", e);
        }
        return result;
    }

    private void addKMMethods(ServiceModuleDescriptor serviceModuleDescriptor, ClassLoader serviceClassLoader, KeyAspectDescriptor keyAspectDescriptor, StructureDescriptor inputParameters, AspectDescriptor resultDescriptor) {
        if (serviceModuleDescriptor.getQueryDescriptor(FIND_BY_KM_PROPERTY_SEARCH_NAME) == null) {
            ArrayList<TypedFieldDescriptor> fieldsList = new ArrayList<TypedFieldDescriptor>();
            IFieldDescriptor[] fields = inputParameters.getFieldDescriptors();
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    TypedFieldDescriptor fd = (TypedFieldDescriptor)fields[i];
                    if (KEY_ATTRIBUTE_NAME.equalsIgnoreCase(fd.getName())) continue;
                    TypedFieldDescriptor newFd = this.tfdFactory.getTypedFieldDescriptor(fd.getName(), null, fd.getCustomType(), serviceClassLoader, this.accessServiceLocale);
                    String customText = this.getCustomizedParameterDescription(serviceModuleDescriptor.getName(), FIND_BY_KM_PROPERTY_SEARCH_NAME, PATTERN_FIND_BY, fd.getName(), serviceClassLoader);
                    newFd.setTextInfo(customText != null ? customText : fd.getText(0), fd.getText(1), fd.getText(2), fd.getText(3));
                    newFd.setCategoryID(fd.getCategoryID());
                    fieldsList.add(newFd);
                }
            }
            FieldDescriptor[] newFields = fieldsList.toArray(new FieldDescriptor[0]);
            StructureDescriptor inputStructureDescriptor = new StructureDescriptor(serviceModuleDescriptor, "findByKMPropertySearch_input", newFields);
            QueryDescriptor queryDescriptor = new QueryDescriptor(FIND_BY_KM_PROPERTY_SEARCH_NAME, "Performs full text search by BO properties in KM index", keyAspectDescriptor, inputStructureDescriptor, resultDescriptor, serviceModuleDescriptor);
            queryDescriptor.addAttribute(FIND_BY_KM_PROPERTY_SEARCH_NAME, "true");
            serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
        }
        if (serviceModuleDescriptor.getQueryDescriptor(SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME) == null) {
            FieldDescriptor[] fields = new FieldDescriptor[]{this.tfdFactory.getTypedFieldDescriptor("freeText", STRING_TYPE, serviceClassLoader)};
            String customText = this.getCustomizedParameterDescription(serviceModuleDescriptor.getName(), SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME, PATTERN_FIND_BY, "freeText", serviceClassLoader);
            fields[0].setTextInfo(customText != null ? customText : "Free text", "Free text", null, "Free text");
            StructureDescriptor inputParametersSearchIdx = new StructureDescriptor(serviceModuleDescriptor, "searchidxForBOInRelatedDoc_input", fields);
            QueryDescriptor queryDescriptor = new QueryDescriptor(SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME, "Performs search by free text in KM", keyAspectDescriptor, inputParametersSearchIdx, resultDescriptor, serviceModuleDescriptor);
            queryDescriptor.addAttribute(SEARCH_IDX_FOR_BO_IN_RELATED_DOC_NAME, "true");
            serviceModuleDescriptor.addQueryDescriptor(queryDescriptor);
        }
    }

    private void addAttributeIfServiceIsClassifiable(MOFInterface mofInterfaceImpl, ServiceModuleDescriptor serviceModuleDescriptor) {
        if (mofInterfaceImpl instanceof BusinessEntityInterface && ((BusinessEntityInterface)mofInterfaceImpl).isClassifiable() != null && ((BusinessEntityInterface)mofInterfaceImpl).isClassifiable().booleanValue()) {
            serviceModuleDescriptor.addAttribute("isClassifiable", "true");
        }
    }

    public String getServiceFullName(String provider, String application, String service) {
        StringBuffer descriptorKeyPrefix = new StringBuffer();
        descriptorKeyPrefix.append(provider);
        descriptorKeyPrefix.append("/");
        descriptorKeyPrefix.append(application);
        descriptorKeyPrefix.append("/");
        descriptorKeyPrefix.append(service);
        return descriptorKeyPrefix.toString();
    }

    public String getProviderFromServiceFullName(String moduleName) {
        int firstIndex = moduleName.indexOf("/");
        if (firstIndex == -1) {
            return null;
        }
        return moduleName.substring(0, firstIndex);
    }

    public String getApplicationFromServiceFullName(String moduleName) {
        int firstIndex = moduleName.indexOf("/");
        if (firstIndex == -1) {
            return null;
        }
        String withoutProvider = moduleName.substring(firstIndex + 1);
        int secondIndex = withoutProvider.indexOf("/");
        if (secondIndex == -1) {
            return null;
        }
        return withoutProvider.substring(0, secondIndex);
    }

    public String getServiceFromServiceFullName(String moduleName) {
        int firstIndex = moduleName.indexOf("/");
        if (firstIndex == -1) {
            return moduleName;
        }
        String withoutProvider = moduleName.substring(firstIndex + 1);
        int secondIndex = withoutProvider.indexOf("/");
        if (secondIndex == -1) {
            return withoutProvider;
        }
        return withoutProvider.substring(secondIndex + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

