/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.publish;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PublishingBean
implements SessionBean {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$services$publish$PublishingBean == null ? (class$com$sap$caf$rt$services$publish$PublishingBean = PublishingBean.class$("com.sap.caf.rt.services.publish.PublishingBean")) : class$com$sap$caf$rt$services$publish$PublishingBean));
    private static final String JARM_REQUEST = "CAF:RT:oal";
    private static final String CHANGE = "BUSINESS_OBJECT_CHANGED";
    private static final String REMOVE = "BUSINESS_OBJECT_REMOVED";
    private static final String CREATE = "BUSINESS_OBJECT_CREATED";
    private static final String[] msgTemplate = new String[]{"OBJTYPE", "KEY", "RID", "USEDBY"};
    private String CF_NAME = CAFContext.JNDI_NAME_JMS;
    private static final String XAPPS_TOPIC = CAFContext.JNDI_NAME_JMS_TOPIC;
    private Topic topic = null;
    private TopicSession session = null;
    private TopicPublisher pub = null;
    private TopicConnectionFactory cf = null;
    private TopicConnection conn = null;
    private Context context = null;
    private SessionContext myContext;
    static /* synthetic */ Class class$com$sap$caf$rt$services$publish$PublishingBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbRemove() {
        String method = "ejbRemove()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            this.pub.close();
            this.session.close();
            this.conn.close();
        }
        catch (JMSException ex) {
            CAFPublicLogger.traceThrowableT(100, location, method, "JMSException in connection close", ex);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbActivate() {
        String method = "ejbActivate()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            this.context = new InitialContext();
            this.cf = (TopicConnectionFactory)this.context.lookup(this.CF_NAME);
            this.conn = this.cf.createTopicConnection();
            this.topic = (Topic)this.context.lookup(XAPPS_TOPIC);
            this.session = this.conn.createTopicSession(false, 1);
            this.pub = this.session.createPublisher(this.topic);
        }
        catch (NamingException e) {
            Object[] args = new Object[]{this.CF_NAME, XAPPS_TOPIC};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0} using topic {1}", args, (Throwable)e);
        }
        catch (JMSException e) {
            CAFPublicLogger.traceThrowableT(100, location, method, "JMSException in ejbActivate", e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ejbPassivate() {
        String method = "ejbPassivate()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            this.pub.close();
            this.session.close();
            this.conn.close();
        }
        catch (JMSException ex) {
            CAFPublicLogger.traceThrowableT(100, location, method, "JMSException in connection close", ex);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public void setSessionContext(SessionContext context) {
        this.myContext = context;
    }

    public void ejbCreate() throws CreateException, BEException {
        String method = "ejbCreate()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            this.context = new InitialContext();
            this.cf = (TopicConnectionFactory)this.context.lookup(this.CF_NAME);
            this.conn = this.cf.createTopicConnection();
            this.topic = (Topic)this.context.lookup(XAPPS_TOPIC);
            this.session = this.conn.createTopicSession(false, 1);
            this.pub = this.session.createPublisher(this.topic);
        }
        catch (NamingException e) {
            Object[] args = new Object[]{this.CF_NAME, XAPPS_TOPIC};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0} using topic {1}", args, (Throwable)e);
            throw new BEException(e);
        }
        catch (JMSException e) {
            Object[] args = new Object[]{this.CF_NAME, XAPPS_TOPIC};
            CAFPublicLogger.traceThrowableT(100, location, method, "JMSException in ejbCreate using JNDI name : {0} topic : {1}", args, e);
            throw new BEException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public void publishCreated(Object[] args) throws BEException {
        this.publish(args, CREATE);
    }

    public void publishChanged(Object[] args) throws BEException {
        this.publish(args, CHANGE);
    }

    public void publishRemoved(Object[] args) throws BEException {
        this.publish(args, REMOVE);
    }

    private void publish(Object[] args, String action) throws BEException {
        String method = "publish(Object[], action)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{args, action}, 1);
        try {
            Message msg = this.session.createMessage();
            msg.setStringProperty("ACTION", action);
            for (int i = 0; i < msgTemplate.length; ++i) {
                msg.setStringProperty(msgTemplate[i], args[i].toString());
            }
            this.pub.publish(msg);
        }
        catch (JMSException e) {
            Object[] arg = new Object[]{args, action};
            CAFPublicLogger.traceThrowableT(100, location, method, "JMSException in publish using arguments : {0} action : {1}", arg, e);
            throw new BEException("CAF_INVALID_INPUT", null, e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

