/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.ISubscrFilter;
import com.sap.caf.rt.services.notify.subscr.ISubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.ISubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.Subscription;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistUtils;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrFilter;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrRecipients;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrPrefsFactory;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class PersistSubscription
extends Subscription
implements IPersistSubscription {
    private boolean m_bActive = true;
    private IPersistState m_state = new PersistState();
    private Object m_key;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrRecipients;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrTemplate;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter;
    static /* synthetic */ Class class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrFilter;

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        Map values = SQLUtils.loadObjValues(manager, "SELECT ID,GROUP_ID,IS_ENABLED,DESCR FROM CAF_RT_NS_SUBSCR WHERE (SUBSCR_KEY=?)", ISQLNames.SELECT_SUBSCR_TYPES, this);
        this.setId((String)values.get("ID"));
        this.setGroupId((String)values.get("GROUP_ID"));
        this.setEnabled(SQLUtils.INT_1.equals((Integer)values.get("IS_ENABLED")));
        this.setDescription((String)values.get("DESCR"));
        this.setFilter(this.loadFilter(manager));
        this.setTemplate(this.loadTemplate(manager));
        this.setRecipients(this.loadRecipients(manager));
    }

    private ISubscrRecipients loadRecipients(ISQLPersistManager manager) throws PersistException {
        List rows = SQLUtils.execSelect(manager, "SELECT RECIP_KEY,CLASS_NAME FROM CAF_RT_NS_RECIP WHERE (SUBSCR_KEY=?)", ISQLNames.SELECT_RECIP_KEY_TYPES, new Object[]{this.getKey()});
        if (rows == null || rows.size() == 0) {
            throw new PersistException("CANT_LOAD_INCL_SUBSCR_RECIP", new Object[]{this.getKey()});
        }
        Map row = (Map)rows.get(0);
        String className = (String)row.get("CLASS_NAME");
        IPersistSubscrRecipients recip = (IPersistSubscrRecipients)this.newObject(className, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrRecipients")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrRecipients == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrRecipients = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrRecipients")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrRecipients);
        recip.setSubscription(this);
        recip.setKey(row.get("RECIP_KEY"));
        manager.load(recip);
        return recip;
    }

    protected ISubscrTemplate loadTemplate(ISQLPersistManager manager) throws PersistException {
        List rows = SQLUtils.execSelect(manager, "SELECT TEMPL_KEY,CLASS_NAME FROM CAF_RT_NS_TMPL WHERE (SUBSCR_KEY=?)", ISQLNames.SELECT_TEMPL_KEY_TYPES, new Object[]{this.getKey()});
        if (rows == null || rows.size() == 0) {
            throw new PersistException("CANT_LOAD_SUBSCR_TEMPL", new Object[]{this.getKey()});
        }
        Map row = (Map)rows.get(0);
        String className = (String)row.get("CLASS_NAME");
        IPersistSubscrTemplate templ = (IPersistSubscrTemplate)this.newObject(className, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrTemplate")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrTemplate == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrTemplate = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrTemplate")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrTemplate);
        templ.setSubscription(this);
        templ.setKey(row.get("TEMPL_KEY"));
        manager.load(templ);
        return templ;
    }

    protected ISubscrFilter loadFilter(ISQLPersistManager manager) throws PersistException {
        List rows = SQLUtils.execSelect(manager, "SELECT FILTER_KEY,CLASS_NAME FROM CAF_RT_NS_FLT WHERE (SUBSCR_KEY=?)", ISQLNames.SELECT_FLT_KEYS_TYPES, new Object[]{this.getKey()});
        if (rows == null || rows.size() == 0) {
            throw new PersistException("CANT_LOAD_SUBSCR_FLT", new Object[]{this.getKey()});
        }
        Map row = (Map)rows.get(0);
        String className = (String)row.get("CLASS_NAME");
        IPersistSubscrFilter filter = (IPersistSubscrFilter)this.newObject(className, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrFilter")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter, class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrFilter == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrFilter = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrFilter")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$PersistSubscrFilter);
        filter.setSubscription(this);
        filter.setKey(row.get("FILTER_KEY"));
        manager.load(filter);
        return filter;
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        Node root = manager.getCurrentNode();
        Map nodes = XMLUtils.getNodesAsMap(root);
        Map attrs = XMLUtils.getAttributes(root);
        ClassLoader classLoader = this.getClassLoader();
        Properties props = this.getApplication().getProperties();
        String resName = ((IPersistApplication)this.getApplication()).getResourceName();
        this.setId(XMLUtils.getStrChildNodeValue(root, attrs, "id", true));
        this.setEnabled(PersistUtils.resolveBoolPropRef(XMLUtils.getStrChildNodeValue(root, attrs, "active", true), props));
        this.setDescription(PersistUtils.resolveResRef(XMLUtils.getStrChildNodeValue(root, nodes, "description", true), resName, classLoader));
        this.setGroupId(XMLUtils.getStrChildNodeValue(root, nodes, "group", true));
        this.setFilter(this.loadFilter(manager, root, nodes));
        this.setTemplate(this.loadTemplate(manager, root, nodes));
        this.setRecipients(this.loadRecipients(manager, root, nodes));
    }

    protected IPersistSubscrFilter loadFilter(IXMLPersistManager manager, Node root, Map nodes) throws PersistException {
        Node node = XMLUtils.getNode(root, nodes, "filter", true);
        String className = XMLUtils.getStrNodeAttrValue(node, "class", true);
        IPersistSubscrFilter filter = (IPersistSubscrFilter)PersistUtils.newObject(className, this.getClassLoader(), class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrFilter")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrFilter);
        filter.setSubscription(this);
        manager.load(node, filter);
        return filter;
    }

    protected IPersistSubscrTemplate loadTemplate(IXMLPersistManager manager, Node root, Map nodes) throws PersistException {
        Node node = XMLUtils.getNode(root, nodes, "template", true);
        String className = XMLUtils.getStrNodeAttrValue(node, "class", true);
        IPersistSubscrTemplate template = (IPersistSubscrTemplate)PersistUtils.newObject(className, this.getClassLoader(), class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrTemplate")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrTemplate);
        template.setSubscription(this);
        template.setId(this.getId());
        manager.load(node, template);
        return template;
    }

    protected IPersistSubscrRecipients loadRecipients(IXMLPersistManager manager, Node root, Map nodes) throws PersistException {
        Node node = XMLUtils.getNode(root, nodes, "recipients", true);
        String className = XMLUtils.getStrNodeAttrValue(node, "class", true);
        IPersistSubscrRecipients recip = (IPersistSubscrRecipients)PersistUtils.newObject(className, this.getClassLoader(), class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrRecipients")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients);
        recip.setSubscription(this);
        manager.load(node, recip);
        return recip;
    }

    protected IPersistSubscrRecipients loadExclRecipients(IXMLPersistManager manager, Node root, Map nodes) throws PersistException {
        Node node = XMLUtils.getNode(root, nodes, "excluded-recipients", false);
        if (node == null) {
            return null;
        }
        String className = XMLUtils.getStrNodeAttrValue(node, "class", false);
        if (className == null) {
            return null;
        }
        IPersistSubscrRecipients recip = (IPersistSubscrRecipients)PersistUtils.newObject(className, this.getClassLoader(), class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients == null ? (class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients = PersistSubscription.class$("com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrRecipients")) : class$com$sap$caf$rt$services$notify$subscr$persist$subscr$IPersistSubscrRecipients);
        recip.setSubscription(this);
        manager.load(node, recip);
        return recip;
    }

    public void store(IPersistManager manager) throws PersistException {
        if (!this.isActive()) {
            throw new PersistException("CANT_STORE_INACTIVE", new Object[]{this.getKey()});
        }
        if (manager instanceof ISQLPersistManager) {
            this.store((ISQLPersistManager)manager);
        }
    }

    protected void store(ISQLPersistManager manager) throws PersistException {
        SQLUtils.execUpdate(manager, "UPDATE CAF_RT_NS_SUBSCR SET APP_KEY=?,ID=?,GROUP_ID=?,IS_ENABLED=?,DESCR=? WHERE (SUBSCR_KEY=?)", ISQLNames.UPDATE_SUBSCR_TYPES, new Object[]{((ISQLPersistEntity)((Object)this.getApplication())).getKey(), this.getId(), this.getGroupId(), this.isEnabled() ? SQLUtils.INT_1 : SQLUtils.INT_0, this.getDescription(), this.getKey()});
        manager.store((IPersistEntity)((Object)this.getFilter()));
        manager.store((IPersistEntity)((Object)this.getTemplate()));
        manager.store((IPersistEntity)((Object)this.getRecipients()));
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            Object key = this.getKey();
            PersistSubscrPrefsFactory prefsFactory = (PersistSubscrPrefsFactory)PersistSubscrPrefsFactory.getInstance();
            prefsFactory.deleteSubscrPrefs(key);
            manager.delete((IPersistEntity)((Object)this.getFilter()));
            manager.delete((IPersistEntity)((Object)this.getTemplate()));
            manager.delete((IPersistEntity)((Object)this.getRecipients()));
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_SUBSCR WHERE (SUBSCR_KEY=?)", ISQLNames.DELETE_SUBSCR_TYPES, new Object[]{key});
        }
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_SUBSCR (SUBSCR_KEY,APP_KEY,ID,GROUP_ID,IS_ENABLED,DESCR) VALUES (?,?,?,?,?,?)", ISQLNames.INSERT_SUBSCR_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getApplication())).getKey(), this.getId(), this.getGroupId(), this.isEnabled() ? SQLUtils.INT_1 : SQLUtils.INT_0, this.getDescription()});
            manager.create((IPersistEntity)((Object)this.getFilter()));
            manager.create((IPersistEntity)((Object)this.getTemplate()));
            manager.create((IPersistEntity)((Object)this.getRecipients()));
        }
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public ClassLoader getClassLoader() {
        return this.getApplication().getClassLoader();
    }

    public void setDescription(String descr) {
        super.setDescription(descr);
        this.getState().setUpdated(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getState().setUpdated(true);
    }

    public void setGroupId(String groupId) {
        super.setGroupId(groupId);
        this.getState().setUpdated(true);
    }

    public void setId(String id) {
        super.setId(id);
        this.getState().setUpdated(true);
    }

    public boolean isActive() {
        if (!this.m_bActive) {
            return false;
        }
        IApplication app = this.getApplication();
        boolean isAppActive = app != null ? app.isActive() : false;
        return isAppActive;
    }

    public void setActive(boolean active) {
        this.m_bActive = active;
    }

    protected Object newObject(String className, Class classType, Class defClassType) throws PersistException {
        ClassLoader classLoader = this.getClassLoader();
        try {
            return PersistUtils.newObject(className, classLoader, classType);
        }
        catch (PersistException e) {
            Log.fatal("CANT_LOAD_CLASS", new Object[]{className});
            if (Log.isDebugEnabled()) {
                Log.debug("Can not load class", (Throwable)((Object)e));
            }
            this.setActive(false);
            return PersistUtils.newObject(defClassType.getName(), classLoader, defClassType);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

