/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.subscr.SubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistUtils;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.state.PersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.xml.MissedAttrException;
import com.sap.caf.rt.services.notify.subscr.persist.xml.MissedValueException;
import com.sap.caf.rt.services.notify.subscr.persist.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class PersistSubscrTemplate
extends SubscrTemplate
implements IPersistSubscrTemplate {
    private Object m_key;
    private IPersistState m_state = new PersistState();
    private String m_sLocSubj;

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        Map values = SQLUtils.loadObjValues(manager, "SELECT ID,SUBJECT FROM CAF_RT_NS_TMPL WHERE (TEMPL_KEY=?)", ISQLNames.SELECT_TEMPL_TYPES, this);
        this.setId((String)values.get("ID"));
        this.setSubject((String)values.get("SUBJECT"));
        this.setProperties(this.loadProperties(manager));
    }

    protected Properties loadProperties(ISQLPersistManager manager) throws PersistException {
        Map map = SQLUtils.loadMap(manager, "SELECT NAME,VAL FROM CAF_RT_NS_TMPLPROP WHERE (TEMPL_KEY=?)", ISQLNames.SELECT_TEMPLPROP_TYPES, new Object[]{this.getKey()});
        Properties props = new Properties();
        props.putAll((Map<?, ?>)map);
        return props;
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        Node root = manager.getCurrentNode();
        this.setSubject(XMLUtils.getStrChildNodeValue(root, "subject", true));
        this.loadProperties(XMLUtils.getNodesAsList(XMLUtils.getChildNode(root, "properties", true), "property"));
    }

    protected void loadProperties(List nodes) throws MissedValueException, MissedAttrException, PersistException {
        if (nodes != null) {
            IPersistApplication app = (IPersistApplication)this.getSubscription().getApplication();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                this.addProperty(XMLUtils.getStrNodeAttrValue(node, "name", true), PersistUtils.resolveRef(XMLUtils.getStrNodeValue(node, true), app));
            }
        }
    }

    public void create(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.setKey(SQLUtils.createKey());
            SQLUtils.execUpdate(sqlManager, "INSERT INTO CAF_RT_NS_TMPL (TEMPL_KEY,SUBSCR_KEY,ID,CLASS_NAME,SUBJECT) VALUES (?,?,?,?,?)", ISQLNames.INSERT_TEMPL_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getId(), this.getClass().getName(), this.getSubject()});
            this.createProperties(sqlManager);
        }
    }

    protected void createProperties(ISQLPersistManager manager) throws PersistException {
        Properties props = this.getProperties();
        Iterator<Map.Entry<Object, Object>> itr = props.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> prop = itr.next();
            this.createProperty(manager, prop);
        }
    }

    protected void createProperty(ISQLPersistManager manager, Map.Entry property) throws PersistException {
        SQLUtils.execUpdate(manager, "INSERT INTO CAF_RT_NS_TMPLPROP (TEMPL_KEY,NAME,VAL) VALUES (?,?,?)", ISQLNames.INSERT_TEMPLPROP_TYPES, new Object[]{this.getKey(), property.getKey(), property.getValue()});
    }

    public void delete(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            this.deleteProperties(sqlManager);
            SQLUtils.execUpdate(sqlManager, "DELETE FROM CAF_RT_NS_TMPL WHERE (TEMPL_KEY=? AND SUBSCR_KEY=?)", ISQLNames.DELETE_TEMPL_TYPES, new Object[]{this.getKey(), ((ISQLPersistEntity)((Object)this.getSubscription())).getKey()});
        }
    }

    protected void deleteProperties(ISQLPersistManager manager) throws PersistException {
        SQLUtils.execUpdate(manager, "DELETE FROM CAF_RT_NS_TMPLPROP WHERE (TEMPL_KEY=?)", ISQLNames.DELETE_TEMPLPROP_TEMPL_TYPES, new Object[]{this.getKey()});
    }

    protected void deleteProperty(ISQLPersistManager manager, Map.Entry property) throws PersistException {
        SQLUtils.execUpdate(manager, "DELETE FROM CAF_RT_NS_TMPLPROP WHERE (TEMPL_KEY=? AND NAME=?)", ISQLNames.DELETE_TEMPLPROP_TYPES, new Object[]{this.getKey(), property.getKey()});
    }

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            ISQLPersistManager sqlManager = (ISQLPersistManager)manager;
            SQLUtils.execUpdate(sqlManager, "UPDATE CAF_RT_NS_TMPL SET SUBSCR_KEY=?,ID=?,CLASS_NAME=?,SUBJECT=? WHERE (TEMPL_KEY=?)", ISQLNames.UPDATE_TEMPL_TYPES, new Object[]{((ISQLPersistEntity)((Object)this.getSubscription())).getKey(), this.getId(), this.getClass().getName(), this.getSubject(), this.getKey()});
            this.storeProperties(sqlManager);
        }
    }

    protected void storeProperties(ISQLPersistManager manager) throws PersistException {
        Properties oldProps = this.loadProperties(manager);
        Properties newProps = this.getProperties();
        if (!newProps.isEmpty()) {
            Iterator itr = newProps.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry newProp = itr.next();
                Object newKey = newProp.getKey();
                if (oldProps.containsKey(newKey)) {
                    if (!oldProps.get(newKey).equals(newProp.getValue())) {
                        this.updateProperty(manager, newProp);
                    }
                    oldProps.remove(newKey);
                    continue;
                }
                this.createProperty(manager, newProp);
            }
        }
        if (!oldProps.isEmpty()) {
            Iterator itr = oldProps.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry oldProp = itr.next();
                this.deleteProperty(manager, oldProp);
            }
        }
    }

    protected void updateProperty(ISQLPersistManager manager, Map.Entry property) throws PersistException {
        SQLUtils.execUpdate(manager, "UPDATE CAF_RT_NS_TMPLPROP SET VAL=? WHERE (TEMPL_KEY=? AND NAME=?)", ISQLNames.UPDATE_TEMPLPROP_TYPES, new Object[]{property.getValue(), this.getKey(), property.getKey()});
    }

    public synchronized String getLocalizedSubject() {
        String subj = this.getSubject();
        if (this.m_sLocSubj == null && subj != null && !subj.equals(this.m_sLocSubj)) {
            String resKey;
            this.m_sLocSubj = subj;
            if (subj != null && subj.length() != 0 && (resKey = PersistUtils.getReferenceKey(subj)) != null) {
                String resName = this.getResourceName();
                this.m_sLocSubj = resName != null ? PersistUtils.getLocalizedMessage(resName, resKey, null, this.getClassLoader()) : subj;
            }
        }
        return this.m_sLocSubj;
    }

    private String getResourceName() {
        return ((IPersistApplication)this.getSubscription().getApplication()).getResourceName();
    }

    protected ClassLoader getClassLoader() {
        return ((IPersistSubscription)this.getSubscription()).getApplication().getClassLoader();
    }

    public IPersistState getState() {
        return this.m_state;
    }

    public Object getKey() {
        return this.m_key;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public void setSubject(String subject) {
        super.setSubject(subject);
        this.m_sLocSubj = null;
        this.getState().setUpdated(true);
    }

    public void setId(String id) {
        super.setId(id);
        this.getState().setUpdated(true);
    }

    public void addProperty(String name, String value) {
        super.addProperty(name, value);
        this.getState().setUpdated(true);
    }

    public void removeProperty(String name) {
        super.removeProperty(name);
        this.getState().setUpdated(true);
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.getState().setUpdated(true);
    }
}

