/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.SubscrPrefsFactory;
import com.sap.caf.rt.services.notify.subscr.app.registered.RegisteredSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistObjNotFoundException;
import com.sap.caf.rt.services.notify.subscr.persist.SubscrNotExistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefsFactory;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrPrefs;
import com.sap.security.api.IUser;

public class PersistSubscrPrefsFactory
extends SubscrPrefsFactory
implements IPersistSubscrPrefsFactory {
    private static IPersistSubscrPrefsFactory s_factory;

    protected PersistSubscrPrefsFactory() {
    }

    public static synchronized IPersistSubscrPrefsFactory getInstance() {
        if (s_factory == null) {
            s_factory = new PersistSubscrPrefsFactory();
        }
        return s_factory;
    }

    public IPersistSubscrPrefs getSubscrPrefs(IPersistSubscription subscr, IUser user) throws PersistException {
        PersistSubscrPrefs prefs = new PersistSubscrPrefs(subscr, user);
        try {
            IPersistManager manager = this.getPersistManager();
            manager.begin();
            try {
                manager.load(prefs);
                manager.commit();
                return prefs;
            }
            catch (PersistObjNotFoundException e) {
                manager.revert();
                if (Log.isDebugEnabled()) {
                    Log.debug("No prefs for subscr:[" + subscr.getId() + "] and user:[" + user.getUniqueID() + "], cause:[" + e.getMessage() + "]");
                }
                return null;
            }
            catch (PersistException e) {
                manager.revert();
                throw e;
            }
        }
        catch (PersistException e) {
            throw new PersistException("CANT_GET_SUBSCR_PREF", new Object[]{subscr.getId(), user.getUniqueID()}, (Throwable)((Object)e));
        }
    }

    public IPersistSubscrPrefs createSubscrPrefs(IPersistSubscription subscr, IUser user) throws PersistException {
        return new PersistSubscrPrefs(subscr, user);
    }

    public void deleteSubscrPrefs(IPersistSubscrPrefs pref) throws PersistException {
        pref.getState().setDeleted(true);
        this.storeSubscrPrefs(pref);
    }

    void deleteSubscrPrefs(Object subscrKey) throws PersistException {
        try {
            ISQLPersistManager manager = (ISQLPersistManager)this.getPersistManager();
            manager.begin();
            try {
                SQLUtils.execUpdate(manager, "DELETE FROM CAF_RT_NS_PREF WHERE (SUBSCR_KEY=?)", ISQLNames.PREF_DEL_BY_SUBSCR_TYPES, new Object[]{subscrKey});
                manager.commit();
            }
            catch (PersistException e) {
                manager.revert();
                throw e;
            }
        }
        catch (PersistException e) {
            throw new PersistException("CANT_DELETE_SUBSCR_PREFS", new Object[]{subscrKey}, (Throwable)((Object)e));
        }
    }

    public void storeSubscrPrefs(IPersistSubscrPrefs pref) throws PersistException {
        IPersistSubscrPrefs persistPref = pref;
        IPersistState state = persistPref.getState();
        if (!state.isChanged()) {
            return;
        }
        String subscrId = pref.getSubscription().getId();
        this.getSubscr(subscrId);
        try {
            ISQLPersistManager manager = (ISQLPersistManager)this.getPersistManager();
            manager.begin();
            try {
                if (state.isCreated()) {
                    manager.create(persistPref);
                } else if (state.isUpdated()) {
                    manager.store(persistPref);
                } else if (state.isDeleted()) {
                    manager.delete(persistPref);
                }
                manager.commit();
            }
            catch (PersistException e) {
                manager.revert();
                throw e;
            }
        }
        catch (PersistException e) {
            throw new PersistException("CANT_STORE_SUBSCR_PREF", new Object[]{subscrId, pref.getUserId()}, (Throwable)((Object)e));
        }
    }

    protected IPersistManager getPersistManager() throws PersistException {
        return new SQLPersistManager();
    }

    protected IPersistSubscription getSubscr(String subscrId) throws PersistException, SubscrNotExistException {
        try {
            RegisteredSubscrListFactory factory = RegisteredSubscrListFactory.getInstance();
            ISubscrList list = factory.getSubscrList();
            IPersistSubscription subscr = (IPersistSubscription)list.getSubscription(subscrId);
            if (subscr == null) {
                throw new SubscrNotExistException(subscrId);
            }
            return subscr;
        }
        catch (SubscrException e) {
            throw new PersistException((Throwable)((Object)e));
        }
    }
}

