/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistEntity;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PersistSubscrList
extends SubscrList
implements IPersistSubscrList {
    private Map m_dirtySubscrs = new LinkedHashMap();

    public void store(IPersistManager manager) throws PersistException {
        if (manager instanceof ISQLPersistManager) {
            this.store((ISQLPersistManager)manager);
        }
    }

    protected void store(ISQLPersistManager manager) throws PersistException {
        Iterator itr = this.getDirtySubscrs();
        while (itr.hasNext()) {
            IPersistSubscription subscr = (IPersistSubscription)itr.next();
            IPersistState state = subscr.getState();
            if (!state.isChanged()) continue;
            if (state.isCreated()) {
                manager.create(subscr);
                continue;
            }
            if (state.isUpdated()) {
                manager.store(subscr);
                continue;
            }
            if (!state.isDeleted()) continue;
            manager.delete(subscr);
            itr.remove();
        }
    }

    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        } else if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
    }

    public void addSubscription(ISubscription subscr) {
        super.addSubscription(subscr);
        ((IPersistEntity)((Object)subscr)).getState().setCreated(true);
        this.addDirtySubscr(subscr);
    }

    public void removeSubscription(String id) {
        IPersistSubscription subscr = (IPersistSubscription)this.getSubscription(id);
        if (subscr != null) {
            super.removeSubscription(id);
            subscr.getState().setDeleted(true);
        }
    }

    protected Iterator getDirtySubscrs() {
        return this.m_dirtySubscrs.values().iterator();
    }

    protected void addDirtySubscr(ISubscription subscr) {
        this.m_dirtySubscrs.put(subscr.getId(), subscr);
    }

    protected void removeDirtySubscr(String id) {
        this.m_dirtySubscrs.remove(id);
    }

    public boolean hasChanged() {
        if (this.m_dirtySubscrs.isEmpty()) {
            return false;
        }
        if (this.m_dirtySubscrs.size() != this.getSize()) {
            return true;
        }
        Iterator itr = this.getDirtySubscrs();
        while (itr.hasNext()) {
            IPersistSubscription subscr = (IPersistSubscription)itr.next();
            if (!subscr.getState().isChanged()) continue;
            return true;
        }
        return false;
    }

    protected abstract ClassLoader getClassLoader();
}

