/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.subscr;

import com.sap.caf.rt.services.notify.subscr.app.ApplicationList;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLNames;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.SQLUtils;
import com.sap.caf.rt.services.notify.subscr.persist.state.IPersistState;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplicationList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplication;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistApplicationList
extends ApplicationList
implements IPersistApplicationList {
    private Map m_dirtyApps = new LinkedHashMap();

    public void load(IPersistManager manager) throws PersistException {
        this.clearApplications();
        this.clearDirtyApplications();
        if (manager instanceof ISQLPersistManager) {
            this.load((ISQLPersistManager)manager);
        }
    }

    protected void load(ISQLPersistManager manager) throws PersistException {
        List rows = SQLUtils.execSelect(manager, "SELECT APP_KEY FROM CAF_RT_NS_APP", ISQLNames.SELECT_APP_KEYS_TYPES, SQLUtils.EMPTY_PARAMS);
        int i = rows.size();
        while (--i >= 0) {
            Map row = (Map)rows.get(i);
            PersistApplication app = new PersistApplication();
            app.setKey((String)row.get("APP_KEY"));
            manager.load(app);
            this.addApplication(app);
            app.getState().reset();
        }
    }

    public void store(IPersistManager manager) throws PersistException {
        Iterator itr = this.getDirtyApplications();
        while (itr.hasNext()) {
            IPersistApplication app = (IPersistApplication)itr.next();
            IPersistState state = app.getState();
            if (!state.isChanged()) continue;
            if (state.isCreated()) {
                manager.create(app);
                continue;
            }
            if (state.isUpdated()) {
                manager.store(app);
                continue;
            }
            if (!state.isDeleted()) continue;
            manager.delete(app);
            itr.remove();
        }
    }

    protected void clearDirtyApplications() {
        this.m_dirtyApps.clear();
    }

    protected Iterator getDirtyApplications() {
        return this.m_dirtyApps.values().iterator();
    }

    protected void addDirtyApplication(IApplication app) {
        this.m_dirtyApps.put(app.getId(), app);
    }

    protected void removeDirtyApplication(String id) {
        this.m_dirtyApps.remove(id);
    }

    public boolean addApplication(IApplication app) {
        if (!super.addApplication(app)) {
            return false;
        }
        ((IPersistApplication)app).getState().setCreated(true);
        this.addDirtyApplication(app);
        return true;
    }

    public void removeApplication(String id) {
        IApplication app = this.getApplication(id);
        if (app != null) {
            super.removeApplication(id);
            ((IPersistApplication)app).getState().setDeleted(true);
        }
    }
}

