/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.persist.sql;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.PersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.sql.ISQLPersistManager;
import com.sap.engine.frame.core.thread.ThreadContext;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class SQLPersistManager
extends PersistManager
implements ISQLPersistManager {
    private Transaction m_oldTrans;
    private TransactionManager m_transMan;
    private InitialContext m_jndiContext;
    private static final String DATASOURCE_NAME = "jdbc/SAP/CAF_RT";

    protected synchronized TransactionManager getTransactionManager() throws PersistException {
        if (this.m_transMan == null) {
            try {
                InitialContext context = this.getJndiContext();
                this.m_transMan = (TransactionManager)context.lookup("ts");
            }
            catch (NamingException e) {
                Log.fatal(e);
                throw new PersistException("CANT_GET_TR_MANAGER", e);
            }
        }
        return this.m_transMan;
    }

    protected synchronized InitialContext getJndiContext() throws NamingException {
        if (this.m_jndiContext == null) {
            this.m_jndiContext = new InitialContext();
        }
        return this.m_jndiContext;
    }

    public synchronized Connection getConnection() throws PersistException {
        try {
            DataSource dataSource = (DataSource)this.getJndiContext().lookup(DATASOURCE_NAME);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new PersistException("CANT_GET_DB_CONNECT", e);
        }
    }

    public void begin() throws PersistException {
        if (!this.hasThreadContext()) {
            return;
        }
        TransactionManager tm = this.getTransactionManager();
        this.suspend(tm);
        try {
            tm.begin();
        }
        catch (Exception e) {
            Log.fatal(e);
            this.resume(tm);
            throw new PersistException("CANT_BEGIN_TRANS", e);
        }
    }

    protected void resume(TransactionManager tm) throws PersistException {
        Transaction oldTrans = this.getOldTransaction();
        if (oldTrans == null) {
            return;
        }
        try {
            tm.resume(oldTrans);
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new PersistException("CANT_RESUME_OLD_TR", e);
        }
        finally {
            this.m_oldTrans = null;
        }
    }

    protected void suspend(TransactionManager tm) throws PersistException {
        if (this.getOldTransaction() != null) {
            throw new PersistException("OLD_TR_ACTIVE");
        }
        try {
            this.setOldTransaction(tm.suspend());
        }
        catch (SystemException e) {
            Log.fatal(e);
            throw new PersistException("CANT_SUSPEND_OLD_TR", e);
        }
    }

    protected synchronized Transaction getOldTransaction() {
        return this.m_oldTrans;
    }

    protected void setOldTransaction(Transaction trans) {
        this.m_oldTrans = trans;
    }

    public void commit() throws PersistException {
        if (!this.hasThreadContext()) {
            return;
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.commit();
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new PersistException("CANT_COMMIT_TRANS", e);
        }
        finally {
            this.resume(tm);
        }
    }

    public void revert() throws PersistException {
        if (!this.hasThreadContext()) {
            return;
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            tm.rollback();
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new PersistException("CANT_ROLLBACK_TRANS", e);
        }
        finally {
            this.resume(tm);
        }
    }

    protected boolean hasThreadContext() throws PersistException {
        try {
            ThreadContext threadContext = JndiUtils.getThreadContext(this.getClass().getClassLoader());
            return threadContext != null && !threadContext.isSystem();
        }
        catch (Exception e) {
            Log.fatal(e);
            throw new PersistException(e);
        }
    }
}

