/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app.deployed;

import com.sap.caf.rt.services.notify.common.JndiUtils;
import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.AppSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.GeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.deployed.IDeployedSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.xml.IXMLPersistManager;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;

public class DeployedSubscrList
extends GeneralSubscrList
implements IDeployedSubscrList {
    public void load(IPersistManager manager) throws PersistException {
        if (manager instanceof IXMLPersistManager) {
            this.load((IXMLPersistManager)manager);
        }
    }

    protected void load(IXMLPersistManager manager) throws PersistException {
        String method = "load(IXMLPersistManager)";
        Log.enter("load(IXMLPersistManager)");
        try {
            DeployService deplSrv = JndiUtils.getDeployService(this.getClass().getClassLoader());
            String[] apps = deplSrv.listApplications("EJBContainer", null);
            for (int i = 0; i < apps.length; ++i) {
                ApplicationInformation appInfo = deplSrv.getApplicationInformation(apps[i]);
                String appId = appInfo.getLoaderName();
                try {
                    PersistApplication app = new PersistApplication(appId);
                    app.invalidate();
                    if (!app.isValid()) {
                        Log.debug("App:[" + appId + "] is not valid! Either it doesn't contain properties or it isn't possible to resolve its classLoder.");
                        continue;
                    }
                    AppSubscrListFactory appFactory = AppSubscrListFactory.getInstance(app);
                    IAppSubscrList appSubscrList = (IAppSubscrList)appFactory.getSubscrList();
                    if (appSubscrList == null) {
                        Log.debug("It couldn't be possible to load subscrList for the app:[" + appId + "]");
                        continue;
                    }
                    this.addAppSubscrList(appSubscrList);
                    continue;
                }
                catch (SubscrException e) {
                    Log.fatal((Throwable)((Object)new PersistException("CANT_GET_APP_SUBCR", new Object[]{appInfo.getOriginalAppName()}, (Throwable)((Object)e))));
                }
            }
        }
        catch (Exception e) {
            Log.fatal(e, "load(IXMLPersistManager)");
            throw new PersistException("CANT_GET_DEPLOYED_SUBSCR", e);
        }
        finally {
            Log.exit("load(IXMLPersistManager)");
        }
    }
}

