/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.subscr.ISubscrList;
import com.sap.caf.rt.services.notify.subscr.SubscrException;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrListFactory;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppLifeCycleException;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.AppLifeCycleMonitor;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleListener;
import com.sap.caf.rt.services.notify.subscr.app.lifecycle.IAppLifeCycleMonitor;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;

public abstract class GeneralSubscrListFactory
implements IGeneralSubscrListFactory,
IAppLifeCycleListener {
    private IGeneralSubscrList m_subscrList;

    protected GeneralSubscrListFactory() throws SubscrException {
        try {
            IAppLifeCycleMonitor monitor = AppLifeCycleMonitor.getInstance();
            monitor.addListener(this);
        }
        catch (AppLifeCycleException e) {
            if (Log.isDebugEnabled()) {
                Log.debug("Could not register application lifecycle listener");
            }
            throw new SubscrException((Throwable)((Object)e));
        }
    }

    protected void finalize() throws Throwable {
        IAppLifeCycleMonitor monitor = AppLifeCycleMonitor.getInstance();
        monitor.removeListener(this);
        super.finalize();
    }

    public synchronized ISubscrList getSubscrList() throws SubscrException {
        if (this.m_subscrList == null) {
            this.createSubscrList();
        }
        return this.m_subscrList;
    }

    public synchronized void createSubscrList() throws SubscrException {
        try {
            this.m_subscrList = this.getSubscrListInstance();
            IPersistManager manager = this.getPersistManager();
            manager.begin();
            try {
                manager.load(this.m_subscrList);
                manager.commit();
            }
            catch (PersistException e) {
                manager.revert();
                throw e;
            }
        }
        catch (PersistException e) {
            throw new SubscrException("CANT_LOAD_SUBSCR_LIST", (Throwable)((Object)e));
        }
    }

    public synchronized void appStateChanged(String appId, byte phase, byte state) {
        if (this.m_subscrList == null) {
            return;
        }
        IAppSubscrList appSubscrList = this.m_subscrList.getAppSubscrList(appId);
        if (appSubscrList == null) {
            return;
        }
        this.m_subscrList = null;
    }

    protected abstract IGeneralSubscrList getSubscrListInstance();
}

