/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.subscr.app;

import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.SubscrList;
import com.sap.caf.rt.services.notify.subscr.app.AppSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IAppSubscrList;
import com.sap.caf.rt.services.notify.subscr.app.IApplication;
import com.sap.caf.rt.services.notify.subscr.app.IGeneralSubscrList;
import com.sap.caf.rt.services.notify.subscr.persist.IPersistManager;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplication;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistApplicationList;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistApplicationList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GeneralSubscrList
extends SubscrList
implements IGeneralSubscrList {
    private IPersistApplicationList m_appList = new PersistApplicationList();
    private Map m_grps = new LinkedHashMap();
    private Map m_appSubscrLists = new LinkedHashMap();

    public Iterator getApplications() {
        return this.m_appList.getApplications();
    }

    protected void addApplication(IApplication app) {
        IAppSubscrList appSubscrList;
        if (this.m_appList.addApplication(app) && (appSubscrList = this.getAppSubscrList(app.getId())) == null) {
            this.addAppSubscrList(new AppSubscrList((IPersistApplication)app));
        }
    }

    protected void removeApplication(String appId) {
        IAppSubscrList appSubscrList;
        IApplication app = this.m_appList.getApplication(appId);
        if (app != null && (appSubscrList = this.getAppSubscrList(app.getId())) != null && !appSubscrList.hasChanged()) {
            this.m_appList.removeApplication(appId);
            this.removeAppSubscrList(appId);
        }
    }

    public IPersistApplication getApplication(String appId) {
        return (IPersistApplication)this.m_appList.getApplication(appId);
    }

    public Iterator getSubscrByGroup(String groupId) {
        Map subscrs = (Map)this.m_grps.get(groupId);
        return subscrs == null ? Collections.EMPTY_LIST.iterator() : subscrs.values().iterator();
    }

    protected void addSubscrByGroup(ISubscription subscr) {
        String id;
        String groupId = subscr.getGroupId();
        LinkedHashMap<String, ISubscription> subscrs = (LinkedHashMap<String, ISubscription>)this.m_grps.get(groupId);
        if (subscrs == null) {
            subscrs = new LinkedHashMap<String, ISubscription>();
            this.m_grps.put(groupId, subscrs);
        }
        if (!subscrs.containsKey(id = subscr.getId())) {
            subscrs.put(id, subscr);
        }
    }

    protected void removeSubscrByGroup(ISubscription subscr) {
        String groupId = subscr.getGroupId();
        Map subscrs = (Map)this.m_grps.get(groupId);
        if (subscrs == null) {
            return;
        }
        String subscrId = subscr.getId();
        subscrs.remove(subscrId);
        if (subscrs.isEmpty()) {
            this.m_grps.remove(groupId);
        }
    }

    public synchronized void addSubscription(ISubscription subscr) {
        String subscrId = subscr.getId();
        if (this.getSubscription(subscrId) == null) {
            super.addSubscription(subscr);
            this.addApplication(subscr.getApplication());
            this.addSubscrByGroup(subscr);
            this.addSubscrByApp(subscr);
        }
    }

    public synchronized void removeSubscription(String subscrId) {
        ISubscription subscr = this.getSubscription(subscrId);
        if (subscr != null) {
            super.removeSubscription(subscrId);
            this.removeSubscrByGroup(subscr);
            this.removeSubscrByApp(subscr);
            this.removeApplication(subscr.getApplication().getId());
        }
    }

    protected IPersistApplicationList getApplicationList() {
        return this.m_appList;
    }

    public synchronized void load(IPersistManager manager) throws PersistException {
        IPersistApplicationList appList = this.getApplicationList();
        appList.load(manager);
        Iterator itr = appList.getApplications();
        while (itr.hasNext()) {
            IPersistApplication app = (IPersistApplication)itr.next();
            AppSubscrList appSubscrList = new AppSubscrList(app);
            appSubscrList.load(manager);
            this.addAppSubscrList(appSubscrList);
        }
    }

    public synchronized void store(IPersistManager manager) throws PersistException {
        IPersistApplicationList appList = this.getApplicationList();
        appList.store(manager);
        Iterator itr = this.getAppSubscrLists();
        while (itr.hasNext()) {
            IAppSubscrList appSubscrList = (IAppSubscrList)itr.next();
            appSubscrList.store(manager);
            if (!appSubscrList.isEmpty()) continue;
            appList.removeApplication(appSubscrList.getApplication().getId());
            itr.remove();
        }
        appList.store(manager);
    }

    public synchronized void addAppSubscrList(IAppSubscrList appSubscrList) {
        this.m_appSubscrLists.put(appSubscrList.getApplication().getId(), appSubscrList);
        Iterator itr = appSubscrList.getSubscriptions();
        while (itr.hasNext()) {
            this.addSubscription((ISubscription)itr.next());
        }
    }

    public IAppSubscrList getAppSubscrList(String appId) {
        return (IAppSubscrList)this.m_appSubscrLists.get(appId);
    }

    public synchronized void removeAppSubscrList(String appId) {
        IAppSubscrList appSubscrList = this.getAppSubscrList(appId);
        if (appSubscrList != null) {
            this.m_appSubscrLists.remove(appId);
            Iterator itr = appSubscrList.getSubscriptions();
            while (itr.hasNext()) {
                this.removeSubscription(((ISubscription)itr.next()).getId());
            }
        }
    }

    protected Iterator getAppSubscrLists() {
        return this.m_appSubscrLists.values().iterator();
    }

    protected void addSubscrByApp(ISubscription subscr) {
        String subscrId = subscr.getId();
        IAppSubscrList appSubscrList = this.getAppSubscrList(subscr.getApplication().getId());
        if (appSubscrList != null && appSubscrList.getSubscription(subscrId) == null) {
            appSubscrList.addSubscription(subscr);
        }
    }

    protected void removeSubscrByApp(ISubscription subscr) {
        String subscrId = subscr.getId();
        IAppSubscrList appSubscrList = this.getAppSubscrList(subscr.getApplication().getId());
        if (appSubscrList != null) {
            appSubscrList.removeSubscription(subscrId);
        }
    }
}

