/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif.send;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.notif.INotifSender;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.send.NotifMessage;
import com.sap.caf.rt.services.notify.notif.send.NotifRecipient;
import com.sap.caf.rt.services.notify.notif.send.SendingLocal;
import com.sap.caf.rt.services.notify.notif.send.SendingLocalHome;
import com.sap.caf.rt.services.notify.subscr.ISubscrTemplate;
import com.sap.caf.rt.services.notify.subscr.ISubscription;
import com.sap.caf.rt.services.notify.subscr.persist.PersistException;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefs;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscrPrefsFactory;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.IPersistSubscription;
import com.sap.caf.rt.services.notify.subscr.persist.subscr.PersistSubscrPrefsFactory;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NotifSender
implements INotifSender {
    private SendingLocalHome m_sendingHome;
    private static final String JNDI_SENDBEAN_NAME = "localejbs/sap.com/caf.runtime/Sending";

    public void send(Collection userIds, ISubscription subscr, INotifEvent event) throws NotifException {
        try {
            Collection notifRecips;
            IUser user = event.getOriginator();
            String originator = user != null ? user.getUniqueID() : null;
            ISubscrTemplate templ = subscr.getTemplate();
            String templId = templ.getId();
            String templSubj = templ.getLocalizedSubject();
            Properties templProps = templ.getProperties(event);
            if (Log.isDebugEnabled()) {
                Log.debug("users:[{0}],id:[{1}],subj:[{2}],props:[{3}]", new Object[]{userIds, templId, templSubj, templProps});
            }
            if ((notifRecips = this.createNotifRecipients((IPersistSubscription)subscr, userIds)) == null || notifRecips.isEmpty()) {
                if (Log.isDebugEnabled()) {
                    Log.debug("There is nobody to send the message to. All users are unsibscribed");
                }
                return;
            }
            NotifMessage notifMsg = new NotifMessage(originator, notifRecips, templId, templSubj, templProps);
            if (!notifMsg.isValid() && Log.isDebugEnabled()) {
                Log.debug("NotifMessage is invalid, not sending");
            }
            this.getSendingBean().send(notifMsg);
        }
        catch (Exception e) {
            NotifException notifEx = new NotifException("CANT_PUBLISH_MSG", e);
            throw notifEx;
        }
    }

    protected Collection createNotifRecipients(IPersistSubscription subscr, Collection userIds) throws PersistException {
        IPersistSubscrPrefsFactory prefFactory = PersistSubscrPrefsFactory.getInstance();
        ArrayList<NotifRecipient> notifRecips = new ArrayList<NotifRecipient>();
        Iterator itr = userIds.iterator();
        while (itr.hasNext()) {
            String userId = (String)itr.next();
            IUser user = this.getUser(userId);
            if (user == null) continue;
            IPersistSubscrPrefs subscrPref = prefFactory.getSubscrPrefs(subscr, user);
            if (subscrPref != null && !subscrPref.isSubscribed()) {
                Log.info("UNSUBSCR_USER", new Object[]{userId});
                continue;
            }
            notifRecips.add(new NotifRecipient(user, subscrPref));
        }
        return notifRecips;
    }

    private IUser getUser(String userId) {
        IUser user;
        IUserFactory userFactory;
        block6: {
            if (userId == null) {
                return null;
            }
            userFactory = UMFactory.getUserFactory();
            user = null;
            try {
                user = userFactory.getUser(userId);
            }
            catch (UMException e) {
                if (!Log.isDebugEnabled()) break block6;
                Log.debug("Couldn't find user by unique id:[" + userId + "], try to find by logon id, cause:[" + e.getMessage() + "]");
            }
        }
        if (user == null) {
            try {
                user = userFactory.getUserByLogonID(userId);
            }
            catch (UMException e) {
                Log.fatal("CANT_GET_USER", new Object[]{userId}, e);
            }
        }
        return user;
    }

    protected SendingLocal getSendingBean() throws NamingException, CreateException {
        if (this.m_sendingHome == null) {
            InitialContext context = new InitialContext();
            this.m_sendingHome = (SendingLocalHome)context.lookup(JNDI_SENDBEAN_NAME);
        }
        return this.m_sendingHome.create();
    }
}

