/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.notif;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.caf.rt.services.notify.common.ServerUtils;
import com.sap.caf.rt.services.notify.notif.INotifEvent;
import com.sap.caf.rt.services.notify.subscr.ISubscrType;
import com.sap.security.api.IUser;
import java.util.HashMap;
import java.util.Map;

public class NotifEvent
implements INotifEvent {
    protected ISubscrType m_type;
    protected String m_subscrId;
    protected Map m_attrs;
    protected IUser m_originator;
    protected boolean m_bEnabled = true;

    public NotifEvent(String subscrId, ISubscrType type, Map attrs) {
        this.m_subscrId = subscrId;
        this.m_type = type;
        this.m_attrs = attrs;
        try {
            this.m_originator = ServerUtils.getCurrentUser(this.getClass().getClassLoader());
        }
        catch (Exception e) {
            Log.fatal("CANT_GET_LOGGED_USER", null, e);
        }
    }

    public String getId() {
        return this.m_subscrId;
    }

    public void setSubscriptionId(String subscrId) {
        this.m_subscrId = subscrId;
    }

    public ISubscrType getType() {
        return this.m_type;
    }

    public void setType(ISubscrType type) {
        this.m_type = type;
    }

    public Map getAttributes() {
        return this.m_attrs;
    }

    public void setAttributes(Map attrs) {
        this.m_attrs = attrs;
    }

    public void setAttribute(Object key, Object value) {
        if (this.m_attrs == null) {
            this.m_attrs = new HashMap();
        }
        if (value == null) {
            if (this.m_attrs.containsKey(key)) {
                this.m_attrs.remove(key);
            }
        } else {
            this.m_attrs.put(key, value);
        }
    }

    public Object getAttribute(Object key) {
        return this.m_attrs != null ? this.m_attrs.get(key) : null;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_bEnabled = enabled;
    }

    public IUser getOriginator() {
        return this.m_originator;
    }
}

