/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.common;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.localization.ResourceAccessor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NSResourceAccessor
extends ResourceAccessor {
    static final long serialVersionUID = 1L;
    protected transient Map m_bundles;
    protected transient ClassLoader m_classLoader;
    private static final Map m_accessors = new HashMap();

    public NSResourceAccessor(String bundleName, ClassLoader classLoader) {
        super(bundleName);
        this.setClassLoader(classLoader);
    }

    public NSResourceAccessor(String bundleName) {
        this(bundleName, null);
    }

    public static synchronized ResourceAccessor getInstance(String bundleName) {
        ResourceAccessor accessor = (ResourceAccessor)m_accessors.get(bundleName);
        if (accessor == null) {
            accessor = new NSResourceAccessor(bundleName);
            m_accessors.put(bundleName, accessor);
        }
        return accessor;
    }

    public static synchronized ResourceAccessor getInstance(String bundleName, ClassLoader classLoader) {
        NSResourceAccessor accessor = (NSResourceAccessor)((Object)m_accessors.get(bundleName));
        if (accessor == null || !classLoader.equals(accessor.getClassLoader())) {
            accessor = new NSResourceAccessor(bundleName, classLoader);
            m_accessors.put(bundleName, accessor);
        }
        return accessor;
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.m_classLoader != null ? this.m_classLoader : ((Object)((Object)this)).getClass().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageText(Locale locale, String key) {
        String bundleName;
        String message = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundleName = this.getResourceBundleName()) == null || key == null) {
            return null;
        }
        Map bundles = this.getBundles();
        Map map = this.m_bundles;
        synchronized (map) {
            block10: {
                ResourceBundle rb = (ResourceBundle)this.m_bundles.get(locale);
                if (rb == null) {
                    try {
                        rb = ResourceBundle.getBundle(bundleName, locale, this.getClassLoader());
                        if (rb != null) {
                            message = rb.getString(key);
                            bundles.put(locale, rb);
                        }
                        break block10;
                    }
                    catch (MissingResourceException e) {
                        if (Log.isDebugEnabled()) {
                            Log.debug("Could not get bundle:" + bundleName, e);
                        }
                        break block10;
                    }
                }
                message = rb.getString(key);
            }
        }
        return message != null ? message : super.getMessageText(locale, key);
    }

    protected synchronized Map getBundles() {
        if (this.m_bundles == null) {
            this.m_bundles = new HashMap(5);
        }
        return this.m_bundles;
    }
}

