/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.common;

import com.sap.caf.rt.services.notify.common.NSResourceAccessor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.localization.LocalizableTextFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Log {
    private static final String JARM_REQUEST = "CAF:RT:notify";

    public static void exit(String method) {
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
    }

    public static void enter(String method) {
        CAFPublicLogger.entering(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
    }

    public static void enter(String method, Object[] params) {
        CAFPublicLogger.entering(null, JARM_REQUEST, method, CAFPublicLogger.LOC_CAF);
    }

    public static void fatal(Throwable e, String method) {
        CAFPublicLogger.categoryCAF.logThrowableT(500, CAFPublicLogger.LOC_CAF, method, e);
    }

    public static void fatal(String msgKey, Object[] args) {
        CAFPublicLogger.LOC_CAF.fatalT(Log.getLocalizedMessage(msgKey, args));
    }

    public static void fatal(Throwable e) {
        CAFPublicLogger.categoryCAF.logThrowableT(500, CAFPublicLogger.LOC_CAF, null, e);
    }

    public static void fatal(String msgKey, Object[] args, Throwable e) {
        Log.fatal(msgKey, args);
        Log.fatal(e);
    }

    public static void debug(String msg) {
        CAFPublicLogger.LOC_CAF.debugT(msg);
    }

    public static void info(String msgKey, Object[] args) {
        CAFPublicLogger.LOC_CAF.infoT(Log.getLocalizedMessage(msgKey, args));
    }

    public static void debug(String msg, Object[] args) {
        CAFPublicLogger.LOC_CAF.debugT(msg, args);
    }

    public static void debug(String msg, Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        e.printStackTrace(wrapper);
        wrapper.close();
        CAFPublicLogger.LOC_CAF.debugT(msg, writer.toString());
    }

    public static boolean isDebugEnabled() {
        return CAFPublicLogger.LOC_CAF.beDebug();
    }

    public static boolean isInfoEnabled() {
        return CAFPublicLogger.LOC_CAF.beInfo();
    }

    private static String getLocalizedMessage(String msgKey, Object[] args) {
        String msg;
        try {
            LocalizableTextFormatter formatter = new LocalizableTextFormatter(NSResourceAccessor.getInstance("com.sap.caf.rt.services.notify.res.NSExceptionResources"), msgKey, args);
            msg = formatter.format();
        }
        catch (Exception e) {
            Log.fatal(e);
            msg = msgKey;
        }
        return msg;
    }
}

