/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.services.notify.common;

import com.sap.caf.rt.services.notify.common.Log;
import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ApplicationClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.lib.security.SecurityContext;
import com.sap.engine.services.deploy.ApplicationInformation;
import com.sap.engine.services.deploy.DeployService;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class JndiUtils {
    public static ComponentExecutionContext getAppContext(ClassLoader classLoader) throws Exception {
        return (ComponentExecutionContext)JndiUtils.getServiceContext(classLoader).getContainerContext().getObjectRegistry().getProvidedInterface("appcontext");
    }

    public static ApplicationServiceContext getServiceContext(ClassLoader classLoader) throws Exception {
        Object objIWebDynproRuntimeService = JndiUtils.getJndiObject("webdynpro", classLoader);
        Class<?> clIWebDynproRuntimeService = objIWebDynproRuntimeService.getClass();
        Method mthGetGlobalApplicationContext = clIWebDynproRuntimeService.getMethod("getGlobalApplicationContext", new Class[0]);
        return (ApplicationServiceContext)mthGetGlobalApplicationContext.invoke(objIWebDynproRuntimeService, new Object[0]);
    }

    public static DeployService getDeployService(ClassLoader classLoader) throws Exception {
        return (DeployService)JndiUtils.getServiceContext(classLoader).getContainerContext().getObjectRegistry().getProvidedInterface("container");
    }

    public static CoreContext getCoreContext(ClassLoader classLoader) throws Exception {
        return JndiUtils.getServiceContext(classLoader).getCoreContext();
    }

    public static SecurityContext getSecurityContext(ClassLoader classLoader) throws Exception {
        ThreadSystem threadSystem = JndiUtils.getServiceContext(classLoader).getCoreContext().getThreadSystem();
        int securityContextObjectId = threadSystem.getContextObjectId("security");
        return (SecurityContext)threadSystem.getThreadContext().getContextObject(securityContextObjectId);
    }

    public static ThreadContext getThreadContext(ClassLoader classLoader) throws Exception {
        return JndiUtils.getServiceContext(classLoader).getCoreContext().getThreadSystem().getThreadContext();
    }

    public static ApplicationClusterContext getClusterContext(ClassLoader classLoader) throws Exception {
        return JndiUtils.getServiceContext(classLoader).getClusterContext();
    }

    public static String getClusterElementName(ClassLoader classLoader) throws Exception {
        ClusterElement serverInfo = JndiUtils.getClusterContext(classLoader).getClusterMonitor().getCurrentParticipant();
        return serverInfo != null ? serverInfo.getName() : null;
    }

    public static ConfigurationHandler getConfigHandler(ClassLoader classLoader) throws Exception {
        return JndiUtils.getServiceContext(classLoader).getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getJndiObject(String name, ClassLoader classLoader) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            InitialContext ctx = new InitialContext();
            Object object = ctx.lookup(name);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static ClassLoader getAppClassLoader(ClassLoader classLoader, String appId) throws Exception {
        return JndiUtils.getCoreContext(classLoader).getLoadContext().getClassLoader(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getAppProperties(ClassLoader classLoader, String appId) throws Exception {
        Properties properties;
        ApplicationServiceContext appCtx = JndiUtils.getServiceContext(classLoader);
        CoreContext coreCtx = appCtx.getCoreContext();
        LoadContext loadCtx = coreCtx.getLoadContext();
        DeployService deplSrv = (DeployService)appCtx.getContainerContext().getObjectRegistry().getProvidedInterface("container");
        ApplicationInformation appInfo = deplSrv.getApplicationInformation(appId);
        String appConfigPath = appInfo.getApplicationConfigurationPath() + "/" + "application.global.properties";
        ConfigurationHandler configHandler = coreCtx.getConfigurationHandlerFactory().getConfigurationHandler();
        Configuration config = configHandler.openConfiguration(appConfigPath, 0);
        try {
            PropertySheet propSheet = config.getPropertySheetInterface();
            properties = propSheet != null ? propSheet.getProperties() : null;
        }
        catch (Throwable throwable) {
            try {
                configHandler.closeConfiguration(config);
                throw throwable;
            }
            catch (NameNotFoundException e) {
                if (Log.isDebugEnabled()) {
                    Log.debug("App:[" + appId + "] does not contain config:[" + appConfigPath + "]");
                }
                return null;
            }
        }
        configHandler.closeConfiguration(config);
        return properties;
    }
}

