/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.util;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCConnection {
    public static final String dataSource = "jdbc/SAP/CAF_RT";
    private Connection con;
    private Context ctx;
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$util$JDBCConnection == null ? (class$com$sap$caf$rt$bol$util$JDBCConnection = JDBCConnection.class$("com.sap.caf.rt.bol.util.JDBCConnection")) : class$com$sap$caf$rt$bol$util$JDBCConnection).getName();
    private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$util$JDBCConnection == null ? (class$com$sap$caf$rt$bol$util$JDBCConnection = JDBCConnection.class$("com.sap.caf.rt.bol.util.JDBCConnection")) : class$com$sap$caf$rt$bol$util$JDBCConnection));
    static /* synthetic */ Class class$com$sap$caf$rt$bol$util$JDBCConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCConnection() {
        String method = "JDBCConnection()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            this.ctx = new InitialContext();
            this.createConnection();
        }
        catch (Exception e) {
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error creating initial context", (Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection selectColumn(String queryString, String columnName) throws DataAccessException {
        String method = "selectColumn(String , String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{queryString, columnName}, 1);
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        try {
            try {
                if (this.con == null) {
                    this.createConnection();
                }
                Statement stmt = this.con.createStatement();
                rs = stmt.executeQuery(queryString);
                while (rs.next()) {
                    result.add(rs.getString(columnName));
                }
                Object var9_8 = null;
            }
            catch (SQLException e) {
                Object[] args = new Object[]{queryString, columnName};
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} ", args, e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                rs.close();
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                throw throwable;
            }
            catch (SQLException e) {
                Object[] args = new Object[]{queryString, columnName};
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} ", args, e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        try {}
        catch (SQLException e) {
            Object[] args = new Object[]{queryString, columnName};
            CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} ", args, e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        rs.close();
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection selectColumn(String queryString, String columnName, String prefix, int length) throws DataAccessException {
        String method = "selectColumn(String , String , String , int )";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{queryString, columnName, prefix, length + ""}, 1);
        HashSet<String> result = new HashSet<String>();
        ResultSet rs = null;
        try {
            try {
                if (this.con == null) {
                    this.createConnection();
                }
                Statement stmt = this.con.createStatement();
                rs = stmt.executeQuery(queryString);
                while (rs.next()) {
                    String tmp = rs.getString(columnName);
                    if (tmp.length() > length) {
                        if (prefix.length() > 0) {
                            if (!tmp.startsWith(prefix)) continue;
                            result.add(tmp.substring(0, length));
                            continue;
                        }
                        result.add(tmp.substring(0, length));
                        continue;
                    }
                    if (prefix.length() <= 0) continue;
                    if (tmp.startsWith(prefix)) {
                        result.add(tmp);
                        continue;
                    }
                    result.add(tmp);
                }
                Object var11_12 = null;
            }
            catch (SQLException e) {
                Object[] args = new Object[]{queryString, columnName, prefix, length + ""};
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} prefix : {2} length : {3}", args, e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                rs.close();
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                throw throwable;
            }
            catch (SQLException e) {
                Object[] args = new Object[]{queryString, columnName};
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} prefix : {2} length : {3} ", args, e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        try {}
        catch (SQLException e) {
            Object[] args = new Object[]{queryString, columnName};
            CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in selectColumn of queryString : {0} columnName : {1} prefix : {2} length : {3} ", args, e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        rs.close();
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return result;
    }

    public Collection deserializeCollection(String queryString, String columnName) throws DataAccessException {
        String method = "deserializeCollection(String , String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{queryString, columnName}, 1);
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return this.deserializeCollection(queryString, columnName, "", -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection deserializeCollection(String queryString, String columnName, String prefix, int length) throws DataAccessException {
        String method = "deserializeCollection(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{queryString, columnName, prefix, length + ""}, 1);
        if (this.con == null) {
            this.createConnection();
        }
        HashSet<String> result = new HashSet<String>();
        ResultSet rs = null;
        try {
            try {
                Statement stmt = this.con.createStatement();
                rs = stmt.executeQuery(queryString);
                while (rs.next()) {
                    Blob blob = rs.getBlob(columnName);
                    ObjectInputStream input = new ObjectInputStream(blob.getBinaryStream());
                    Object obj = input.readObject();
                    if (!(obj instanceof Collection)) continue;
                    Iterator it = ((Collection)obj).iterator();
                    while (it.hasNext()) {
                        String tmp = (String)it.next();
                        if (length == -1) {
                            if (prefix.length() > 0) {
                                if (!tmp.startsWith(prefix)) continue;
                                result.add(tmp);
                                continue;
                            }
                            result.add(tmp);
                            continue;
                        }
                        if (prefix.length() > 0) {
                            if (!tmp.startsWith(prefix)) continue;
                            result.add(tmp.substring(0, length));
                            continue;
                        }
                        result.add(tmp.substring(0, length));
                    }
                }
                Object var15_16 = null;
            }
            catch (Exception e) {
                Object[] args = new Object[]{dataSource};
                CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Exception in deserializeCollection of queryString : {0} columnName : {1} prefix : {2} length : {3}", args, (Throwable)e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            try {
                rs.close();
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                throw throwable;
            }
            catch (SQLException e) {
                Object[] args = new Object[]{queryString, columnName};
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in deserializeCollection of queryString : {0} columnName : {1} prefix : {2} length : {3}", args, e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        try {}
        catch (SQLException e) {
            Object[] args = new Object[]{queryString, columnName};
            CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in deserializeCollection of queryString : {0} columnName : {1} prefix : {2} length : {3}", args, e);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        rs.close();
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return result;
    }

    private void createConnection() throws DataAccessException {
        String method = "createConnection()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            DataSource ds = (DataSource)this.ctx.lookup(dataSource);
            this.con = ds.getConnection();
        }
        catch (NamingException e) {
            Object[] args = new Object[]{dataSource};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0}", args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException("JDBC_CONNECT_ERROR");
        }
        catch (SQLException e) {
            Object[] args = new Object[]{dataSource};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "SQLException using datasource : {0}", args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException("JDBC_CONNECT_ERROR");
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public void close() throws DataAccessException {
        String method = "close()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                CAFPublicLogger.traceThrowableT(100, location, method, "SQLException in connection close", e);
                CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

