/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Cache {
    HashMap cache = new HashMap();
    LinkedList mru = new LinkedList();
    int size;

    public Cache(int cacheSize) {
        this.size = cacheSize;
    }

    public void put(String key, Object value) {
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, value);
            this.mru.addFirst(key);
            if (this.mru.size() > this.size) {
                this.cache.remove(this.mru.getLast());
                this.mru.removeLast();
            }
        } else {
            this.mru.remove(key);
            this.mru.addFirst(key);
        }
    }

    public void putAll(Map objects) {
        Iterator it = objects.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry row = it.next();
            this.put((String)row.getKey(), row.getValue());
        }
    }

    public Object get(String key) {
        if (this.mru.contains(key)) {
            this.mru.remove(key);
            this.mru.addFirst(key);
        }
        return this.cache.get(key);
    }

    public void remove(String key) {
        if (this.mru.contains(key)) {
            this.mru.remove(key);
        }
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
        this.mru.clear();
    }

    public boolean isEmpty() {
        boolean res = false;
        if (this.mru.size() == 0) {
            res = true;
        }
        return res;
    }
}

