/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.pk;

import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.pk.Incrementor;
import com.sap.caf.rt.bol.pk.NumberRangeEntry;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.guid.GUIDGeneratorFactory;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PrimaryKeyFactory {
    private static String NUMBER = "NUMBER";
    private static String STRING = "STRING";
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory == null ? (class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory = PrimaryKeyFactory.class$("com.sap.caf.rt.bol.pk.PrimaryKeyFactory")) : class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory).getName();
    private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static PrimaryKeyFactory primKeyFactory = null;
    private PersistenceManager pm = null;
    private PersistenceManagerFactory pmf = null;
    public static final String JNDI_NAME = CAFContext.JNDI_NAME_JDO;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory == null ? (class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory = PrimaryKeyFactory.class$("com.sap.caf.rt.bol.pk.PrimaryKeyFactory")) : class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory));
    static /* synthetic */ Class class$com$sap$caf$rt$bol$pk$PrimaryKeyFactory;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$pk$NumberRangeEntry;

    private PrimaryKeyFactory() throws DataAccessException {
        String method = "PrimaryKeyFactory()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            InitialContext ctx = new InitialContext();
            this.pmf = (PersistenceManagerFactory)ctx.lookup(JNDI_NAME);
        }
        catch (NamingException e) {
            Object[] args = new Object[]{JNDI_NAME};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0}", args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public static synchronized PrimaryKeyFactory getInstance() throws DataAccessException {
        String method = "getInstance()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        if (primKeyFactory == null) {
            primKeyFactory = new PrimaryKeyFactory();
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return primKeyFactory;
    }

    public String getPrimaryKey() {
        String method = "getPrimaryKey";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        String guid = GUIDGeneratorFactory.getInstance().createGUIDGenerator().createGUID().toString();
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return guid;
    }

    public String getBusinessObjectId(String objectName, String objectGroup, String format) throws DataAccessException {
        String method = "getBusinessObjectId(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectName, objectGroup, format}, 1);
        if (format.toUpperCase() != NUMBER && format.toUpperCase() != STRING) {
            throw new DataAccessException("BO_INVALID_TYPE");
        }
        String key = null;
        Collection resultSet = null;
        Class objectClass = class$com$sap$caf$rt$bol$pk$NumberRangeEntry == null ? (class$com$sap$caf$rt$bol$pk$NumberRangeEntry = PrimaryKeyFactory.class$("com.sap.caf.rt.bol.pk.NumberRangeEntry")) : class$com$sap$caf$rt$bol$pk$NumberRangeEntry;
        String filter = "key == objectName && objGroup == objectGroup";
        try {
            this.pm = this.pmf.getPersistenceManager();
            Extent ext = this.pm.getExtent(objectClass, true);
            Query query = null;
            query = this.pm.newQuery(ext, filter);
            query.declareParameters("String objectName, String objectGroup");
            resultSet = (Collection)query.execute((Object)objectName, (Object)objectGroup);
            this.pm.close();
            Iterator iter = resultSet.iterator();
            boolean i = true;
            String max = null;
            NumberRangeEntry numRangeEntry = null;
            int indx = 0;
            while (iter.hasNext()) {
                numRangeEntry = (NumberRangeEntry)iter.next();
                indx = numRangeEntry.getIndex();
                key = numRangeEntry.getActCounter();
                max = numRangeEntry.getHigh();
                if (!(format.toUpperCase() == NUMBER ? Integer.parseInt(key.trim()) + 1 < Integer.parseInt(max.trim()) && Integer.parseInt(key.trim()) > Integer.parseInt(numRangeEntry.getLow().trim()) : key.compareTo(max.trim()) < 0 && key.compareTo(numRangeEntry.getLow().trim()) > 0)) continue;
            }
            String newCounter = Incrementor.increment(key, max, format);
            numRangeEntry.setActCounter(newCounter);
        }
        catch (JDOUserException e) {
            Object[] args = new Object[]{objectName, objectGroup, format};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in getBusinessObjectId of objectName : {0} objectGroup : {1} format : {2}", args, e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        catch (Exception e) {
            Object[] args = new Object[]{objectName, objectGroup, format};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in getBusinessObjectId of objectName : {0} objectGroup : {1} format : {2}", args, e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
        return key;
    }

    public void setNumberRange(String objectName, String objectGroup, String low, String high, boolean ext) throws DataAccessException {
        String method = "setNumberRange(String, String, String, String, boolean)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectName, objectGroup, low, high, ext + ""}, 1);
        String key = null;
        Collection resultSet = null;
        Class objectClass = class$com$sap$caf$rt$bol$pk$NumberRangeEntry == null ? (class$com$sap$caf$rt$bol$pk$NumberRangeEntry = PrimaryKeyFactory.class$("com.sap.caf.rt.bol.pk.NumberRangeEntry")) : class$com$sap$caf$rt$bol$pk$NumberRangeEntry;
        String filter = "key == objectName && objGroup == objectGroup";
        try {
            try {
                this.pm = this.pmf.getPersistenceManager();
                Extent extent = this.pm.getExtent(objectClass, true);
                Query query = null;
                query = this.pm.newQuery(extent, filter);
                query.declareParameters("String objectName, String objectGroup");
                resultSet = (Collection)query.execute((Object)objectName, (Object)objectGroup);
                Iterator iter = resultSet.iterator();
                boolean i = true;
                String max = null;
                NumberRangeEntry numRangeEntry = null;
                NumberRangeEntry numRangeEntryLast = null;
                int indx = 0;
                while (iter.hasNext()) {
                    numRangeEntryLast = (NumberRangeEntry)iter.next();
                    indx = numRangeEntryLast.getIndex();
                    key = numRangeEntryLast.getActCounter();
                    max = numRangeEntryLast.getHigh();
                }
                numRangeEntry = new NumberRangeEntry(objectName, objectGroup, ++indx);
                numRangeEntry.setObjectGroup(objectGroup);
                numRangeEntry.setIndex(indx);
                numRangeEntry.setActCounter(low);
                numRangeEntry.setExternal(ext);
                numRangeEntry.setHigh(high);
                numRangeEntry.setLow(low);
                this.pm.makePersistent((Object)numRangeEntry);
            }
            catch (JDOUserException e) {
                Object[] args = new Object[]{objectName, objectGroup, low, high, ext + ""};
                CAFPublicLogger.traceThrowableT(100, location, method, "JDOUserException in getBusinessObjectId of objectName : {0} objectGroup : {1} low value : {2} high value : {3} external : {4}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectName, objectGroup, low, high, ext + ""};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in getBusinessObjectId of objectName : {0} objectGroup : {1} low value : {2} high value : {3} external : {4}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var20_23 = null;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            this.pm.close();
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        this.pm.close();
    }

    public Collection getNumberRange(String objectName, String objectGroup) throws DataAccessException {
        String method = "getNumberRange(String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectName, objectGroup}, 1);
        String key = null;
        Collection resultSet = null;
        ArrayList<NumberRangeEntry> numRangeEntryList = new ArrayList<NumberRangeEntry>(10);
        Class objectClass = class$com$sap$caf$rt$bol$pk$NumberRangeEntry == null ? (class$com$sap$caf$rt$bol$pk$NumberRangeEntry = PrimaryKeyFactory.class$("com.sap.caf.rt.bol.pk.NumberRangeEntry")) : class$com$sap$caf$rt$bol$pk$NumberRangeEntry;
        String filter = "key == objectName && objGroup == objectGroup";
        try {
            try {
                this.pm = this.pmf.getPersistenceManager();
                Extent extent = this.pm.getExtent(objectClass, true);
                Query query = null;
                query = this.pm.newQuery(extent, filter);
                query.declareParameters("String objectName, String objectGroup");
                resultSet = (Collection)query.execute((Object)objectName, (Object)objectGroup);
                Iterator iter = resultSet.iterator();
                String max = null;
                NumberRangeEntry numRangeEntry = null;
                int indx = 0;
                int i = 0;
                int[] indxArray = new int[10];
                while (iter.hasNext()) {
                    numRangeEntry = (NumberRangeEntry)iter.next();
                    indxArray[i] = indx = numRangeEntry.getIndex();
                    ++i;
                    key = numRangeEntry.getActCounter();
                    max = numRangeEntry.getHigh();
                    numRangeEntryList.add(numRangeEntry);
                }
                Object var18_19 = null;
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectName, objectGroup};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in getNumberRange of objectName : {0} objectGroup : {1} ", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            this.pm.close();
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        this.pm.close();
        return numRangeEntryList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

