/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.pk;

import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

public class Incrementor {
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$pk$Incrementor == null ? (class$com$sap$caf$rt$bol$pk$Incrementor = Incrementor.class$("com.sap.caf.rt.bol.pk.Incrementor")) : class$com$sap$caf$rt$bol$pk$Incrementor).getName();
    private static String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$pk$Incrementor == null ? (class$com$sap$caf$rt$bol$pk$Incrementor = Incrementor.class$("com.sap.caf.rt.bol.pk.Incrementor")) : class$com$sap$caf$rt$bol$pk$Incrementor));
    static /* synthetic */ Class class$com$sap$caf$rt$bol$pk$Incrementor;

    public static String increment(String value, String maxValue, String type) throws DataAccessException {
        String method = "increment(String, String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{value, maxValue, type}, 1);
        String key = null;
        if (type.toUpperCase() == "NUMBER") {
            key = Incrementor.incrementNumber(value, maxValue);
        } else if (type.toUpperCase() == "CHAR") {
            key = Incrementor.incrementString(value, maxValue);
        } else {
            throw new DataAccessException("BO_INVALID_TYPE");
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return key;
    }

    public static String incrementString(String value, String maxValue) throws DataAccessException {
        String method = "incrementString(String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{value, maxValue}, 1);
        char lastChar = value.charAt(value.length() - 1);
        int lastDigit = Character.digit(lastChar, 36);
        if (lastDigit < 35) {
            char newChar = Character.forDigit(lastDigit + 1, 36);
            value = value.substring(0, value.length() - 1) + newChar;
        } else {
            char newChar = Character.forDigit(1, 36);
            value = value + newChar;
        }
        if (Incrementor.isGreater(value, maxValue)) {
            throw new DataAccessException("BO_OUT_OF_RANGE", new Object[]{value, maxValue});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return value.toUpperCase();
    }

    public static String incrementNumber(String value, String maxValue) throws DataAccessException {
        String method = "incrementNumber(String, String)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{value, maxValue}, 1);
        long key = Long.parseLong(value.trim());
        if (key == Long.parseLong(maxValue.trim())) {
            throw new DataAccessException("BO_OUT_OF_RANGE", new Object[]{value, maxValue});
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return String.valueOf(key + 1L);
    }

    public static boolean isGreater(String value, String maxValue) {
        boolean gt = true;
        if (value.length() <= maxValue.length() && value.toUpperCase().compareTo(maxValue.toUpperCase()) <= 0) {
            gt = false;
        }
        return gt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

