/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.da.remote;

import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.types.api.IComplexType;
import com.sap.caf.mp.core.data.types.api.IElement;
import com.sap.caf.mp.core.data.types.api.IMessage;
import com.sap.caf.mp.core.data.types.api.IMessagepart;
import com.sap.caf.mp.core.data.types.api.ISimpleType;
import com.sap.caf.mp.core.data.types.api.IStructure;
import com.sap.caf.mp.core.data.types.api.IType;
import com.sap.caf.mp.core.data.values.api.IComplexTypeValue;
import com.sap.caf.mp.core.data.values.api.IElementValue;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.mp.core.data.values.api.IMessagepartValue;
import com.sap.caf.mp.core.data.values.api.ISimpleTypeValue;
import com.sap.caf.mp.core.data.values.api.IStructureValue;
import com.sap.caf.mp.core.data.values.api.ITypeValue;
import com.sap.caf.mp.core.data.values.base.ComplexTypeValue;
import com.sap.caf.mp.core.data.values.base.ElementValue;
import com.sap.caf.mp.core.data.values.base.MessageValue;
import com.sap.caf.mp.core.data.values.base.MessagepartValue;
import com.sap.caf.mp.core.data.values.base.SimpleTypeValue;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public class MessageEntityConverter {
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$da$remote$MessageEntityConverter == null ? (class$com$sap$caf$rt$bol$da$remote$MessageEntityConverter = MessageEntityConverter.class$("com.sap.caf.rt.bol.da.remote.MessageEntityConverter")) : class$com$sap$caf$rt$bol$da$remote$MessageEntityConverter));
    private static MessageEntityConverter converter;
    private static final String[] keywordRestrictions;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$da$remote$MessageEntityConverter;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Collection;

    private MessageEntityConverter() {
    }

    public static MessageEntityConverter getInstance() {
        if (converter == null) {
            converter = new MessageEntityConverter();
        }
        return converter;
    }

    public IMessageValue createInputMessageValue(Object input, IMessage inputMessage) throws InvocationException {
        location.debugT("Entering createInputMessageValue()");
        MessageValue inputMessageValue = new MessageValue(inputMessage);
        Enumeration messageParts = inputMessage.getMessagepartEnumeration();
        while (messageParts.hasMoreElements()) {
            IMessagepart messagePart = (IMessagepart)messageParts.nextElement();
            location.debugT("Processing message part with name=" + messagePart.getName());
            MessagepartValue messagePartValue = new MessagepartValue(messagePart);
            IStructure messagePartStructure = messagePart.getStructure();
            IElement messagePartElement = (IElement)messagePartStructure;
            location.debugT("Processing element with name=" + messagePartElement.getName());
            ElementValue elementValue = new ElementValue(messagePartElement);
            IType elementType = messagePartElement.getType();
            IComplexType elementComplexType = (IComplexType)elementType;
            ComplexTypeValue complexTypeValue = new ComplexTypeValue(elementComplexType);
            Enumeration elements = elementComplexType.getElementEnumeration();
            while (elements.hasMoreElements()) {
                IElement element = (IElement)elements.nextElement();
                location.debugT("Processing element with name=" + element.getName());
                IElementValue value = this.createElementValue(input, element);
                complexTypeValue.addElementValue(value);
            }
            elementValue.addTypeValue((ITypeValue)complexTypeValue);
            messagePartValue.setStructureValue((IStructureValue)elementValue);
            inputMessageValue.addMessagepartValue((IMessagepartValue)messagePartValue);
        }
        location.debugT("Exiting createInputMessageValue()");
        return inputMessageValue;
    }

    private IElementValue createElementValue(Object input, IElement element) throws InvocationException {
        location.debugT("Entering createElementValue()");
        String elementName = element.getName();
        location.debugT("Processing element with name=" + elementName);
        ElementValue elementValue = new ElementValue(element);
        if (input != null) {
            IType elementType = element.getType();
            Object value = this.getValue(input, elementName);
            int maxOccurs = element.getMaxOccurs();
            if (elementType instanceof IComplexType) {
                location.debugT("Element type is complex type");
                IComplexType elementComplexType = (IComplexType)elementType;
                if (maxOccurs == 1) {
                    IComplexTypeValue complexTypeValue = this.createComplexTypeValue(value, elementComplexType);
                    elementValue.addTypeValue((ITypeValue)complexTypeValue);
                } else {
                    Iterator valuesIter = ((Collection)value).iterator();
                    while (valuesIter.hasNext()) {
                        Object current = valuesIter.next();
                        IComplexTypeValue complexTypeValue = this.createComplexTypeValue(current, elementComplexType);
                        elementValue.addTypeValue((ITypeValue)complexTypeValue);
                    }
                }
            } else if (elementType instanceof ISimpleType) {
                location.debugT("Element type is simple type");
                ISimpleType elementSimpleType = (ISimpleType)elementType;
                if (maxOccurs == 1) {
                    ISimpleTypeValue simpleTypeValue = this.createSimpleTypeValue(value, elementSimpleType);
                    elementValue.addTypeValue((ITypeValue)simpleTypeValue);
                } else {
                    Iterator valuesIter = ((Collection)value).iterator();
                    while (valuesIter.hasNext()) {
                        Object current = valuesIter.next();
                        ISimpleTypeValue simpleTypeValue = this.createSimpleTypeValue(current, elementSimpleType);
                        elementValue.addTypeValue((ITypeValue)simpleTypeValue);
                    }
                }
            }
        }
        location.debugT("Exiting createElementValue()");
        return elementValue;
    }

    private IComplexTypeValue createComplexTypeValue(Object input, IComplexType complexType) throws InvocationException {
        location.debugT("Entering createComplexTypeValue()");
        ComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
        Enumeration elements = complexType.getElementEnumeration();
        while (elements.hasMoreElements()) {
            IElement element = (IElement)elements.nextElement();
            IElementValue elementValue = this.createElementValue(input, element);
            complexTypeValue.addElementValue(elementValue);
        }
        location.debugT("Exiting createComplexTypeValue()");
        return complexTypeValue;
    }

    private ISimpleTypeValue createSimpleTypeValue(Object input, ISimpleType simpleType) throws InvocationException {
        location.debugT("Entering createSimpleTypeValue()");
        SimpleTypeValue simpleTypeValue = new SimpleTypeValue(simpleType);
        int base = simpleType.getBase();
        location.debugT("Base type number=" + base);
        switch (base) {
            case 1: {
                location.debugT("Base type is base64binary");
                simpleTypeValue.setValueByteArray((byte[])input);
                break;
            }
            case 2: {
                location.debugT("Base type is boolean");
                simpleTypeValue.setValueBoolean((Boolean)input);
                break;
            }
            case 3: {
                location.debugT("Base type is byte");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 4: {
                location.debugT("Base type is date");
                simpleTypeValue.setValueDate((Date)input);
                break;
            }
            case 5: {
                location.debugT("Base type is decimal");
                simpleTypeValue.setValueBigDecimal((BigDecimal)input);
                break;
            }
            case 6: {
                location.debugT("Base type is double");
                simpleTypeValue.setValueDouble((Double)input);
                break;
            }
            case 7: {
                location.debugT("Base type is float");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 8: {
                location.debugT("Base type is int");
                simpleTypeValue.setValueInteger((Integer)input);
                break;
            }
            case 9: {
                location.debugT("Base type is integer");
                simpleTypeValue.setValueInteger((Integer)input);
                break;
            }
            case 10: {
                location.debugT("Base type is long");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 11: {
                location.debugT("Base type is short");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 12: {
                location.debugT("Base type is string");
                simpleTypeValue.setValueString((String)input);
                break;
            }
            case 13: {
                location.debugT("Base type is time");
                simpleTypeValue.setValueDate((Date)input);
                break;
            }
            case 14: {
                location.debugT("Base type is timestamp");
                simpleTypeValue.setValueDate((Date)input);
                break;
            }
            case 15: {
                location.debugT("Base type is unsigned byte");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 16: {
                location.debugT("Base type is unsigned int");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 17: {
                location.debugT("Base type is unsigned long");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            case 18: {
                location.debugT("Base type is unsigned short");
                simpleTypeValue.setValue(input.toString());
                break;
            }
            default: {
                throw new InvocationException("Unknown simple type.");
            }
        }
        location.debugT("Exiting createSimpleTypeValue()");
        return simpleTypeValue;
    }

    private Object getValue(Object object, String attributeName) throws InvocationException {
        Object result;
        try {
            if (object instanceof IDependentObject) {
                result = ((IDependentObject)object).getProperty(attributeName);
            } else {
                Method method = object.getClass().getMethod("get" + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(attributeName)), new Class[0]);
                result = method.invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        return result;
    }

    public IMessageValue createInputMessageValueFromFilters(IntQueryFilter[] filters, IMessage inputMessage) throws InvocationException {
        location.debugT("Entering createInputMessageValueFromFilters()");
        MessageValue inputMessageValue = new MessageValue(inputMessage);
        Enumeration messageParts = inputMessage.getMessagepartEnumeration();
        while (messageParts.hasMoreElements()) {
            IMessagepart messagePart = (IMessagepart)messageParts.nextElement();
            location.debugT("Processing message part with name=" + messagePart.getName());
            IMessagepartValue messagePartValue = this.createInputMessagePartValueFromFilters(filters, messagePart);
            inputMessageValue.addMessagepartValue(messagePartValue);
        }
        location.debugT("Exiting createInputMessageValueFromFilters()");
        return inputMessageValue;
    }

    private IMessagepartValue createInputMessagePartValueFromFilters(IntQueryFilter[] filters, IMessagepart messagePart) throws InvocationException {
        location.debugT("Entering createInputMessagePartValueFromFilters()");
        MessagepartValue messagePartValue = new MessagepartValue(messagePart);
        IStructure messagePartStructure = messagePart.getStructure();
        IElement messagePartElement = (IElement)messagePartStructure;
        IElementValue elementValue = this.createElementValueFromFilters(filters, messagePartElement);
        messagePartValue.setStructureValue((IStructureValue)elementValue);
        location.debugT("Exiting createInputMessagePartValueFromFilters()");
        return messagePartValue;
    }

    private IElementValue createElementValueFromFilters(IntQueryFilter[] filters, IElement element) throws InvocationException {
        location.debugT("Entering createElementValueFromFilters()");
        String elementName = element.getName();
        location.debugT("Processing element with name=" + elementName);
        ElementValue elementValue = new ElementValue(element);
        IType elementType = element.getType();
        location.debugT("Element type is complex type");
        IComplexType elementComplexType = (IComplexType)elementType;
        IComplexTypeValue complexTypeValue = this.createComplexTypeValueFromFilters(filters, elementComplexType);
        elementValue.addTypeValue((ITypeValue)complexTypeValue);
        location.debugT("Exiting createElementValueFromFilters()");
        return elementValue;
    }

    private IComplexTypeValue createComplexTypeValueFromFilters(IntQueryFilter[] filters, IComplexType complexType) throws InvocationException {
        location.debugT("Entering createComplexTypeValueFromFilters()");
        ComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
        for (int i = 0; i < filters.length; ++i) {
            IElement element = complexType.getElement(filters[i].getAttribute());
            IElementValue elementValue = this.createFilterElementValue(filters[i], element);
            complexTypeValue.addElementValue(elementValue);
        }
        location.debugT("Exiting createComplexTypeValueFromFilters()");
        return complexTypeValue;
    }

    private IElementValue createFilterElementValue(IntQueryFilter filter, IElement element) throws InvocationException {
        location.debugT("Entering createFilterElementValue()");
        String elementName = element.getName();
        location.debugT("Processing element with name=" + elementName);
        ElementValue elementValue = new ElementValue(element);
        IType elementType = element.getType();
        location.debugT("Element type is complex type");
        IComplexType elementComplexType = (IComplexType)elementType;
        IComplexTypeValue complexTypeValue = this.createComplexTypeValueFromFilter(filter, elementComplexType);
        elementValue.addTypeValue((ITypeValue)complexTypeValue);
        location.debugT("Exiting createFilterElementValue()");
        return elementValue;
    }

    private IComplexTypeValue createComplexTypeValueFromFilter(IntQueryFilter filter, IComplexType complexType) throws InvocationException {
        location.debugT("Entering createComplexTypeValueFromFilter()");
        ComplexTypeValue complexTypeValue = new ComplexTypeValue(complexType);
        IElement elementLow = complexType.getElement("minValue");
        IElementValue elementLowValue = this.createSimpleTypeElementValue(filter.getAttributeValue().toString(), elementLow);
        complexTypeValue.addElementValue(elementLowValue);
        IElement elementHigh = complexType.getElement("maxValue");
        IElementValue elementHighValue = this.createSimpleTypeElementValue(filter.getAttributeValueHigh().toString(), elementHigh);
        complexTypeValue.addElementValue(elementHighValue);
        IElement elementCondition = complexType.getElement("option");
        IElementValue elementConditionValue = this.createSimpleTypeElementValue(filter.condition, elementCondition);
        complexTypeValue.addElementValue(elementConditionValue);
        location.debugT("Exiting createComplexTypeValueFromFilter()");
        return complexTypeValue;
    }

    private IElementValue createSimpleTypeElementValue(String value, IElement element) throws InvocationException {
        location.debugT("Entering createSimpleTypeElementValue()");
        String elementName = element.getName();
        location.debugT("Processing element with name=" + elementName);
        ElementValue elementValue = new ElementValue(element);
        SimpleTypeValue simpleTypeValue = new SimpleTypeValue((ISimpleType)element.getType());
        simpleTypeValue.setValueString(value);
        elementValue.addTypeValue((ITypeValue)simpleTypeValue);
        location.debugT("Exiting createSimpleTypeElementValue()");
        return elementValue;
    }

    public IBusinessObject createOutputBusinessObject(IMessageValue messageValue, Class objectClass) throws InvocationException {
        location.debugT("Entering createOutputBusinessObject()");
        IBusinessObject result = null;
        try {
            result = (IBusinessObject)objectClass.newInstance();
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        result = (IBusinessObject)this.retrieveMessageValue(messageValue, result);
        location.debugT("Exiting createOutputBusinessObject()");
        return result;
    }

    public Object retrieveMessageValue(IMessageValue messageValue, Object object) throws InvocationException {
        location.debugT("Entering retrieveMessageValue()");
        Object result = null;
        if (messageValue != null) {
            result = object;
            Enumeration messageValueParts = messageValue.getMessagepartValueEnumeration();
            while (messageValueParts.hasMoreElements()) {
                IMessagepartValue messagePartValue = (IMessagepartValue)messageValueParts.nextElement();
                location.debugT("Processing message part with name=" + messagePartValue.getMessagepart().getName());
                IStructureValue messagePartStructureValue = messagePartValue.getStructureValue();
                IElementValue elementValue = (IElementValue)messagePartStructureValue;
                location.debugT("Processing element with name=" + elementValue.getElement().getName());
                IComplexTypeValue elementTypeValue = (IComplexTypeValue)elementValue.getTypeValue(0);
                Enumeration elements = elementTypeValue.getElementValueEnumeration();
                while (elements.hasMoreElements()) {
                    IElementValue value = (IElementValue)elements.nextElement();
                    location.debugT("Processing element with name=" + value.getElement().getName());
                    result = this.retrieveElementValue(value, result);
                }
            }
        }
        location.debugT("Exiting retrieveMessageValue()");
        return result;
    }

    private Object retrieveElementValue(IElementValue elementValue, Object object) throws InvocationException {
        location.debugT("Entering retrieveElementValue()");
        String elementValueName = elementValue.getElement().getName();
        location.debugT("Processing element with name=" + elementValueName);
        Object result = object;
        IElement element = elementValue.getElement();
        String elementName = element.getName();
        IType elementType = element.getType();
        int maxOccurs = element.getMaxOccurs();
        if (elementType instanceof IComplexType) {
            location.debugT("Element type is complex type");
            if (maxOccurs == 1) {
                IComplexTypeValue elementComplexTypeValue = (IComplexTypeValue)elementValue.getTypeValue(0);
                if (elementComplexTypeValue != null) {
                    Object complexAttribute = this.createNewInstance(object.getClass(), elementName, object.getClass().getClassLoader());
                    complexAttribute = this.retrieveComplexTypeValue(elementComplexTypeValue, complexAttribute);
                    this.setValue(result, complexAttribute, elementName);
                }
            } else {
                Enumeration typeValues = elementValue.getTypeValueEnumeration();
                ArrayList<Object> values = new ArrayList<Object>();
                while (typeValues.hasMoreElements()) {
                    IComplexTypeValue typeValue = (IComplexTypeValue)typeValues.nextElement();
                    if (typeValue == null) continue;
                    Object complexAttribute = this.createNewInstance(object.getClass(), elementName, object.getClass().getClassLoader());
                    complexAttribute = this.retrieveComplexTypeValue(typeValue, complexAttribute);
                    values.add(complexAttribute);
                }
                this.setCollection(result, values, element.getName());
            }
        } else if (elementType instanceof ISimpleType) {
            location.debugT("Element type is simple type");
            if (maxOccurs == 1) {
                ISimpleTypeValue elementSimpleTypeValue = (ISimpleTypeValue)elementValue.getTypeValue(0);
                if (elementSimpleTypeValue != null) {
                    this.setValue(result, elementSimpleTypeValue, elementName);
                }
            } else {
                Enumeration typeValues = elementValue.getTypeValueEnumeration();
                ArrayList<Object> values = new ArrayList<Object>();
                while (typeValues.hasMoreElements()) {
                    ISimpleTypeValue typeValue = (ISimpleTypeValue)typeValues.nextElement();
                    Object simpleAttribute = this.retrieveSimpleTypeValue(typeValue);
                    values.add(simpleAttribute);
                }
                this.setCollection(result, values, elementName);
            }
        }
        location.debugT("Exiting retrieveElementValue()");
        return result;
    }

    public Object retrieveComplexTypeValue(IComplexTypeValue complexTypeValue, Object object) throws InvocationException {
        location.debugT("Entering retrieveComplexTypeValue()");
        Object result = object;
        Enumeration elementValues = complexTypeValue.getElementValueEnumeration();
        while (elementValues.hasMoreElements()) {
            IElementValue elementValue = (IElementValue)elementValues.nextElement();
            result = this.retrieveElementValue(elementValue, result);
        }
        location.debugT("Exiting retrieveComplexTypeValue()");
        return result;
    }

    private Object retrieveSimpleTypeValue(ISimpleTypeValue simpleTypeValue) throws InvocationException {
        return this.getValueAndClass(simpleTypeValue).getValue();
    }

    private void setValue(Object object, ISimpleTypeValue value, String attributeName) throws InvocationException {
        location.debugT("Entering setValue()");
        ValueClass valueClass = this.getValueAndClass(value);
        Class objectClass = valueClass.getObjectClass();
        Object objectValue = valueClass.getValue();
        location.debugT("value=" + objectValue);
        try {
            if (object instanceof IDependentObject) {
                ((IDependentObject)object).setProperty(attributeName, objectValue);
            } else {
                Method method = object.getClass().getMethod("set" + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(attributeName)), objectClass);
                method.invoke(object, objectValue);
            }
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        location.debugT("Exiting setValue()");
    }

    private ValueClass getValueAndClass(ISimpleTypeValue value) throws InvocationException {
        Class objectClass = null;
        Object objectValue = null;
        int base = value.getSimpleType().getBase();
        location.debugT("Base type number=" + base);
        switch (base) {
            case 1: {
                location.debugT("Base type is base64binary");
                objectClass = array$B == null ? (array$B = MessageEntityConverter.class$("[B")) : array$B;
                objectValue = value.getValueByteArray();
                break;
            }
            case 2: {
                location.debugT("Base type is boolean");
                objectClass = Boolean.TYPE;
                objectValue = value.getValueBoolean();
                break;
            }
            case 3: {
                location.debugT("Base type is byte");
                objectClass = Byte.TYPE;
                objectValue = new Byte(value.getValue());
                break;
            }
            case 4: {
                location.debugT("Base type is date");
                objectClass = class$java$util$Date == null ? (class$java$util$Date = MessageEntityConverter.class$("java.util.Date")) : class$java$util$Date;
                objectValue = value.getValueDate();
                break;
            }
            case 5: {
                location.debugT("Base type is decimal");
                objectClass = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MessageEntityConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                objectValue = value.getValueBigDecimal();
                break;
            }
            case 6: {
                location.debugT("Base type is double");
                objectClass = Double.TYPE;
                objectValue = value.getValueDouble();
                break;
            }
            case 7: {
                location.debugT("Base type is float");
                objectClass = Float.TYPE;
                objectValue = new Float(value.getValue());
                break;
            }
            case 8: {
                location.debugT("Base type is int");
                objectClass = Integer.TYPE;
                objectValue = value.getValueInteger();
                break;
            }
            case 9: {
                location.debugT("Base type is integer");
                objectClass = class$java$lang$Integer == null ? (class$java$lang$Integer = MessageEntityConverter.class$("java.lang.Integer")) : class$java$lang$Integer;
                objectValue = value.getValueInteger();
                break;
            }
            case 10: {
                location.debugT("Base type is long");
                objectClass = Long.TYPE;
                objectValue = new Long(value.getValue());
                break;
            }
            case 11: {
                location.debugT("Base type is short");
                objectClass = Short.TYPE;
                objectValue = new Short(value.getValue());
                break;
            }
            case 12: {
                location.debugT("Base type is string");
                objectClass = class$java$lang$String == null ? (class$java$lang$String = MessageEntityConverter.class$("java.lang.String")) : class$java$lang$String;
                objectValue = value.getValueString();
                break;
            }
            case 13: {
                location.debugT("Base type is time");
                objectClass = class$java$util$Date == null ? (class$java$util$Date = MessageEntityConverter.class$("java.util.Date")) : class$java$util$Date;
                objectValue = value.getValueDate();
                break;
            }
            case 14: {
                location.debugT("Base type is timestamp");
                objectClass = class$java$util$Date == null ? (class$java$util$Date = MessageEntityConverter.class$("java.util.Date")) : class$java$util$Date;
                objectValue = value.getValueDate();
                break;
            }
            case 15: {
                location.debugT("Base type is unsigned byte");
                objectClass = Byte.TYPE;
                objectValue = new Byte(value.getValue());
                if ((Byte)objectValue >= 0) break;
                throw new InvocationException("Base type is unsigned but value is negative.");
            }
            case 16: {
                location.debugT("Base type is unsigned int");
                objectClass = Integer.TYPE;
                objectValue = value.getValueInteger();
                if ((Integer)objectValue >= 0) break;
                throw new InvocationException("Base type is unsigned but value is negative.");
            }
            case 17: {
                location.debugT("Base type is unsigned long");
                objectClass = Long.TYPE;
                objectValue = new Long(value.getValue());
                if ((Long)objectValue >= 0L) break;
                throw new InvocationException("Base type is unsigned but value is negative.");
            }
            case 18: {
                location.debugT("Base type is unsigned short");
                objectClass = Short.TYPE;
                objectValue = new Short(value.getValue());
                if ((Short)objectValue >= 0) break;
                throw new InvocationException("Base type is unsigned but value is negative.");
            }
            default: {
                throw new InvocationException("Unknown simple type.");
            }
        }
        ValueClass result = new ValueClass();
        result.setObjectClass(objectClass);
        result.setValue(objectValue);
        return result;
    }

    private void setValue(Object object, Object value, String attributeName) throws InvocationException {
        try {
            if (object instanceof IDependentObject) {
                ((IDependentObject)object).setProperty(attributeName, value);
            } else {
                Method method = object.getClass().getMethod("set" + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(attributeName)), value.getClass());
                method.invoke(object, value);
            }
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
    }

    private void setCollection(Object object, Collection collection, String attributeName) throws InvocationException {
        try {
            if (object instanceof IDependentObject) {
                ((IDependentObject)object).setProperty(attributeName, collection);
            } else {
                Method method = object.getClass().getMethod("set" + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(attributeName)), class$java$util$Collection == null ? (class$java$util$Collection = MessageEntityConverter.class$("java.util.Collection")) : class$java$util$Collection);
                method.invoke(object, collection);
            }
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
    }

    private Object createNewInstance(Class parentClass, String className, ClassLoader classLoader) throws InvocationException {
        try {
            Class<?> objectClass = classLoader.loadClass(parentClass.getName() + '$' + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(className)));
            return objectClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> objectClass = classLoader.loadClass(parentClass.getPackage().getName() + '.' + MessageEntityConverter.capitalize(MessageEntityConverter.constructJavaIdentifier(className)));
                return objectClass.newInstance();
            }
            catch (Exception ex) {
                throw new InvocationException(ex);
            }
        }
    }

    private static boolean isValidMemberName(String memberName) {
        if (memberName == null) {
            return false;
        }
        return !MessageEntityConverter.isInsideTheArray(memberName, keywordRestrictions);
    }

    private static String escapeJavaReservedWords(String param) {
        if (!MessageEntityConverter.isValidMemberName(param)) {
            return "_" + param;
        }
        return param;
    }

    private static String constructJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (!Character.isJavaIdentifierStart(s.charAt(0)) || s.charAt(0) == '$' || s.charAt(0) == '_') {
            result.append(MessageEntityConverter.escapeSequence(s.charAt(0)));
        } else {
            result.append(s.charAt(0));
        }
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isJavaIdentifierPart(s.charAt(i)) || s.charAt(i) == '$' || s.charAt(i) == '_') {
                result.append(MessageEntityConverter.escapeSequence(s.charAt(i)));
                continue;
            }
            result.append(s.charAt(i));
        }
        return MessageEntityConverter.escapeJavaReservedWords(result.toString());
    }

    private static String escapeSequence(char c) {
        switch (c) {
            case '_': {
                return "__";
            }
            case '$': {
                return "_dol_";
            }
            case '/': {
                return "_sh_";
            }
            case ':': {
                return "_";
            }
            case '.': {
                return "_dot_";
            }
            case '-': {
                return "_minus_";
            }
        }
        return "_" + String.valueOf((int)c) + "_";
    }

    private static boolean isInsideTheArray(String attribute, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(attribute)) continue;
            return true;
        }
        return false;
    }

    private static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuffer(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        keywordRestrictions = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};
    }

    class ValueClass {
        private Object value;
        private Class objectClass;

        ValueClass() {
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object getValue() {
            return this.value;
        }

        public void setObjectClass(Class class1) {
            this.objectClass = class1;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

