/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.da.jdo.registration;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.da.jdo.registration.DeletedObject;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class DeletedObjectsRegistrationService {
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService == null ? (class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService = DeletedObjectsRegistrationService.class$("com.sap.caf.rt.bol.da.jdo.registration.DeletedObjectsRegistrationService")) : class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService).getName();
    private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService == null ? (class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService = DeletedObjectsRegistrationService.class$("com.sap.caf.rt.bol.da.jdo.registration.DeletedObjectsRegistrationService")) : class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService));
    public static final String dataSource = "jdbc/SAP/CAF_RT";
    private static Connection con;
    private static final String TABLE_NAME = "CAF_RT_DEL_OBJECTS";
    private static final String ID = "ID";
    private static final String MOFID = "MOFID";
    private static final String OBJECT_KEY = "OBJECT_KEY";
    private static final String DELETED_AT = "DELETED_AT";
    private static final String insertQuery = "INSERT INTO CAF_RT_DEL_OBJECTS ( ID,MOFID,OBJECT_KEY,DELETED_AT )  VALUES (?,?,?,?)";
    private static final String clearQuery = "DELETE FROM CAF_RT_DEL_OBJECTS";
    private static final String selectAllQuery = "SELECT * FROM CAF_RT_DEL_OBJECTS";
    private static final String selectByMofidQuery = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE MOFID =? ";
    private static final String selectByDatesQuery = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE DELETED_AT >=? AND DELETED_AT <=? ";
    private static final String selectByDatesQueryNullHighDate = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE DELETED_AT >=? ";
    private static final String selectByDatesQueryNullLowDate = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE DELETED_AT <=? ";
    private static final String selectByMofidAndDatesQuery = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE MOFID =? AND DELETED_AT >=? AND DELETED_AT <=?";
    private static final String selectByMofidAndDatesQueryNullHighDate = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE MOFID =? AND DELETED_AT >=? ";
    private static final String selectByMofidAndDatesQueryNullLowDate = "SELECT * FROM CAF_RT_DEL_OBJECTS WHERE MOFID =? AND DELETED_AT <=? ";
    static /* synthetic */ Class class$com$sap$caf$rt$bol$da$jdo$registration$DeletedObjectsRegistrationService;

    public static void registerDelete(IDependentObject obj) throws DataAccessException {
        if (DeletedObjectsRegistrationService.isRegistrationServiceEnabled() && obj instanceof IBusinessObject) {
            if (con == null) {
                DeletedObjectsRegistrationService.initJDBCConnection();
            }
            try {
                PreparedStatement ps = con.prepareStatement(insertQuery);
                String key = PrimaryKeyFactory.getInstance().getPrimaryKey();
                String mofid = DeletedObjectsRegistrationService.getObjectMofid((IBusinessObject)obj);
                String objectKey = obj.getKey();
                Date deletedAt = new Date();
                ps.setString(1, key);
                ps.setString(2, mofid);
                ps.setString(3, objectKey);
                ps.setTimestamp(4, new Timestamp(deletedAt.getTime()));
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new DataAccessException(e);
            }
        }
    }

    public static int clear() throws DataAccessException {
        if (con == null) {
            DeletedObjectsRegistrationService.initJDBCConnection();
        }
        try {
            Statement stmt = con.createStatement();
            int count = stmt.executeUpdate(clearQuery);
            stmt.close();
            return count;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    public static Collection findAllDeleted() throws DataAccessException {
        ArrayList<DeletedObject> list = new ArrayList<DeletedObject>();
        if (con == null) {
            DeletedObjectsRegistrationService.initJDBCConnection();
        }
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(selectAllQuery);
            while (rs.next()) {
                DeletedObject delObj = new DeletedObject();
                delObj.setKey(rs.getString(ID));
                delObj.setMofid(rs.getString(MOFID));
                delObj.setObjectKey(rs.getString(OBJECT_KEY));
                delObj.setDeletedAt(rs.getTimestamp(DELETED_AT));
                list.add(delObj);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return list;
    }

    public static Collection findDeletedByMofid(String mofid) throws DataAccessException {
        ArrayList<DeletedObject> list = new ArrayList<DeletedObject>();
        if (con == null) {
            DeletedObjectsRegistrationService.initJDBCConnection();
        }
        try {
            PreparedStatement ps = con.prepareStatement(selectByMofidQuery);
            ps.setString(1, mofid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DeletedObject delObj = new DeletedObject();
                delObj.setKey(rs.getString(ID));
                delObj.setMofid(rs.getString(MOFID));
                delObj.setObjectKey(rs.getString(OBJECT_KEY));
                delObj.setDeletedAt(rs.getTimestamp(DELETED_AT));
                list.add(delObj);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return list;
    }

    public static Collection findDeletedByDates(Date startDate, Date endDate) throws DataAccessException {
        ArrayList<DeletedObject> list = new ArrayList<DeletedObject>();
        if (con == null) {
            DeletedObjectsRegistrationService.initJDBCConnection();
        }
        try {
            PreparedStatement ps = null;
            if (startDate == null) {
                if (endDate == null) {
                    ps = con.prepareStatement(selectAllQuery);
                } else {
                    ps = con.prepareStatement(selectByDatesQueryNullLowDate);
                    ps.setTimestamp(1, new Timestamp(endDate.getTime()));
                }
            } else if (endDate == null) {
                ps = con.prepareStatement(selectByDatesQueryNullHighDate);
                ps.setTimestamp(1, new Timestamp(startDate.getTime()));
            } else {
                ps = con.prepareStatement(selectByDatesQuery);
                ps.setTimestamp(1, new Timestamp(startDate.getTime()));
                ps.setTimestamp(2, new Timestamp(endDate.getTime()));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DeletedObject delObj = new DeletedObject();
                delObj.setKey(rs.getString(ID));
                delObj.setMofid(rs.getString(MOFID));
                delObj.setObjectKey(rs.getString(OBJECT_KEY));
                delObj.setDeletedAt(rs.getTimestamp(DELETED_AT));
                list.add(delObj);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return list;
    }

    private static void initJDBCConnection() throws DataAccessException {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dataSource);
            con = ds.getConnection();
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    private static String getObjectMofid(IBusinessObject obj) throws DataAccessException {
        try {
            Field field = obj.getClass().getDeclaredField("objectGuid");
            field.setAccessible(true);
            String objectGuid = (String)field.get(null);
            if (objectGuid != null) {
                return objectGuid;
            }
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        try {
            String objRid = obj.getRid();
            int index1 = objRid.indexOf(47);
            objRid = objRid.substring(index1 + 1);
            index1 = objRid.indexOf(47);
            objRid = objRid.substring(0, index1);
            if (objRid != null) {
                return objRid;
            }
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return "";
    }

    private static boolean isRegistrationServiceEnabled() {
        return CAFContext.DELETION_REGISTRATION_ENABLED;
    }

    public static Collection findDeletedByMofidAndDates(String mofid, Date startDate, Date endDate) throws DataAccessException {
        ArrayList<DeletedObject> list = new ArrayList<DeletedObject>();
        if (con == null) {
            DeletedObjectsRegistrationService.initJDBCConnection();
        }
        try {
            PreparedStatement ps = null;
            if (startDate == null) {
                if (endDate == null) {
                    ps = con.prepareStatement(selectByMofidQuery);
                } else {
                    ps = con.prepareStatement(selectByMofidAndDatesQueryNullLowDate);
                    ps.setTimestamp(2, new Timestamp(endDate.getTime()));
                }
            } else if (endDate == null) {
                ps = con.prepareStatement(selectByMofidAndDatesQueryNullHighDate);
                ps.setTimestamp(2, new Timestamp(startDate.getTime()));
            } else {
                ps = con.prepareStatement(selectByMofidAndDatesQuery);
                ps.setTimestamp(2, new Timestamp(startDate.getTime()));
                ps.setTimestamp(3, new Timestamp(endDate.getTime()));
            }
            ps.setString(1, mofid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DeletedObject delObj = new DeletedObject();
                delObj.setKey(rs.getString(ID));
                delObj.setMofid(rs.getString(MOFID));
                delObj.setObjectKey(rs.getString(OBJECT_KEY));
                delObj.setDeletedAt(rs.getTimestamp(DELETED_AT));
                list.add(delObj);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

