/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.bol.da.jdo;

import com.sap.caf.bw.api.BWProcessorLocalFactory;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.da.jdo.registration.DeletedObjectsRegistrationService;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.UserContext;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.exception.BaseRuntimeException;
import com.sap.jdo.SAPJDOHelper;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JDODataAccessService
implements IDataAccessService {
    private static final long serialVersionUID = 1L;
    private static PersistenceManagerFactory pmf = null;
    private static final String JNDI_NAME = CAFContext.JNDI_NAME_JDO;
    private static final String APPLICATION = (class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService == null ? (class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService = JDODataAccessService.class$("com.sap.caf.rt.bol.da.jdo.JDODataAccessService")) : class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService).getName();
    private static final String JARM_REQUEST = "CAF:RT:oal" + APPLICATION;
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService == null ? (class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService = JDODataAccessService.class$("com.sap.caf.rt.bol.da.jdo.JDODataAccessService")) : class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService));
    private UserContext userContext = null;
    static /* synthetic */ Class class$com$sap$caf$rt$bol$da$jdo$JDODataAccessService;

    public JDODataAccessService() throws DataAccessException {
        String method = "JDODataAccessService()";
        try {
            Object[] _obj = new Object[]{JNDI_NAME};
            if (pmf == null) {
                InitialContext jndi = new InitialContext();
                pmf = (PersistenceManagerFactory)jndi.lookup(JNDI_NAME);
            }
            location.debugT("JNDI look up of {0} Successful", _obj);
        }
        catch (NamingException e) {
            Object[] args = new Object[]{JNDI_NAME};
            CAFPublicLogger.categoryCAF.logThrowableT(500, location, method, "Error in JNDI lookup of {0}", args, (Throwable)e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
    }

    public static IDataAccessService getInstance() throws DataAccessException {
        String method = "getInstance()";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        JDODataAccessService jdoDataAccessService = new JDODataAccessService();
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return jdoDataAccessService;
    }

    public void destroy() {
    }

    public void remove(IDependentObject obj) throws DataAccessException {
        String method = "remove(IDependentObject)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{obj}, 1);
        PersistenceManager pm = null;
        try {
            try {
                if (CAFContext.CAF_BW_INTEGRATION_ENABLED && BWProcessorLocalFactory.getProcessorLocalInstance().checkIsCAFServiceLogicallyLocked(obj.getObjectType())) {
                    throw new DataAccessException("BO_LOCKED_BY_CAF_BW_INTEGRATION", new Object[]{obj.getObjectType()});
                }
                pm = pmf.getPersistenceManager();
                SAPJDOHelper.registerPCClass(obj.getClass());
                Object removeObj = pm.getObjectById((Object)obj.getPK(), true);
                pm.deletePersistent(removeObj);
                DeletedObjectsRegistrationService.registerDelete(obj);
            }
            catch (Exception e) {
                Object[] args = new Object[]{obj};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error removing Business-Object-Instance of {0}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var7_6 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
    }

    public String create(IDependentObject obj) throws DataAccessException {
        String method = "create(IDependentObject)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{obj.getKey()}, 1);
        PersistenceManager pm = null;
        try {
            try {
                if (CAFContext.CAF_BW_INTEGRATION_ENABLED && BWProcessorLocalFactory.getProcessorLocalInstance().checkIsCAFServiceLogicallyLocked(obj.getObjectType())) {
                    throw new DataAccessException("BO_LOCKED_BY_CAF_BW_INTEGRATION", new Object[]{obj.getObjectType()});
                }
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                pm.makePersistent((Object)obj);
            }
            catch (JDOUserException e) {
                Object[] args = new Object[]{obj};
                CAFPublicLogger.traceThrowableT(100, location, method, "JDOUserException in JDO createPersistent of {0}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            catch (Exception e) {
                Object[] args = new Object[]{obj.getKey()};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO createPersistent using key {0}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var7_4 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return obj.getKey();
    }

    public void destroy(Object obj) {
    }

    public Object findByPrimaryKey(Object objId, Class objectClass) throws DataAccessException {
        String method = "findByPrimaryKey(Object,Class)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objId, objectClass}, 1);
        Object keyObj = new Object();
        PersistenceManager pm = null;
        try {
            try {
                pm = pmf.getPersistenceManager();
                SAPJDOHelper.registerPCClass((Class)objectClass);
                keyObj = pm.getObjectById(objId, true);
            }
            catch (JDODataStoreException e) {
                Object[] args = new Object[]{objId, objectClass};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectId {0}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var9_6 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return keyObj;
    }

    public Collection query(Class objectClass, String operationName) throws DataAccessException {
        String method = "query(Class)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectClass}, 1);
        Collection resultSet = null;
        PersistenceManager pm = null;
        try {
            try {
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                Extent ext = pm.getExtent(objectClass, true);
                Iterator iter = ext.iterator();
                Query query = null;
                query = pm.newQuery(ext);
                resultSet = (Collection)query.execute();
                location.debugT("Size of result set retrieved is: {0}", new Object[]{Integer.toString(resultSet.toArray().length)});
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectClass};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectClass {0}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var10_11 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return resultSet;
    }

    public Collection query(Class objectClass, String filter, String param, Map hm, String operationName) throws DataAccessException {
        String method = "query(Class,String,String,Map)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectClass, filter, param, hm}, 1);
        Collection resultSet = null;
        PersistenceManager pm = null;
        try {
            try {
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                Extent ext = pm.getExtent(objectClass, true);
                Query query = null;
                query = pm.newQuery(ext, filter);
                query.declareParameters(param);
                resultSet = (Collection)query.executeWithMap(hm);
                location.debugT("Size of result set retrieved is: {0}", new Object[]{Integer.toString(resultSet.toArray().length)});
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectClass, filter, param, hm};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectClass {0} using filter {1}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var12_13 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return resultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection query(Class objectClass, IntQueryFilter intFilter, String operationName) throws DataAccessException {
        String method = "query(Class,IntQueryFilter)";
        String filter = null;
        Collection resultSet = null;
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objectClass, intFilter.attribute, intFilter.condition, intFilter.getAttributeValue().toString(), intFilter.getAttributeValueHigh().toString()}, 1);
        if (intFilter == null) {
            throw new DataAccessException(new NullPointerException("query filter is null"));
        }
        if (intFilter.isDate) {
            IntQueryFilter[] intDateFilter = new IntQueryFilter[]{intFilter};
            return this.query(objectClass, intDateFilter, operationName);
        }
        PersistenceManager pm = null;
        try {
            try {
                filter = intFilter.getJdoFilter();
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                Extent ext = pm.getExtent(objectClass, true);
                Query query = null;
                query = pm.newQuery(ext, filter);
                String jdoVariables = intFilter.getJdoCollVariables();
                if (jdoVariables != null) {
                    query.declareVariables(jdoVariables);
                }
                resultSet = (Collection)query.execute();
                location.debugT("Size of result set retrieved is: {0} using attribute : {1} condition : {2} value low : {3} value high {4}", new Object[]{Integer.toString(resultSet.toArray().length), intFilter.attribute, intFilter.condition, intFilter.getAttributeValue().toString(), intFilter.getAttributeValueHigh().toString()});
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectClass, intFilter.attribute, intFilter.condition, intFilter.getAttributeValue().toString(), intFilter.getAttributeValueHigh().toString()};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectClass {0} using attribute : {1} condition : {2} value low : {3} value high {4} ", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var12_14 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return resultSet;
    }

    public Collection query(Class objectClass, IntQueryFilter[] intFilter, String operationName) throws DataAccessException {
        String method = "query(Class,IntQueryFilter[])";
        String filter = null;
        String typeString = null;
        String paramString = null;
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        HashSet<String> declaredVariables = null;
        Collection resultSet = null;
        PersistenceManager pm = null;
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, 1);
        try {
            try {
                for (int i = 0; i < intFilter.length; ++i) {
                    if (intFilter[i] == null || intFilter[i].isEmpty()) continue;
                    filter = IntQueryFilter.joinFilterMap(filter, intFilter[i], null);
                    String jdoVariables = intFilter[i].getJdoCollVariables();
                    if (jdoVariables != null) {
                        if (declaredVariables == null) {
                            declaredVariables = new HashSet<String>();
                        }
                        declaredVariables.add(jdoVariables);
                    }
                    String attrName1 = intFilter[i].getAttributeName1();
                    String attrName2 = intFilter[i].getAttributeName2();
                    if (!queryParameters.containsKey(attrName1)) {
                        queryParameters.put(attrName1, intFilter[i].getAttributeValue());
                    }
                    if (!"<>".equals(intFilter[i].condition)) continue;
                    queryParameters.put(attrName2, intFilter[i].getAttributeValueHigh());
                }
                Iterator iter = queryParameters.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry param = iter.next();
                    Object value = param.getValue();
                    String type = value != null ? value.getClass().getName() : "java.lang.String";
                    String parameter = param.getKey().toString();
                    paramString = paramString != null ? paramString + ", " + type + " " + parameter : type + " " + parameter;
                    if (typeString != null) {
                        typeString = typeString + "; import " + type;
                        continue;
                    }
                    typeString = "import " + type;
                }
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                Extent ext = pm.getExtent(objectClass, true);
                Query query = null;
                query = pm.newQuery(ext, filter == null ? "" : filter);
                if (typeString != null) {
                    query.declareImports(typeString);
                }
                if (paramString != null) {
                    query.declareParameters(paramString);
                }
                if (declaredVariables != null) {
                    StringBuffer sb = new StringBuffer();
                    Iterator i = declaredVariables.iterator();
                    while (i.hasNext()) {
                        if (sb.length() > 0) {
                            sb.append(';');
                        }
                        sb.append(i.next());
                    }
                    query.declareVariables(sb.toString());
                }
                resultSet = queryParameters == null || queryParameters.isEmpty() ? (Collection)query.execute() : (Collection)query.executeWithMap(queryParameters);
                location.debugT("Size of result set retrieved is: {0} using queryParameters : {1} declaredVariables : {2} paramString : {3} typeString : {4} ", new Object[]{Integer.toString(resultSet.toArray().length), queryParameters, declaredVariables, paramString, typeString});
            }
            catch (BaseRuntimeException e) {
                Object[] args = new Object[]{objectClass, e.getLocalizedMessage()};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectClass {0} as : {1} ", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            catch (Exception e) {
                Object[] args = new Object[]{objectClass, queryParameters, declaredVariables, paramString, typeString};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO getPersistent of ObjectClass {0} using queryParameters : {1} declaredVariables : {2} paramString : {3} typeString : {4} ", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var18_22 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return resultSet;
    }

    public Collection query(String usage, Class objectClass, IntQueryFilter[] filter, String operationName) throws DataAccessException {
        return this.query(objectClass, filter, operationName);
    }

    public Object load(Object objId, Class objClass) throws DataAccessException {
        String method = "load(Object,Class)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{objId, objClass}, 1);
        Object keyObj = new Object();
        PersistenceManager pm = null;
        try {
            try {
                pm = pmf.getPersistenceManager();
                if (this.userContext != null) {
                    pm.setUserObject((Object)this.userContext);
                }
                SAPJDOHelper.registerPCClass((Class)objClass);
                keyObj = pm.getObjectById(objId, true);
            }
            catch (Exception e) {
                Object[] args = new Object[]{objId, objClass};
                CAFPublicLogger.traceThrowableT(100, location, method, "Error in JDO load of ObjectClass {0} using filter {1}", args, e);
                location.throwing(method, (Throwable)e);
                throw new DataAccessException(e);
            }
            Object var9_6 = null;
            this.close(pm);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.close(pm);
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
            throw throwable;
        }
        CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        return keyObj;
    }

    public void store(IDependentObject obj) throws DataAccessException {
        if (CAFContext.CAF_BW_INTEGRATION_ENABLED) {
            try {
                if (BWProcessorLocalFactory.getProcessorLocalInstance().checkIsCAFServiceLogicallyLocked(obj.getObjectType())) {
                    throw new DataAccessException("BO_LOCKED_BY_CAF_BW_INTEGRATION", new Object[]{obj.getObjectType()});
                }
            }
            catch (Exception exc) {
                throw new DataAccessException(exc);
            }
        }
    }

    public void activate() {
    }

    public void passivate() throws DataAccessException {
    }

    public void close(PersistenceManager pm) throws DataAccessException {
        String method = "close(PersistenceManager)";
        CAFPublicLogger.entering(null, JARM_REQUEST, method, location, new Object[]{pm}, 1);
        try {
            if (pm != null) {
                pm.close();
                pm = null;
            }
        }
        catch (Exception e) {
            Object[] args = new Object[]{pm};
            CAFPublicLogger.traceThrowableT(100, location, method, "Error in close of JDO PersistenceManager {0}", args, e);
            location.throwing(method, (Throwable)e);
            throw new DataAccessException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, JARM_REQUEST, method, location, 1);
        }
    }

    public Object execute(String action, Class objClass, Object input, Object result) throws DataAccessException {
        throw new DataAccessException("Operation not Supported");
    }

    public void setUserContext(UserContext userCtx) {
        this.userContext = userCtx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

