/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertErrInfo;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.i18n.cp.ConverterRuntimeException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;

public abstract class ConvertBase {
    private static final Location m_oLoc = Location.getLocation((String)"com.sap.i18n.cp.ConvertBase");
    private static final Category m_oLog = Category.getCategory((String)"/System/Server");
    private static boolean m_bConverterJNILoadTried;
    private static ExceptionInInitializerError m_eConverterJNILoadException;
    private static ConverterRuntimeException m_eConverterJNILoadExceptionCause;
    public static char[] m_acUcCp;
    protected boolean m_bCnvObjInit;
    protected byte[] m_aCnvObj;
    protected ConvertErrInfo m_oCnvLastErr;

    public static String GetJavaVersion() {
        ConvertBase.CheckConverterJNIAvailable();
        return new String("1.0.0");
    }

    public static String GetNativeVersion() {
        ConvertBase.CheckConverterJNIAvailable();
        return ConverterJNI.GetVersion();
    }

    public static void CheckConverterJNIAvailable() {
        if (m_bConverterJNILoadTried) {
            if (m_eConverterJNILoadException == null) {
                return;
            }
            if (m_eConverterJNILoadExceptionCause != null) {
                throw m_eConverterJNILoadExceptionCause;
            }
            throw m_eConverterJNILoadException;
        }
        m_bConverterJNILoadTried = true;
        try {
            ConverterJNI.DummyToTriggerLoad();
        }
        catch (ExceptionInInitializerError e) {
            System.out.println(">>>>> Now we trow the error message: ");
            m_eConverterJNILoadException = e;
            throw m_eConverterJNILoadException;
        }
    }

    public ConvertBase(char[] sInCp, char[] sOutCp, boolean bIgnoreErr) {
        ConvertBase.CheckConverterJNIAvailable();
        int[] aRet = new int[]{0, 0};
        this.m_aCnvObj = ConverterJNI.ConvertInit(sInCp, sOutCp, bIgnoreErr, aRet);
        if (aRet[0] != 0) {
            this.m_bCnvObjInit = false;
            this.m_oCnvLastErr = new ConvertErrInfo(aRet[0], 0, new String());
            m_oLog.errorT(m_oLoc, "ConvertBase()", this.m_oCnvLastErr.m_sRscpInfo, new Object[]{this});
        } else {
            this.m_bCnvObjInit = true;
        }
    }

    public ConvertBase() {
        ConvertBase.CheckConverterJNIAvailable();
        this.m_bCnvObjInit = false;
        this.m_oCnvLastErr = null;
    }

    public void finalize() {
        if (this.m_bCnvObjInit) {
            ConverterJNI.ConvertFinish(this.m_aCnvObj);
        }
    }

    public ConvertErrInfo GetLastError() {
        return this.m_oCnvLastErr;
    }

    public int GetLastRet() {
        return this.m_oCnvLastErr == null ? 0 : this.m_oCnvLastErr.m_nRet;
    }

    public boolean InitOk() {
        return this.m_bCnvObjInit;
    }

    static {
        m_oLog.addLog((Log)new ConsoleLog());
        m_oLog.setEffectiveSeverity(500);
        m_bConverterJNILoadTried = false;
        m_eConverterJNILoadException = null;
        m_eConverterJNILoadExceptionCause = null;
        m_acUcCp = new char[]{'0', '0', '0', '0'};
    }
}

