/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.util;

import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.security.util.CAFPermissionOperator;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.text.DateFormat;
import java.util.Date;

public class CAFBusinessConditionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$util$CAFBusinessConditionBean == null ? (class$com$sap$caf$rt$security$util$CAFBusinessConditionBean = CAFBusinessConditionBean.class$("com.sap.caf.rt.security.util.CAFBusinessConditionBean")) : class$com$sap$caf$rt$security$util$CAFBusinessConditionBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance();
    private String m_conditionID;
    private String m_attributeName;
    private String m_operator;
    private int m_attributeIndex;
    private Integer m_intLowValue;
    private Date m_dateLowValue;
    private String m_strLowValue;
    private Integer m_intHighValue;
    private Date m_dateHighValue;
    private String m_strHighValue;
    private boolean equal = false;
    private boolean between = false;
    private boolean greaterThan = false;
    private boolean greaterEqual = false;
    private boolean lessThan = false;
    private boolean lessEqual = false;
    private boolean notEqual = false;
    static /* synthetic */ Class class$com$sap$caf$rt$security$util$CAFBusinessConditionBean;

    public CAFBusinessConditionBean(String conditionID, String attrName, String lowValue, String highValue, String operator, int attributeIndex) throws CAFPermissionException {
        String message;
        String method = "CAFBusinessConditionBean(String, String, String, String, String, int)";
        this.m_conditionID = conditionID;
        this.m_attributeName = attrName;
        this.m_strLowValue = lowValue;
        this.m_strHighValue = highValue;
        this.m_attributeIndex = attributeIndex;
        try {
            this.m_intLowValue = Integer.valueOf(lowValue);
            this.m_intHighValue = Integer.valueOf(highValue);
        }
        catch (Exception e) {
            message = "Condition " + this.getConditionId() + " " + "can't be considered for Integer values :" + e.getMessage();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)message, (Throwable)e);
        }
        try {
            this.m_dateLowValue = DATE_FORMAT.parse(lowValue);
            this.m_dateHighValue = DATE_FORMAT.parse(highValue);
        }
        catch (Exception e) {
            message = "Condition " + this.getConditionId() + " " + "can't be considered for Date values :" + e.getMessage();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)method, (String)message, (Throwable)e);
        }
        this.m_operator = operator;
        if (this.m_operator.startsWith(CAFPermissionOperator.BT)) {
            this.between = true;
        } else if (this.m_operator.startsWith(CAFPermissionOperator.EQ)) {
            this.equal = true;
        } else if (this.m_operator.startsWith(CAFPermissionOperator.GT)) {
            this.greaterThan = true;
        } else if (this.m_operator.startsWith(CAFPermissionOperator.GE)) {
            this.greaterEqual = true;
        } else if (this.m_operator.startsWith(CAFPermissionOperator.LT)) {
            this.lessThan = true;
        } else if (this.m_operator.startsWith(CAFPermissionOperator.LE)) {
            this.lessEqual = true;
        } else {
            throw new CAFPermissionException("AUTH_CONDITION_OPERATOR", new Object[]{this.m_operator, conditionID});
        }
    }

    public String getConditionId() {
        return this.m_conditionID;
    }

    public String getattributeName() {
        return this.m_attributeName;
    }

    public String getLowValue() {
        return this.m_strLowValue;
    }

    public String getHighValue() {
        return this.m_strHighValue;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public boolean isBetween() {
        return this.between;
    }

    public boolean isEqual() {
        return this.equal;
    }

    public boolean isGreaterThan() {
        return this.greaterThan;
    }

    public boolean isGreaterEqual() {
        return this.greaterEqual;
    }

    public boolean isLessThan() {
        return this.lessThan;
    }

    public boolean isLessEqual() {
        return this.lessEqual;
    }

    public boolean isNotEqual() {
        return this.notEqual;
    }

    public int getAttributeIndex() {
        return this.m_attributeIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean valueFulfillCondition(Object value) throws CAFPermissionException {
        void var2_2;
        Object highValue;
        Object lowValue;
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            lowValue = this.m_strLowValue;
            highValue = this.m_strHighValue;
        } else if (value instanceof Integer) {
            lowValue = this.m_intLowValue;
            highValue = this.m_intHighValue;
        } else if (value instanceof Date) {
            lowValue = this.m_dateLowValue;
            highValue = this.m_dateHighValue;
        } else {
            throw new CAFPermissionException("AUTH_CONDITION_DATATYPE", new Object[]{value.getClass().getName(), this.getattributeName()});
        }
        if (this.isEqual()) {
            return var2_2.equals(value);
        }
        if (this.isNotEqual()) {
            return !var2_2.equals(value);
        }
        if (this.isBetween()) {
            void var3_3;
            return var2_2.compareTo(value) <= 0 && var3_3.compareTo(value) >= 0;
        }
        if (this.isGreaterThan()) {
            return var2_2.compareTo(value) < 0;
        }
        if (this.isGreaterEqual()) {
            return var2_2.compareTo(value) <= 0;
        }
        if (this.isLessThan()) {
            return var2_2.compareTo(value) > 0;
        }
        if (this.isLessEqual()) {
            return var2_2.compareTo(value) >= 0;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

