/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.objectvalue;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.objectvalue.ObjectValueVo;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ejb.SessionBean;

public class ObjectValueBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$objectvalue$ObjectValueBean == null ? (class$com$sap$caf$rt$security$acl$impl$objectvalue$ObjectValueBean = ObjectValueBean.class$("com.sap.caf.rt.security.acl.impl.objectvalue.ObjectValueBean")) : class$com$sap$caf$rt$security$acl$impl$objectvalue$ObjectValueBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$objectvalue$ObjectValueBean;

    public Collection findByObjectID(String objectID, String objectTypeID) throws ServiceException {
        String method = "findByObjectID(String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectID(String, String)", (Location)LOGGER, (int)1);
        Collection result = null;
        try {
            IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID);
            result = this.getObjectValues(object, objectTypeID);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectID(String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectID(String, String)", (Location)LOGGER, (int)1);
        }
        return result;
    }

    public ObjectValueVo findByPrimaryKey(String objectValueID) throws ServiceException {
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        ObjectValueVo objectValueVo = null;
        try {
            StringTokenizer st = new StringTokenizer(objectValueID, ":");
            String objectID = st.nextToken();
            String objectType = st.nextToken();
            String attributeName = st.nextToken();
            IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectType);
            Object attributeValue = object.getProperty(attributeName);
            objectValueVo = new ObjectValueVo();
            objectValueVo.setKey(objectValueID);
            objectValueVo.setObjectID(objectID);
            objectValueVo.setObjectTypeID(objectType);
            objectValueVo.setAttributeName(attributeName);
            objectValueVo.setAttributeValue(attributeValue == null ? null : attributeValue.toString());
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return objectValueVo;
    }

    private Collection getObjectValues(IDependentObject object, String objectType) throws ServiceException {
        String method = "getObjectValues(IDependentObject, String)";
        ArrayList<ObjectValueVo> result = new ArrayList<ObjectValueVo>();
        try {
            DataObject dataObject = CAFPermissionUtil.getDataObject(objectType);
            Iterator iter = dataObject.getAttributes().iterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                String attributeName = attribute.getObjectName();
                Object attributeValue = object.getProperty(attributeName);
                String objectID = object.getKey();
                String objectValueID = objectID + ":" + objectType + ":" + attributeName;
                ObjectValueVo objectValueVo = new ObjectValueVo();
                objectValueVo.setKey(objectValueID);
                objectValueVo.setObjectID(objectID);
                objectValueVo.setObjectTypeID(objectType);
                objectValueVo.setAttributeName(attributeName);
                objectValueVo.setAttributeValue(attributeValue == null ? null : attributeValue.toString());
                result.add(objectValueVo);
            }
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectValues(IDependentObject, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

