/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.objecttype;

import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.metamodel.RepositoryConnection;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeVo;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.ip.mmr.IConnection;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.SessionBean;

public class ObjectTypeBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$objecttype$ObjectTypeBean == null ? (class$com$sap$caf$rt$security$acl$impl$objecttype$ObjectTypeBean = ObjectTypeBean.class$("com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeBean")) : class$com$sap$caf$rt$security$acl$impl$objecttype$ObjectTypeBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$objecttype$ObjectTypeBean;

    public Collection findByAllObjectTypes() throws ServiceException {
        String method = "findByAllObjectType()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByAllObjectType()", (Location)LOGGER, (int)1);
        Collection resultSet = null;
        try {
            resultSet = this.getObjectTypeVos();
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByAllObjectType()", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByAllObjectType()", (Location)LOGGER, (int)1);
        }
        return resultSet;
    }

    public ObjectTypeVo findByObjectType(String objectType) throws ServiceException {
        String method = "findByObjectType(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectType(String)", (Location)LOGGER, (int)1);
        ObjectTypeVo objectTypeVo = null;
        try {
            DataObject dataObject = CAFPermissionUtil.getDataObject(objectType);
            String objectTypeID = dataObject.getObjectId();
            objectTypeVo = new ObjectTypeVo(objectTypeID, objectType);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectType(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectType(String)", (Location)LOGGER, (int)1);
        }
        return objectTypeVo;
    }

    public ObjectTypeVo findByPrimaryKey(String objectTypeID) throws ServiceException {
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        ObjectTypeVo objectTypeVo = null;
        try {
            String applicationName;
            String providerName;
            DataObject dataObject = CAFPermissionUtil.getDataObjectByGUID(objectTypeID);
            BusinessEntityInterface businessEntityInterface = dataObject.getBusinessEntityInterface();
            Application app = businessEntityInterface.getApplication();
            if (app != null) {
                providerName = app.getProviderName();
                applicationName = app.getObjectName();
            } else {
                providerName = "provider";
                applicationName = "application";
            }
            String objectType = providerName + "/" + applicationName + "/" + dataObject.getObjectName();
            objectTypeVo = new ObjectTypeVo(objectTypeID, objectType);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return objectTypeVo;
    }

    private Collection getObjectTypeVos() throws ServiceException {
        String method = "getObjectTypeVos()";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"getObjectTypeVos()", (Location)LOGGER, (int)1);
        ArrayList<ObjectTypeVo> result = new ArrayList<ObjectTypeVo>();
        try {
            List allInterfaces = this.getAllInterfaces();
            Iterator it = allInterfaces.iterator();
            while (it.hasNext()) {
                String applicationName;
                String providerName;
                MOFInterface mofInterface = (MOFInterface)it.next();
                if (!this.isBusinessEntityInterfaceSecured(mofInterface)) continue;
                ObjectTypeVo objectTypeVo = new ObjectTypeVo();
                BusinessEntityInterface beInterface = (BusinessEntityInterface)mofInterface;
                DataObject dataObject = beInterface.getBusinessEntity();
                String objectId = dataObject.getObjectId();
                BusinessEntityInterface businessEntityInterface = dataObject.getBusinessEntityInterface();
                Application app = businessEntityInterface.getApplication();
                if (app != null) {
                    providerName = app.getProviderName();
                    applicationName = app.getObjectName();
                } else {
                    providerName = "provider";
                    applicationName = "application";
                }
                String objectTypeFullName = providerName + "/" + applicationName + "/" + dataObject.getObjectName();
                objectTypeVo.setKey(objectId);
                objectTypeVo.setObjectType(objectTypeFullName);
                result.add(objectTypeVo);
            }
            ArrayList<ObjectTypeVo> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"getObjectTypeVos()", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"getObjectTypeVos()", (Location)LOGGER, (int)1);
        }
    }

    private List getAllInterfaces() throws ServiceException {
        ArrayList allInterfaces = new ArrayList();
        try {
            IConnection connection = RepositoryConnection.getConnection();
            List applications = null;
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add("com");
            typeList.add("sap");
            typeList.add("caf");
            typeList.add("metamodel");
            typeList.add("Application");
            applications = connection.queryM1(typeList, null, true);
            Iterator it = applications.iterator();
            while (it.hasNext()) {
                Application application = (Application)it.next();
                Iterator iter = application.getBaseObjects().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof BusinessEntityInterface) && !(obj instanceof ApplicationInterface)) continue;
                    allInterfaces.add(obj);
                }
            }
            return allInterfaces;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    private boolean isBusinessEntityInterfaceSecured(MOFInterface mofInterface) throws ServiceException {
        try {
            boolean result = false;
            if (mofInterface instanceof BusinessEntityInterface) {
                BusinessEntityInterface businessEntityInterface = (BusinessEntityInterface)mofInterface;
                if (businessEntityInterface.getInstancePermission() != null && businessEntityInterface.getInstancePermission() > 0) {
                    result = true;
                } else {
                    List operationMappings = businessEntityInterface.getOperations();
                    Iterator iter = operationMappings.iterator();
                    while (iter.hasNext()) {
                        Operation operation = (Operation)iter.next();
                        Permission permission = operation.getPermission();
                        if (permission == null || permission.getImplicitCheck() == null || permission.getImplicitCheck() <= 0) continue;
                        result = true;
                        break;
                    }
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

