/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.condition;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.condition.ConditionVo;
import com.sap.caf.rt.security.util.CAFPermissionCache;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.SessionBean;

public class ConditionBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$condition$ConditionBean == null ? (class$com$sap$caf$rt$security$acl$impl$condition$ConditionBean = ConditionBean.class$("com.sap.caf.rt.security.acl.impl.condition.ConditionBean")) : class$com$sap$caf$rt$security$acl$impl$condition$ConditionBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$condition$ConditionBean;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String conditionID, String attributeName, String attributeValue) throws ServiceException {
        this.checkUpdatePermission();
        String method = "update(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"update(String, String, String)", (Location)LOGGER, (int)1);
        try {
            try {
                ConditionVo conditionVo = this.findByPrimaryKey(conditionID);
                conditionVo.setAttributeName(attributeName);
                conditionVo.setAttributeValue(attributeValue);
                this.getJDODataAccessService().store((IDependentObject)conditionVo);
            }
            catch (Exception e) {
                this.getSessionContext().setRollbackOnly();
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
                CAFPermissionCache.invalidPermissionCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"update(String, String, String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"update(String, String, String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPermissionCache.invalidPermissionCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"update(String, String, String)", (Location)LOGGER, (int)1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String create(String businessRuleID) throws ServiceException {
        String e2;
        String conditionID = null;
        String method = "create(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"create(String)", (Location)LOGGER, (int)1);
        ConditionVo conditionVo = null;
        this.checkUpdatePermission();
        if (businessRuleID == null) {
            ServiceException ruleException = new ServiceException("AUTH_CREATE_CONDITION");
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String)", (String)ruleException.getMessage(), (Throwable)ruleException);
            throw ruleException;
        }
        try {
            try {
                conditionVo = new ConditionVo();
                conditionVo.setBusinessRuleID(businessRuleID);
                try {
                    conditionID = PrimaryKeyFactory.getInstance().getPrimaryKey();
                }
                catch (DataAccessException e2) {
                    CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String)", (String)e2.getMessage(), (Throwable)e2);
                    throw new ServiceException((Throwable)e2);
                }
                conditionVo.setKey(conditionID);
                this.getJDODataAccessService().create((IDependentObject)conditionVo);
                e2 = conditionID;
                Object var7_9 = null;
            }
            catch (Exception e2) {
                this.getSessionContext().setRollbackOnly();
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String)", (String)e2.getMessage(), (Throwable)e2);
                throw new ServiceException((Throwable)e2);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"create(String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"create(String)", (Location)LOGGER, (int)1);
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String conditionID) throws ServiceException {
        this.checkUpdatePermission();
        String method = "delete(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
        if (conditionID == null) {
            ServiceException ruleException = new ServiceException("AUTH_DELETE_CONDITION");
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)ruleException.getMessage(), (Throwable)ruleException);
            throw ruleException;
        }
        ConditionVo conditionVo = null;
        try {
            try {
                conditionVo = this.findByPrimaryKey(conditionID);
                this.getJDODataAccessService().remove((IDependentObject)conditionVo);
            }
            catch (Exception e) {
                this.getSessionContext().setRollbackOnly();
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)e.getMessage(), (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                CAFPermissionCache.invalidRuleCache();
            }
            catch (Exception pex) {
                CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)pex.getMessage(), (Throwable)pex);
                throw new ServiceException("AUTH_RESET_CACHE");
            }
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
            throw throwable;
        }
        try {}
        catch (Exception pex) {
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"delete(String)", (String)pex.getMessage(), (Throwable)pex);
            throw new ServiceException("AUTH_RESET_CACHE");
        }
        CAFPermissionCache.invalidRuleCache();
        CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"delete(String)", (Location)LOGGER, (int)1);
    }

    public ConditionVo findByPrimaryKey(String conditionID) throws ServiceException {
        ConditionVo conditionVo = null;
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        try {
            String param = "String key";
            String filter = "this.key == key";
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("key", conditionID);
            Collection resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo == null ? (class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo = ConditionBean.class$("com.sap.caf.rt.security.acl.impl.condition.ConditionVo")) : class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo, filter, param, hm, null);
            conditionVo = (ConditionVo)resultSet.iterator().next();
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return conditionVo;
    }

    public Collection findByBusinessRule(String businessRuleID) throws ServiceException {
        String method = "findByBusinessRule(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByBusinessRule(String)", (Location)LOGGER, (int)1);
        String param = "String businessRuleID";
        String filter = "this.businessRuleID == businessRuleID";
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("businessRuleID", businessRuleID);
        try {
            Collection resultSet;
            Collection collection = resultSet = this.getJDODataAccessService().query(class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo == null ? (class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo = ConditionBean.class$("com.sap.caf.rt.security.acl.impl.condition.ConditionVo")) : class$com$sap$caf$rt$security$acl$impl$condition$ConditionVo, filter, param, hm, null);
            return collection;
        }
        catch (DataAccessException dae) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByBusinessRule(String)", (String)dae.getMessage(), (Throwable)dae);
            throw new ServiceException((Throwable)dae);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByBusinessRule(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByBusinessRule(String)", (Location)LOGGER, (int)1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

