/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.security.acl.impl.businessentity;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.acl.impl.businessentity.BusinessEntityVo;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import java.util.StringTokenizer;
import javax.ejb.SessionBean;

public class BusinessEntityBean
extends SecurityServiceBase
implements SessionBean {
    private static final String APPLICATION = (class$com$sap$caf$rt$security$acl$impl$businessentity$BusinessEntityBean == null ? (class$com$sap$caf$rt$security$acl$impl$businessentity$BusinessEntityBean = BusinessEntityBean.class$("com.sap.caf.rt.security.acl.impl.businessentity.BusinessEntityBean")) : class$com$sap$caf$rt$security$acl$impl$businessentity$BusinessEntityBean).getName();
    private static final Location LOGGER = Location.getLocation((String)APPLICATION);
    private static final String JARMREQPREFIX = "CAF:RT:security:";
    private static final String JARMREQUEST = "CAF:RT:security:" + APPLICATION;
    static /* synthetic */ Class class$com$sap$caf$rt$security$acl$impl$businessentity$BusinessEntityBean;

    public BusinessEntityVo findByPrimaryKey(String businessObjectID) throws ServiceException {
        String method = "findByPrimaryKey(String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        BusinessEntityVo businessEntityVo = null;
        try {
            StringTokenizer st = new StringTokenizer(businessObjectID, ":");
            String objectID = st.nextToken();
            String objectTypeID = st.nextToken();
            String titleAttribute = st.nextToken();
            IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID);
            Object attributeValue = object.getProperty(titleAttribute);
            businessEntityVo = new BusinessEntityVo();
            businessEntityVo.setKey(businessObjectID);
            businessEntityVo.setObjectID(objectID);
            businessEntityVo.setObjectTypeID(objectTypeID);
            businessEntityVo.setTitle(attributeValue == null ? null : attributeValue.toString());
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByPrimaryKey(String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByPrimaryKey(String)", (Location)LOGGER, (int)1);
        }
        return businessEntityVo;
    }

    public BusinessEntityVo findByObjectID(String objectID, String objectTypeID, String titleAttribute) throws ServiceException {
        String method = "findByObjectID(String, String, String)";
        CAFPublicLogger.entering(null, (String)JARMREQUEST, (String)"findByObjectID(String, String, String)", (Location)LOGGER, (int)1);
        BusinessEntityVo businessEntityVo = null;
        try {
            IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID);
            Object attributeValue = object.getProperty(titleAttribute);
            String businessObjectID = objectID + ":" + objectTypeID + ":" + titleAttribute;
            businessEntityVo = new BusinessEntityVo();
            businessEntityVo.setKey(businessObjectID);
            businessEntityVo.setObjectID(objectID);
            businessEntityVo.setObjectTypeID(objectTypeID);
            businessEntityVo.setTitle(attributeValue == null ? null : attributeValue.toString());
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            CAFPublicLogger.traceThrowableT((int)500, (Location)LOGGER, (String)"findByObjectID(String, String, String)", (String)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)JARMREQUEST, (String)"findByObjectID(String, String, String)", (Location)LOGGER, (int)1);
        }
        return businessEntityVo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

