/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor.paste;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.services.ServicesUI;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.refac.RefactoringServices;
import com.sap.ide.webdynpro.ui.dialog.WDCopyDialog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyApplicationDialog
extends WDCopyDialog {
    private static final CoreTextPool mCPool = CoreTextPool.getInstance();
    private static final TextPool mTPool = TextPool.getInstance();
    private static final String APPLICATION = mCPool.getText(126);
    private static final String COPY_COMPONENT = mCPool.getText(155, (Object)APPLICATION);
    private Metamodel mMetamodel = null;
    private String mApplicationtName = null;
    private String mApplicationPackage = null;
    private IPackageFragmentRoot mPreselectedRoot = null;
    private boolean mEnableSourceFolderList = true;
    private ClipboardObject[] mClipboardObjects = null;
    private boolean mDeleteNameMessage = true;
    private boolean mDeletePackageMessage = true;

    public CopyApplicationDialog(IPackageFragmentRoot[] allValidRoots, IPackageFragmentRoot preselectedRoot, Metamodel metamodel, String applicationName, String applicationPackage, ClipboardObject[] clipboardObjects, boolean enableSourceFolderList) {
        super(allValidRoots, COPY_COMPONENT, "");
        this.mPreselectedRoot = preselectedRoot;
        this.mMetamodel = metamodel;
        this.mApplicationtName = applicationName;
        this.mApplicationPackage = applicationPackage;
        this.mClipboardObjects = clipboardObjects;
        this.mEnableSourceFolderList = enableSourceFolderList;
    }

    protected void initializeListeners() {
        this.getNameField().addModifyListener((ModifyListener)new ApplicationNameModifyListener());
        this.getPackageField().addModifyListener((ModifyListener)new ApplicationPackageModifyListener());
        this.getBrowsePackageButton().addSelectionListener((SelectionListener)new BrowseApplicationPackageButtonListener());
        this.getSourcePathListField().addSelectionListener((SelectionListener)new ApplicationSourceSelectionListener());
    }

    protected void initializeFields() {
        if (this.mApplicationtName != null) {
            String oldName = this.mApplicationtName;
            String searchName = this.mApplicationtName;
            int nr = 0;
            while (this.mMetamodel.objectExists(this.mApplicationPackage, searchName, (MDOEnum)WebDynproMDOEnum.APPLICATION)) {
                String number = "_" + nr++;
                if (nr == 1) {
                    number = "";
                }
                searchName = "Copy" + number + "_of_" + oldName;
                this.setMessage(mCPool.getText(310));
            }
            this.getNameField().setText(searchName);
            this.getNameField().setSelection(0, searchName.length() + 8);
            this.setName(this.getNameField().getText());
        }
        if (this.mApplicationPackage != null) {
            this.getPackageField().setText(this.mApplicationPackage);
            this.setPackage(this.mApplicationPackage);
        }
        IPackageFragmentRoot preselectedSourceFolder = this.mPreselectedRoot;
        int preselectionIndex = 0;
        IPackageFragmentRoot[] roots = this.getAllValidRoots();
        if (roots == null || roots.length <= 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            if (preselectedSourceFolder != null && roots[i].equals(preselectedSourceFolder)) {
                preselectionIndex = i;
            }
            ++i;
        }
        this.getSourcePathListField().setSelection(preselectionIndex);
        this.setSourceRoot(roots[preselectionIndex]);
        this.getSourcePathListField().setEnabled(this.mEnableSourceFolderList);
    }

    public void handlePageCompletion() {
        if (this.mDeleteNameMessage && this.mDeletePackageMessage) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(true);
        this.setName(this.getNameField().getText());
        this.setPackage(this.getPackageField().getText());
    }

    private boolean isValidNameField() {
        this.mDeleteNameMessage = true;
        String nameInput = this.getNameField().getText();
        String packageInput = this.getPackageField().getText();
        nameInput = CheckServices.checkFirstCharacter((Text)this.getNameField());
        IStatus applicationStatus = ApplicationService.isNewApplicationNameValid(nameInput, packageInput, 0);
        if (applicationStatus.getSeverity() == 2) {
            this.setMessage(applicationStatus.getMessage(), 2);
            this.mDeleteNameMessage = false;
        } else if (applicationStatus.getSeverity() == 4) {
            this.setErrorMessage(applicationStatus.getMessage());
            return false;
        }
        boolean applicationExists = this.mMetamodel.objectExists(packageInput, nameInput, (MDOEnum)WebDynproMDOEnum.APPLICATION);
        if (applicationExists) {
            this.setErrorMessage(mTPool.getText(2, nameInput));
            return false;
        }
        boolean existsInClip = RefactoringServices.nameExistsInClipboard((String)nameInput, (String)packageInput, (DevelopmentObjectEnum)WebDynproDevelopmentObjectEnum.APPLICATION, (ClipboardObject[])this.mClipboardObjects);
        if (existsInClip) {
            this.setErrorMessage(mCPool.getText(33, (Object)nameInput, (Object)packageInput));
            return false;
        }
        return true;
    }

    private boolean isValidPackageField() {
        this.mDeletePackageMessage = true;
        String packageInput = CheckServices.convertToLowerCase((Text)this.getPackageField());
        IStatus validatedStatus = CheckServices.isValidPackage((String)packageInput);
        if (validatedStatus.getSeverity() == 2) {
            this.setMessage(validatedStatus.getMessage(), 2);
            this.mDeletePackageMessage = false;
        } else if (validatedStatus.getSeverity() == 4) {
            this.setErrorMessage(validatedStatus.getMessage());
            return false;
        }
        return true;
    }

    protected void okPressed() {
        IPath sourcePath;
        MetamodelManager manager;
        SourcePathIdentifier identifier;
        String packageInput;
        String nameInput = this.getNameField().getText();
        IStatus status = CheckServices.isValidMDOPath((Metamodel)this.mMetamodel, (MDOEnum)WebDynproMDOEnum.APPLICATION, (String)nameInput, (String)(packageInput = this.getPackageField().getText()), (SourcePathIdentifier)(identifier = (manager = MetamodelManager.getMetamodelManager((String)this.mMetamodel.getName())).getSourcePathIdentifier(sourcePath = manager.makePathAbsolute(this.getSourceRoot().getPath()))));
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
            return;
        }
        boolean applicationExists = this.mMetamodel.objectExists(this.getPackageField().getText(), this.getNameField().getText(), (MDOEnum)WebDynproMDOEnum.APPLICATION);
        if (applicationExists) {
            this.setErrorMessage(CoreTextPool.getInstance().getText(25, (Object)nameInput, (Object)packageInput));
            this.setPageComplete(false);
            return;
        }
        if (status.getSeverity() == 0 && !applicationExists) {
            super.okPressed();
        }
    }

    class BrowseApplicationPackageButtonListener
    extends SelectionAdapter {
        BrowseApplicationPackageButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)CopyApplicationDialog.this.getSourceRoot(), (Shell)CopyApplicationDialog.this.getShell());
            if (packageFragment != null) {
                CopyApplicationDialog.this.getPackageField().setText(packageFragment.getElementName());
            }
            if (CopyApplicationDialog.this.isValidPackageField() && CopyApplicationDialog.this.isValidNameField() && CopyApplicationDialog.this.getSourcePathListField().getItemCount() > 0) {
                CopyApplicationDialog.this.handlePageCompletion();
            } else {
                CopyApplicationDialog.this.setPageComplete(false);
            }
        }
    }

    class ApplicationSourceSelectionListener
    implements SelectionListener {
        ApplicationSourceSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int selectionIndex = CopyApplicationDialog.this.getSourcePathListField().getSelectionIndex();
            if (selectionIndex >= 0) {
                IPackageFragmentRoot selectedRoot = CopyApplicationDialog.this.getAllValidRoots()[selectionIndex];
                CopyApplicationDialog.this.setSourceRoot(selectedRoot);
            }
        }
    }

    class ApplicationPackageModifyListener
    implements ModifyListener {
        ApplicationPackageModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (CopyApplicationDialog.this.isValidPackageField() && CopyApplicationDialog.this.isValidNameField()) {
                CopyApplicationDialog.this.handlePageCompletion();
            } else {
                CopyApplicationDialog.this.setPageComplete(false);
            }
        }
    }

    class ApplicationNameModifyListener
    implements ModifyListener {
        ApplicationNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (CopyApplicationDialog.this.isValidNameField() && CopyApplicationDialog.this.isValidPackageField()) {
                CopyApplicationDialog.this.handlePageCompletion();
            } else {
                CopyApplicationDialog.this.setPageComplete(false);
            }
        }
    }
}

