/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor.paste;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.applicationeditor.paste.CopyApplicationDialog;
import com.sap.ide.webdynpro.service.core.paste.IPasteManager;
import com.sap.ide.webdynpro.service.core.paste.OriginalObjectNotExistingException;
import com.sap.ide.webdynpro.service.core.paste.PasteHandlerException;
import com.sap.ide.webdynpro.service.core.paste.WebDynproObjectPasteHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class ApplicationPasteHandler
extends WebDynproObjectPasteHandler {
    public MainDevelopmentObject[] getAffectedMDOs(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        return super.getAffectedMDOs(clipboardObjects, newParent, scope, pasteManager);
    }

    public boolean refactorBeforeExecution(ClipboardObject[] clipboardObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) throws PasteHandlerException {
        if (clipboardObjects == null || clipboardObjects.length != 1) {
            throw new PasteHandlerException();
        }
        ClipboardObject appObject = clipboardObjects[0];
        DevelopmentObject originalAppObject = pasteManager.getClipboard().getSourceMetamodel().getObjectFromKey(appObject.getOriginalKey());
        if (originalAppObject == null) {
            throw new OriginalObjectNotExistingException(appObject);
        }
        Application application = (Application)originalAppObject;
        String newName = null;
        String newPackage = null;
        IPackageFragmentRoot newRoot = null;
        SourcePathIdentifier identifier = pasteManager.getSourcePathIdentifier();
        IPackageFragmentRoot preselectedSourceRoot = this.getPreselectedSourceRoot(identifier, newParent);
        IPackageFragmentRoot[] allRoots = this.getSourceRootsForTarget(newParent);
        String packageSuggestion = this.getPreselectedPackage(appObject, newParent, (DevelopmentObject)application);
        ClipboardObject[] clipboardObjectHistory = pasteManager.getClipboardObjectsHistory();
        CopyApplicationDialog dialog = ServiceWithUI.displayCopyApplicationDialog(allRoots, preselectedSourceRoot, this.getNewMetamodel(newParent), appObject.getNewName(), packageSuggestion, clipboardObjectHistory, this.isSourceRootListEnabled(identifier, newParent));
        if (dialog == null) {
            return false;
        }
        newName = dialog.getName();
        newPackage = dialog.getPackage();
        newRoot = dialog.getSourceRoot();
        appObject.setNewName(newName);
        appObject.setNewPackage(newPackage);
        if (newRoot != null) {
            this.setPasteProcessSourcePathIdentifier(pasteManager, newRoot, newParent);
        }
        this.storeMapping(appObject, newName, newPackage, newRoot, pasteManager);
        this.addToClipboardObjectsHistory(clipboardObjects, pasteManager);
        return true;
    }

    public void refactorAfterExecution(DevelopmentObject[] newObjects, MetamodelObject newParent, int scope, IPasteManager pasteManager) {
        if (newObjects != null && newObjects.length == 1 && newObjects[0] instanceof Application) {
            Application app = (Application)newObjects[0];
            this.copyFolderStructure(app, pasteManager);
        }
    }

    private void copyFolderStructure(Application application, IPasteManager manager) {
        Application oldApplication = (Application)this.getOldMDO((MainDevelopmentObject)application, manager);
        PARService.copyApplicationFilesAndFolders((Application)oldApplication, (Application)application, (IProgressMonitor)manager.getSharedMonitor());
    }
}

