/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor.internal;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinitionSet;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceApplicationEditorPlugin;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ApplicationPropertyDefinitionSelection
implements ILabelProvider {
    private static final TextPool mTextPool = TextPool.getInstance();
    private DevelopmentObjectFilter mFilter = null;

    public ApplicationPropertyDefinitionSelection(DevelopmentObjectFilter filter) {
        this.mFilter = filter;
    }

    public ApplicationPropertyDefinition select(MainDevelopmentObject mdo) {
        ObjectSelectionDialog dialog = new ObjectSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mTextPool.getText(131), mTextPool.getText(132));
        dialog.setSingleSelection(true);
        dialog.setBlockOnOpen(true);
        dialog.setLabelProvider((ILabelProvider)this);
        dialog.setObjectSorter(new ViewerSorter(){});
        Object[] objects = dialog.openDialog((Object[])this.getElements(mdo.getRoot()));
        if (objects == null || objects.length < 1) {
            return null;
        }
        return (ApplicationPropertyDefinition)objects[0];
    }

    private ApplicationPropertyDefinition[] getElements(Root inputElement) {
        if (inputElement instanceof WebDynproRoot) {
            ApplicationPropertyDefinitionSet[] definitionSets = null;
            try {
                definitionSets = ((WebDynproRoot)inputElement).getApplicationPropertyDefinitionSets();
            }
            catch (LoadException e) {
                ServiceApplicationEditorPlugin.internalError(this.getClass(), "getElements(Root)", e.getMessage(), e, false);
            }
            Arrays.sort(definitionSets, new DevelopmentObjectNameComparator());
            ArrayList<ApplicationPropertyDefinition> list = new ArrayList<ApplicationPropertyDefinition>();
            int i = 0;
            while (i < definitionSets.length) {
                ApplicationPropertyDefinition[] definitions = definitionSets[i].getPropertyDefinitions();
                int j = 0;
                while (j < definitions.length) {
                    if (this.mFilter.isValidObject((DevelopmentObject)definitions[j])) {
                        list.add(definitions[j]);
                    }
                    ++j;
                }
                ++i;
            }
            return list.toArray(new ApplicationPropertyDefinition[list.size()]);
        }
        return null;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ApplicationPropertyDefinition) {
            return ((ApplicationPropertyDefinition)element).getName();
        }
        return null;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

