/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor.applicationproperty;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.ApplicationProperty;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.metamodel.webdynpro.repository.ApplicationRepositoryManager;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.util.ArrayList;

public class ApplicationPropertyService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String[] VALUES_BOOLEAN = new String[]{"true", "false"};
    public static final String PROPERTY_SET_STANDARD_NAME = "Standard";
    public static final String PROPERTY_SET_STANDARD_PACKAGE = "com.sap.ide.webdynpro.applicationpropertydefs";
    public static final String PROPERTY_AUTHENTICATION_NAME = "Authentication";

    public static String isNewNameValid(String newName, Application application) {
        if (newName == null | newName.length() == 0) {
            return mTextPool.getText(4);
        }
        if (application.hasApplicationProperty(newName)) {
            return mTextPool.getText(8, newName);
        }
        if (!CheckServices.isValidIdentifier((String)newName, (String)".")) {
            return mCoreTextPool.getText(50, (Object)newName, (Object)".");
        }
        return null;
    }

    public static String isNewValueValid(String newValue, Application application, ApplicationPropertyDefinition definition) {
        String error = null;
        if (definition != null && definition.getType().getName().equals(TYPE_BOOLEAN)) {
            error = ApplicationPropertyService.checkValueAgainstList(newValue, VALUES_BOOLEAN);
        }
        return error;
    }

    private static String checkValueAgainstList(String value, String[] validValues) {
        String error = mTextPool.getText(9, value);
        int i = 0;
        while (i < validValues.length) {
            if (validValues[i].equals(value)) {
                error = null;
                break;
            }
            ++i;
        }
        return error;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationPropertyCreation(Application application) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ApplicationRepositoryManager.getRepositioryObject((Application)application, (boolean)false));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationPropertyModification(ApplicationProperty property) {
        return ApplicationPropertyService.getRepositoryObjectsAffectedByApplicationPropertyCreation(property.getApplication());
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationPropertyDeletion(ApplicationProperty property) {
        return ApplicationPropertyService.getRepositoryObjectsAffectedByApplicationPropertyCreation(property.getApplication());
    }
}

