/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor.application;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelHelper;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.services.MMCCheckServices;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinitionSet;
import com.sap.ide.metamodel.webdynpro.repository.ApplicationRepositoryManager;
import com.sap.ide.webdynpro.archivebuilder.PARService;
import com.sap.ide.webdynpro.service.applicationeditor.ApplicationEditorInput;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceApplicationEditorPlugin;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ApplicationService {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String APPLICATION_EDITOR_ID = "com.sap.ide.webdynpro.editors.application";
    public static final String STANDARD_APPLICATION_PROPERTY_DEFINITION_SET_NAME = "Standard";
    public static final String STANDARD_APPLICATION_PROPERTY_DEFINITION_SET_PACKAGE = "com.sap.ide.webdynpro.applicationpropertydefs";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService;

    public static String isNewApplicationNameValid(String applicationName, String packageName) {
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)applicationName);
        if (!checkResult.isOk()) {
            return checkResult.getMessage();
        }
        if (Character.isLowerCase(applicationName.charAt(0))) {
            return mCoreTextPool.getText(17, (Object)applicationName);
        }
        return null;
    }

    public static IStatus isNewApplicationNameValid(String applicationName, String packageName, int dummyParameter) {
        String pluginID = ServiceApplicationEditorPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        String warningMessage = null;
        MMCCheckServices.CheckResult checkResult = MMCCheckServices.isValidMDOName((String)applicationName);
        if (!checkResult.isOk()) {
            return new Status(4, pluginID, 4, checkResult.getMessage(), null);
        }
        IStatus lengthStatus = MMCCheckServices.isValidMDONameLength((String)applicationName);
        if (lengthStatus.getSeverity() == 2) {
            warningMessage = lengthStatus.getMessage();
        } else if (lengthStatus.getSeverity() == 4) {
            return new Status(4, pluginID, 4, lengthStatus.getMessage(), lengthStatus.getException());
        }
        if (applicationName != null && applicationName.length() > 0 && Character.isLowerCase(applicationName.charAt(0))) {
            return new Status(4, pluginID, 4, mCoreTextPool.getText(17, (Object)applicationName), null);
        }
        if (warningMessage != null) {
            return new Status(2, pluginID, 2, warningMessage, null);
        }
        return new Status(0, pluginID, 0, "", null);
    }

    public static Application createApplication(WebDynproRoot root, String packageName, String applicationName, Component component, InboundPlug startupPlug, SourcePathIdentifier sourcePathIdentifier) throws CreateException {
        Application application = ApplicationService.createApplicationMetadata(root, packageName, applicationName, sourcePathIdentifier);
        application.setComponent(component);
        application.setStartupPlug(startupPlug);
        String logicalName = application.getPackage() + "." + application.getName();
        PARService.createApplicationFilesAndFolders((Application)application);
        return application;
    }

    private static Application createApplicationMetadata(WebDynproRoot root, String packageName, String applicationName, SourcePathIdentifier sourcePathIdentifier) throws CreateException {
        if (root.getMetamodel().objectExists(packageName, applicationName, (MDOEnum)WebDynproMDOEnum.APPLICATION)) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService = ApplicationService.class$("com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService")) : class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService, "createApplicationMetadata(WebDynproRoot, String, String)", "File already exists", new Exception(), false);
            return null;
        }
        Application application = null;
        application = root.createApplication(packageName, applicationName, sourcePathIdentifier);
        ApplicationPropertyDefinitionSet definitionSet = null;
        try {
            definitionSet = root.getApplicationPropertyDefinitionSet(STANDARD_APPLICATION_PROPERTY_DEFINITION_SET_PACKAGE, STANDARD_APPLICATION_PROPERTY_DEFINITION_SET_NAME);
        }
        catch (LoadException e) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService = ApplicationService.class$("com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService")) : class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService, "createApplicationMetadata(WebDynproRoot, String, String)", e.getMessage(), e, false);
        }
        application.addPropertyDefinitionSet(definitionSet);
        return application;
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationCreation(WebDynproRoot root) {
        return new MMRepositoryObject[0];
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationModification(Application application) {
        return ApplicationService.getRepositoryObjectsAffectedByApplicationDeletion(application);
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByApplicationDeletion(Application application) {
        ArrayList<MMRepositoryObject> result = new ArrayList<MMRepositoryObject>();
        result.add(ApplicationRepositoryManager.getRepositioryObject((Application)application, (boolean)true));
        return result.toArray(new MMRepositoryObject[0]);
    }

    public static void deleteApplication(Application application) {
        IEditorPart editor = ApplicationService.findApplicationEditor(application);
        if (editor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
        }
        try {
            application.delete();
        }
        catch (DeleteException e) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService = ApplicationService.class$("com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService")) : class$com$sap$ide$webdynpro$service$applicationeditor$application$ApplicationService, "deleteApplication(Application)", e.getMessage(), e, false);
            return;
        }
    }

    public static IEditorPart findApplicationEditor(Application application) {
        if (application == null) {
            return null;
        }
        IMetamodelSaveParticipant[] participants = MetamodelHelper.getAllActiveMetamodelEditors((Metamodel)application.getRoot().getMetamodel());
        int i = 0;
        while (i < participants.length) {
            ApplicationEditorInput controllerInput;
            IEditorPart editor;
            if (participants[i] instanceof IEditorPart && (editor = (IEditorPart)participants[i]).getEditorInput() instanceof ApplicationEditorInput && (controllerInput = (ApplicationEditorInput)editor.getEditorInput()).getApplication().equals(application)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

