/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.applicationeditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.framework.ApplicationPropertyDefinition;
import com.sap.ide.webdynpro.service.applicationeditor.ApplicationEditorInput;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceApplicationEditorPlugin;
import com.sap.ide.webdynpro.service.applicationeditor.TextPool;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationCaller;
import com.sap.ide.webdynpro.service.applicationeditor.application.ApplicationService;
import com.sap.ide.webdynpro.service.applicationeditor.internal.ApplicationPropertyDefinitionSelection;
import com.sap.ide.webdynpro.service.applicationeditor.paste.CopyApplicationDialog;
import com.sap.ide.webdynpro.service.core.CallbackException;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.sap.ide.webdynpro.service.core.UIHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ServiceWithUI {
    private static final String APPLICATION_EDITOR_PLUGIN_ID = "com.sap.ide.webdynpro.applicationeditor";
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI;

    public static Application createApplication(WebDynproRoot root) {
        if (!ProjectService.checkMetamodelLanguage((Metamodel)root.getMetamodel())) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)mCoreTextPool.getText(9), (String)mCoreTextPool.getText(47));
            return null;
        }
        ApplicationCaller caller = null;
        try {
            caller = new ApplicationCaller();
        }
        catch (CallbackException e) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI = ServiceWithUI.class$("com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI")) : class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI, "createApplication(WebDynproRoot)", e.getMessage(), e, false);
            return null;
        }
        return caller.createApplicationWithUI(root);
    }

    public static IEditorPart editApplication(Application application) {
        ApplicationEditorInput input = new ApplicationEditorInput(application);
        return ServiceWithUI.openEditor(input);
    }

    private static IEditorPart openEditor(ApplicationEditorInput input) {
        IEditorPart editor = ApplicationService.findApplicationEditor(input.getApplication());
        if (editor != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)editor);
            return editor;
        }
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "com.sap.ide.webdynpro.editors.application");
        }
        catch (PartInitException e) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI = ServiceWithUI.class$("com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI")) : class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI, "openEditor(ApplicationEditorInput)", e.getMessage(), e, false);
            return null;
        }
    }

    public static void deleteApplication(Application application) {
        if (UIHelper.askUserToDelete((String)application.getName(), (String)mCoreTextPool.getText(126))) {
            MMRepositoryObject[] repositoryObjects = ApplicationService.getRepositoryObjectsAffectedByApplicationDeletion(application);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ApplicationService.deleteApplication(application);
        }
    }

    public static ApplicationPropertyDefinition selectApplicationPropertyDefinition(DevelopmentObjectFilter filter, MainDevelopmentObject mdo) {
        ApplicationPropertyDefinitionSelection selection = new ApplicationPropertyDefinitionSelection(filter);
        return selection.select(mdo);
    }

    public static CopyApplicationDialog displayCopyApplicationDialog(IPackageFragmentRoot[] allSourceRoots, IPackageFragmentRoot preselectedRoot, Metamodel newMetamodel, String applicationName, String applicationPackage, ClipboardObject[] clipboardObjectsHistory, boolean enableSourceFolderList) {
        CopyApplicationDialog dialog;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && (dialog = new CopyApplicationDialog(allSourceRoots, preselectedRoot, newMetamodel, applicationName, applicationPackage, clipboardObjectsHistory, enableSourceFolderList)).open() == 0) {
            return dialog;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Platform.getPluginRegistry().getPluginDescriptor(APPLICATION_EDITOR_PLUGIN_ID).getPlugin().startup();
        }
        catch (CoreException e) {
            ServiceApplicationEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI == null ? (class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI = ServiceWithUI.class$("com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI")) : class$com$sap$ide$webdynpro$service$applicationeditor$ServiceWithUI, "static initializer", e.getMessage(), e, false);
        }
    }
}

