/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.services.configuration.exception.SAPConfigurationUnsupportedOperationException;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.Constants;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ValueEntryPanel
extends BasePanel
implements ActionListener {
    private JComboBox _valueClassSelection = ComponentFactory.createComboBox((Object[])Constants.VALUE_CLASSES, (int)0, (ActionListener)this, (String)"Select the datatype of the entry");
    private JTextField _valueField;
    private JPanel _valueFieldPanel;

    public ValueEntryPanel(Object value, boolean editMode) throws Exception {
        if (value != null) {
            this._valueClassSelection.setSelectedItem(this.getValueClass(value));
        } else {
            this._valueClassSelection.setSelectedIndex(0);
        }
        this._valueClassSelection.setEnabled(editMode);
        this._valueField = ComponentFactory.createTextField((int)20, (int)-1, (String)"The value of the entry to create");
        if (value != null) {
            this._valueField.setText(this.getStringForValue(value));
        }
        this._valueField.setEditable(editMode);
        this._valueFieldPanel = ComponentFactory.createLabelForComponent((String)"Value:", (JComponent)this._valueField);
        JPanel valueEntryPanel = ComponentFactory.createVerticalFlowPanel((JComponent[])new JComponent[]{this._valueClassSelection, this._valueFieldPanel});
        this.setLayout(new BorderLayout());
        this.add((Component)valueEntryPanel, "North");
    }

    public void actionPerformed(ActionEvent event) {
    }

    public String getValueClass() {
        return (String)this._valueClassSelection.getSelectedItem();
    }

    public Object getValue() {
        String valueClass = this.getValueClass();
        String value = this._valueField.getText();
        try {
            Object parsedValue;
            if ("String".equals(valueClass)) {
                parsedValue = value;
            } else if ("Short".equals(valueClass)) {
                parsedValue = Short.valueOf(value);
            } else if ("Integer".equals(valueClass)) {
                parsedValue = Integer.valueOf(value);
            } else if ("Long".equals(valueClass)) {
                parsedValue = Long.valueOf(value);
            } else if ("Double".equals(valueClass)) {
                parsedValue = Double.valueOf(value);
            } else if ("Boolean".equals(valueClass)) {
                parsedValue = Boolean.valueOf(value);
            } else if ("Binary".equals(valueClass)) {
                parsedValue = BasePanel.UTIL.convertStringToByteArray(value);
            } else if ("Byte".equals(valueClass)) {
                parsedValue = Byte.valueOf(value);
            } else {
                this.displayMessage("Unknown datatype", "The datatype " + valueClass + " is not registered and can not be created or changed");
                return null;
            }
            return parsedValue;
        }
        catch (NumberFormatException e) {
            this.displayMessage("Invalid input", "The input can not be converted to the datatype " + valueClass + ":\n" + e.getMessage());
            return null;
        }
    }

    private String getStringForValue(Object value) {
        if (value instanceof byte[]) {
            return BasePanel.UTIL.convertByteArrayToString((byte[])value);
        }
        return value.toString();
    }

    private String getValueClass(Object value) throws Exception {
        String valueClass;
        if (value instanceof String) {
            valueClass = "String";
        } else if (value instanceof Boolean) {
            valueClass = "Boolean";
        } else if (value instanceof Short) {
            valueClass = "Short";
        } else if (value instanceof Integer) {
            valueClass = "Integer";
        } else if (value instanceof Long) {
            valueClass = "Long";
        } else if (value instanceof Double) {
            valueClass = "Double";
        } else if (value instanceof byte[]) {
            valueClass = "Binary";
        } else if (value instanceof Byte) {
            valueClass = "Byte";
        } else {
            throw new SAPConfigurationUnsupportedOperationException("configuration_1104", new Object[]{value.getClass().getName()});
        }
        return valueClass;
    }
}

