/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.locking.DescribedFile;
import com.sap.engine.frame.core.locking.DescribedFileContent;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.CreateTreeNodePanel;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FileEntryPanel
extends BasePanel
implements ActionListener,
KeyListener {
    public static final int MAX_VALUE_SIZE_TO_DISPLAY = 20000;
    public static final String DISPLAY_TEXT = "Text";
    public static final String DISPLAY_BINARY = "Binary";
    public static final String[] ALL_DISPLAY_TYPES = new String[]{"Text", "Binary"};
    private static Icon ICON_UPLOAD = new ImageIcon((class$com$sap$engine$services$configuration$gui$FileEntryPanel == null ? (class$com$sap$engine$services$configuration$gui$FileEntryPanel = FileEntryPanel.class$("com.sap.engine.services.configuration.gui.FileEntryPanel")) : class$com$sap$engine$services$configuration$gui$FileEntryPanel).getResource("images/icon_upload.gif"));
    private static Icon ICON_DOWNLOAD = new ImageIcon((class$com$sap$engine$services$configuration$gui$FileEntryPanel == null ? (class$com$sap$engine$services$configuration$gui$FileEntryPanel = FileEntryPanel.class$("com.sap.engine.services.configuration.gui.FileEntryPanel")) : class$com$sap$engine$services$configuration$gui$FileEntryPanel).getResource("images/icon_download.gif"));
    private JComboBox _displayTypeSelection;
    private JTextArea _valueArea;
    private JButton _importFile;
    private JButton _exportFile;
    private CreateTreeNodePanel _parentPanel;
    private String _fileEntryName;
    private byte[] _value;
    private boolean _displayAsText;
    private boolean _wasValueChanged;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$FileEntryPanel;

    public FileEntryPanel(byte[] value, int rows, int columns, boolean editMode, CreateTreeNodePanel parentPanel, String fileEntryName) throws Exception {
        this._parentPanel = parentPanel;
        this._fileEntryName = fileEntryName;
        this._displayTypeSelection = ComponentFactory.createComboBox((Object[])ALL_DISPLAY_TYPES, (int)0, (ActionListener)this, (String)"Select how to display the data");
        JPanel displayTypePanel = ComponentFactory.createLabelForComponent((String)"Display:", (JComponent)this._displayTypeSelection);
        this._valueArea = new JTextArea();
        this._valueArea.setFont(new Font("Monospaced", this._valueArea.getFont().getStyle(), this._valueArea.getFont().getSize()));
        this._valueArea.setRows(rows);
        this._valueArea.setColumns(columns);
        this._valueArea.setEditable(editMode);
        JScrollPane scrollableValueArea = new JScrollPane(this._valueArea);
        scrollableValueArea.doLayout();
        this._importFile = ComponentFactory.createButton((String)"Upload", (Icon)ICON_UPLOAD, (ActionListener)this, (String)"Loads the contents from a file");
        this._exportFile = ComponentFactory.createButton((String)"Download", (Icon)ICON_DOWNLOAD, (ActionListener)this, (String)"Saves the contents to a file");
        this._importFile.setEnabled(editMode);
        JPanel buttons = null;
        buttons = parentPanel != null ? ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._importFile}) : ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._importFile, this._exportFile});
        this.setValue(value);
        JPanel valuePanel = ComponentFactory.createVerticalPanel((JComponent)displayTypePanel, (JComponent)scrollableValueArea, (JComponent)buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)valuePanel, "Center");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._displayTypeSelection) {
                if (DISPLAY_TEXT.equals(this._displayTypeSelection.getSelectedItem())) {
                    this.changeDisplay(true, false);
                    return;
                } else {
                    int result;
                    if (!DISPLAY_BINARY.equals(this._displayTypeSelection.getSelectedItem())) return;
                    if (this._wasValueChanged && (result = JOptionPane.showConfirmDialog(this, "If you switch to the binary display mode, all changes you performed in the text mode will be discarded.\nDo you want to proceed?", "Switch display mode", 0, 3)) != 0) {
                        this._displayTypeSelection.setSelectedIndex(0);
                        return;
                    }
                    this.changeDisplay(false, true);
                }
                return;
            } else if (source == this._importFile) {
                this.uploadFile();
                return;
            } else {
                if (source != this._exportFile) return;
                this.downloadFile();
            }
            return;
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public boolean changeDisplay(boolean displayAsText, boolean revert) {
        boolean success;
        if (!revert && this._displayAsText == displayAsText) {
            return true;
        }
        if (!this.canValueBeDisplayed()) {
            return false;
        }
        if (!revert && !(success = this.convertTextToValue())) {
            this.setDisplayAsText(this._displayAsText);
            return false;
        }
        this._valueArea.addKeyListener(this);
        this._wasValueChanged = false;
        if (displayAsText) {
            String text = new String(this._value);
            boolean readable = BasePanel.UTIL.isStringReadable(text);
            if (readable) {
                this.setValueText(this.replace(text, "\r\n", "\n"));
                this.setDisplayAsText(true);
                return true;
            }
            this.setValueText(BasePanel.UTIL.convertByteArrayToString(this._value));
            this.setDisplayAsText(false);
            this.displayMessage("Conversion failed", "The binary data contains ISO-control-characters and can not be displayed as a readable text");
            return false;
        }
        this.setValueText(BasePanel.UTIL.convertByteArrayToString(this._value));
        this.setDisplayAsText(false);
        return true;
    }

    public byte[] getValue() {
        boolean success = this.convertTextToValue();
        if (!success) {
            return null;
        }
        return this._value;
    }

    public void setValue(byte[] value) {
        if (value == null) {
            value = new byte[]{};
        }
        this._value = value;
        this.changeDisplay(true, true);
    }

    private void setDisplayAsText(boolean displayAsText) {
        this._displayAsText = displayAsText;
        if (this._displayAsText) {
            this._displayTypeSelection.setSelectedItem(DISPLAY_TEXT);
        } else {
            this._displayTypeSelection.setSelectedItem(DISPLAY_BINARY);
        }
    }

    private void setValueText(String text) {
        this._valueArea.setText(text);
        this._valueArea.setCaretPosition(0);
    }

    private boolean convertTextToValue() {
        if (!this._valueArea.isEnabled()) {
            return true;
        }
        if (this._displayAsText) {
            this._value = this._valueArea.getText().getBytes();
            return true;
        }
        try {
            this._value = BasePanel.UTIL.convertStringToByteArray(this._valueArea.getText());
            return true;
        }
        catch (NumberFormatException e) {
            this.displayMessage("Conversion failed", "The current input can not be converted to binary data: " + e.getMessage());
            return false;
        }
    }

    private void uploadFile() throws Exception {
        int result;
        JFileChooser fileChooser = new JFileChooser();
        if (DisplayAllConfigurationsPanel.FileChooserRoot != null) {
            fileChooser.setCurrentDirectory(DisplayAllConfigurationsPanel.FileChooserRoot);
        }
        if ((result = fileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        DescribedFile describedFile = new DescribedFile(file.getName(), file);
        DescribedFileContent content = BasePanel.UTIL.getDescribedFileContent(describedFile, -1, 0);
        if ((content.getErrorFlag() & 1) != 0) {
            this.displayMessage("File does not exist", "The file '" + file + "' does not exist");
            return;
        }
        if ((content.getErrorFlag() & 2) != 0) {
            this.displayMessage("Not a file", "The file '" + file + "' points to a directory and not a file");
            return;
        }
        if ((content.getErrorFlag() & 3) != 0) {
            this.displayMessage("Can not read", "The file '" + file + "' is not readable");
            return;
        }
        this.setValue(content.getFileContent());
        DisplayAllConfigurationsPanel.FileChooserRoot = file.getParentFile();
        if (this._parentPanel != null) {
            this._parentPanel.setName(file.getName());
        }
    }

    private boolean canValueBeDisplayed() {
        boolean result;
        if (this._value.length > 20000) {
            String message = "The content can not be displayed, because it is too big:\nit has " + this._value.length + " bytes, but because of performance-reasons only contents up to " + 20000 + " bytes would be displayed\n" + "It is nevertheless possible to export the content to a file and view it with external viewers.";
            this._valueArea.setText(message);
            result = false;
        } else {
            result = true;
        }
        this._displayTypeSelection.setEnabled(result);
        this._valueArea.setEnabled(result);
        return result;
    }

    private boolean downloadFile() throws Exception {
        if (!this.convertTextToValue()) {
            return false;
        }
        JFileChooser fileChooser = new JFileChooser();
        String currentPath = null;
        currentPath = DisplayAllConfigurationsPanel.FileChooserRoot != null ? DisplayAllConfigurationsPanel.FileChooserRoot.getAbsolutePath() + File.separator + this._fileEntryName : this._fileEntryName;
        fileChooser.setSelectedFile(new File(currentPath));
        int result = fileChooser.showSaveDialog(this);
        if (result != 0) {
            return false;
        }
        File file = fileChooser.getSelectedFile();
        if (file.exists()) {
            if (file.isDirectory()) {
                this.displayMessage("Path is directory", "The specified path '" + file + "' is a directory, so saving a file with this name is not possible");
                return false;
            }
            if (!file.canWrite()) {
                this.displayMessage("File is write-protected", "The file '" + file + "' already exists and is write-protected, so saving the file is not possible.");
                return false;
            }
            int overwrite = JOptionPane.showConfirmDialog(this, "The file '" + file + "' already exists\nOverwrite the file?", "Overwrite file?", 2, 3);
            if (overwrite != 0) {
                return false;
            }
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(this._value);
            out.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
        }
        catch (Exception e) {}
        DisplayAllConfigurationsPanel.FileChooserRoot = file.getParentFile();
        return true;
    }

    private String replace(String sourceStr, String subSourceStr, String subDestStr) {
        int sourceLength = subSourceStr.length();
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while ((index = sourceStr.indexOf(subSourceStr)) != -1) {
            buffer.append(sourceStr.substring(0, index));
            buffer.append(subDestStr);
            sourceStr = sourceStr.substring(index + sourceLength);
        }
        buffer.append(sourceStr);
        return buffer.toString();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        this._wasValueChanged = true;
        this._valueArea.removeKeyListener(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

