/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.services.configuration.gui.AbstractConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportPanel
extends BasePanel
implements ActionListener,
DocumentListener {
    private static Icon ICON_EXPORT = new ImageIcon((class$com$sap$engine$services$configuration$gui$ExportPanel == null ? (class$com$sap$engine$services$configuration$gui$ExportPanel = ExportPanel.class$("com.sap.engine.services.configuration.gui.ExportPanel")) : class$com$sap$engine$services$configuration$gui$ExportPanel).getResource("images/icon_export.gif"));
    private static Icon ICON_CLOSE = new ImageIcon((class$com$sap$engine$services$configuration$gui$ExportPanel == null ? (class$com$sap$engine$services$configuration$gui$ExportPanel = ExportPanel.class$("com.sap.engine.services.configuration.gui.ExportPanel")) : class$com$sap$engine$services$configuration$gui$ExportPanel).getResource("images/icon_close_config.gif"));
    private JTextField m_fileName;
    private JButton m_chooseFile;
    private JButton m_startButton;
    private JButton m_cancelButton;
    private JTextArea m_statusOutput;
    private AbstractConfigurationTreeNode m_node;
    private boolean m_online;
    private Timer m_timer;
    private DecimalFormat m_numberFormat = new DecimalFormat("#0.##");
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$ExportPanel;

    public ExportPanel(AbstractConfigurationTreeNode node, boolean online) {
        this.m_node = node;
        this.m_online = online;
        this.m_timer = new Timer(1000, this);
        this.m_fileName = ComponentFactory.createTextField((int)30, (int)256, (String)"The location and name of the destination file for the export");
        this.m_fileName.getDocument().addDocumentListener(this);
        this.m_chooseFile = ComponentFactory.createButton((String)"...", (ActionListener)this, (String)"Browse ...");
        JPanel fileNameLabel = ComponentFactory.createLabelForComponent((String)"Destination file name:", (JComponent)this.m_fileName);
        JPanel chooseFilePanel = ComponentFactory.createHorizontalPanel((JComponent)fileNameLabel, null, (JComponent)this.m_chooseFile);
        this.m_startButton = ComponentFactory.createButton((String)"Start export", (Icon)ICON_EXPORT, (ActionListener)this, (String)"Start the export to the specified file");
        this.m_startButton.setEnabled(false);
        this.m_cancelButton = ComponentFactory.createButton((String)"Close window", (Icon)ICON_CLOSE, (ActionListener)this, (String)"Close this dialg");
        JPanel buttonPanel = ComponentFactory.createHorizontalPanel((JComponent)this.m_startButton, null, (JComponent)this.m_cancelButton);
        JPanel topPanel = ComponentFactory.createVerticalPanel((JComponent)chooseFilePanel, null, (JComponent)buttonPanel, (Border)ComponentFactory.STANDARD_LINE_BORDER);
        JLabel logLabel = new JLabel("Export status:");
        this.m_statusOutput = new JTextArea();
        this.m_statusOutput.setFont(new Font("Monospaced", this.m_statusOutput.getFont().getStyle(), this.m_statusOutput.getFont().getSize()));
        this.m_statusOutput.setRows(7);
        this.m_statusOutput.setColumns(30);
        this.m_statusOutput.setEditable(false);
        this.m_statusOutput.setLineWrap(true);
        JScrollPane scrollableOutputArea = new JScrollPane(this.m_statusOutput);
        JPanel bottomPanel = ComponentFactory.createVerticalPanel((JComponent)logLabel, null, (JComponent)scrollableOutputArea, (Border)ComponentFactory.STANDARD_LINE_BORDER);
        JPanel exportPanel = ComponentFactory.createVerticalPanel((JComponent)topPanel, null, (JComponent)bottomPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)exportPanel, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        Window window;
        Object source = e.getSource();
        if (source == this.m_timer) {
            this.m_statusOutput.append(".");
        } else if (source == this.m_chooseFile) {
            int result;
            JFileChooser fileChooser = new JFileChooser();
            if (DisplayAllConfigurationsPanel.FileChooserRoot != null) {
                fileChooser.setCurrentDirectory(DisplayAllConfigurationsPanel.FileChooserRoot);
            }
            if ((result = fileChooser.showSaveDialog(this)) != 0) {
                return;
            }
            DisplayAllConfigurationsPanel.FileChooserRoot = fileChooser.getCurrentDirectory();
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            this.m_fileName.setText(fileName);
            this.m_startButton.setEnabled(true);
        } else if (source == this.m_startButton) {
            this.startExport();
        } else if (source == this.m_cancelButton && (window = ComponentFactory.getWindowForComponent((Component)this)) != null) {
            ((Component)window).setVisible(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.m_fileName.getText().length() > 0) {
            this.m_startButton.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.m_fileName.getText().length() == 0) {
            this.m_startButton.setEnabled(false);
        }
    }

    private void startExport() {
        File file = new File(this.m_fileName.getText());
        if (file.exists()) {
            if (file.isDirectory()) {
                this.displayMessage("Path is directory", "The specified path '" + file + "' is a directory, so saving a file with this name is not possible");
                return;
            }
            if (!file.canWrite()) {
                this.displayMessage("File is write-protected", "The file '" + file + "' already exists and is write-protected, so saving the file is not possible.");
                return;
            }
            int overwrite = JOptionPane.showConfirmDialog(this, "The file '" + file + "' already exists. Overwrite file?", "File already exists", 2, 3);
            if (overwrite != 0) {
                return;
            }
        }
        this.m_statusOutput.setText("");
        this.m_statusOutput.append("Start exporting configuration " + this.m_node.getFullName() + " ...\n");
        this.m_statusOutput.append("Exporting ...");
        new Thread(new ExporterThread()).start();
        this.m_timer.start();
        this.m_startButton.setEnabled(false);
        this.m_cancelButton.setEnabled(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ExporterThread
    implements Runnable {
        ExporterThread() {
        }

        public void run() {
            Throwable ex = null;
            long startTime = System.currentTimeMillis();
            try {
                ExportPanel.this.m_node.export(ExportPanel.this.m_fileName.getText());
            }
            catch (Throwable e) {
                ex = e;
            }
            ExportPanel.this.m_timer.stop();
            if (ex == null) {
                long endTime = System.currentTimeMillis();
                File exportedFile = new File(ExportPanel.this.m_fileName.getText());
                double kbSize = (double)exportedFile.length() / 1024.0;
                ExportPanel.this.m_statusOutput.append("\nSuccessfully exported in " + (endTime - startTime) + " ms, file size: " + ExportPanel.this.m_numberFormat.format(kbSize) + " KB.");
            } else {
                StringWriter writer = new StringWriter();
                PrintWriter wrapper = new PrintWriter(writer);
                ex.printStackTrace(wrapper);
                ExportPanel.this.m_statusOutput.setLineWrap(false);
                ExportPanel.this.m_statusOutput.append("\nException occured during export:\n");
                ExportPanel.this.m_statusOutput.append(writer.toString());
                ExportPanel.this.m_statusOutput.append("\nExport failed.");
                ExportPanel.this.m_statusOutput.setLineWrap(true);
            }
            ExportPanel.this.m_startButton.setEnabled(true);
            ExportPanel.this.m_cancelButton.setEnabled(true);
        }
    }
}

