/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.admin.OpenConfigInfo;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.OpenConfigurationDetailPanel;
import com.sap.engine.services.configuration.gui.OpenConfigurationTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DisplayOpenConfigurationsPanel
extends BasePanel
implements ActionListener,
ListSelectionListener {
    private static final Icon ICON_SHOW_DETAILS = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel = DisplayOpenConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayOpenConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel).getResource("images/icon_show_details.gif"));
    private static final Icon ICON_REFRESH = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel = DisplayOpenConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayOpenConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel).getResource("images/icon_refresh.gif"));
    private static final Icon ICON_CLOSE_CONFIG = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel = DisplayOpenConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayOpenConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel).getResource("images/icon_close_config.gif"));
    private ConfigurationHandlerFactory _factory;
    private JPanel _configurationsPanel;
    private SortTable _configurationsTable;
    private OpenConfigurationTableModel _configurationsTableModel;
    private JButton _configurationsRefreshButton;
    private JButton _configurationsDetailSelectedButton;
    private JButton _configurationsDeleteSelectedButton;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$DisplayOpenConfigurationsPanel;

    public DisplayOpenConfigurationsPanel(ConfigurationContext configurationContext) {
        this._factory = configurationContext;
        this._configurationsTableModel = new OpenConfigurationTableModel();
        this._configurationsTable = ComponentFactory.createSortableTable((AbstractTableModel)this._configurationsTableModel);
        this._configurationsTable.getSelectionModel().addListSelectionListener(this);
        this._configurationsTableModel.setColumnModel(this._configurationsTable.getColumnModel());
        this._configurationsTable.getTableHeader().setReorderingAllowed(false);
        this._configurationsTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollableTable = new JScrollPane((Component)this._configurationsTable, 20, 30);
        this._configurationsRefreshButton = ComponentFactory.createButton((String)"Refresh", (Icon)ICON_REFRESH, (ActionListener)this, (String)"Refresh the display");
        this._configurationsDetailSelectedButton = ComponentFactory.createButton((String)"Show details", (Icon)ICON_SHOW_DETAILS, (ActionListener)this, (String)"Show all details for the selected configuration");
        this._configurationsDetailSelectedButton.setEnabled(false);
        this._configurationsDeleteSelectedButton = ComponentFactory.createButton((String)"Close selected configurations", (Icon)ICON_CLOSE_CONFIG, (ActionListener)this, (String)"Closes the selected configurations");
        this._configurationsDeleteSelectedButton.setEnabled(false);
        JPanel buttons = ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._configurationsRefreshButton, this._configurationsDetailSelectedButton, this._configurationsDeleteSelectedButton});
        this._configurationsPanel = ComponentFactory.createVerticalPanel(null, (JComponent)scrollableTable, (JComponent)buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)this._configurationsPanel, "Center");
    }

    private OpenConfigInfo[] getSelectedConfigurations() {
        if (this._configurationsTable.getSelectedRowCount() == 0) {
            return new OpenConfigInfo[0];
        }
        int[] selectedRows = this._configurationsTable.getSelectedRows();
        OpenConfigInfo[] allRows = this._configurationsTableModel.getValues();
        OpenConfigInfo[] result = new OpenConfigInfo[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            result[i] = allRows[this._configurationsTable.getDataIndex(selectedRows[i])];
            ++i;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this._configurationsTable.getSelectedRowCount() == 0) {
            this._configurationsDeleteSelectedButton.setEnabled(false);
        } else {
            this._configurationsDeleteSelectedButton.setEnabled(true);
        }
        if (this._configurationsTable.getSelectedRowCount() != 1) {
            this._configurationsDetailSelectedButton.setEnabled(false);
        } else {
            this._configurationsDetailSelectedButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        block10: {
            try {
                Object source = event.getSource();
                if (source == this._configurationsRefreshButton) {
                    OpenConfigInfo[] values = this._factory.getConfigurationController().getOpenConfigurationInfo();
                    this._configurationsTableModel.setValues(values);
                    break block10;
                }
                if (source == this._configurationsDeleteSelectedButton) {
                    int result = JOptionPane.showConfirmDialog(this, "You are about to close the selected open configurations.\nThis will interrupt the sessions, which are currently working on those configurations.\nDo you really want to proceed?", "Really close?", 2, 3);
                    if (result != 0) {
                        return;
                    }
                    try {
                        OpenConfigInfo[] selected = this.getSelectedConfigurations();
                        int i = 0;
                        while (i < selected.length) {
                            this._factory.getConfigurationController().forceToCloseConfiguration(selected[i]);
                            ++i;
                        }
                        Object var7_11 = null;
                        this._configurationsRefreshButton.doClick();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        this._configurationsRefreshButton.doClick();
                        throw throwable;
                    }
                }
                if (source == this._configurationsDetailSelectedButton) {
                    OpenConfigInfo[] selected = this.getSelectedConfigurations();
                    if (selected.length == 0) {
                        return;
                    }
                    OpenConfigInfo openConfiguration = selected[0];
                    OpenConfigurationDetailPanel detailPanel = new OpenConfigurationDetailPanel(openConfiguration);
                    JOptionPane.showMessageDialog(this, detailPanel, "Details", -1);
                }
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

