/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayCachePanel
extends BasePanel
implements ActionListener,
ChangeListener {
    private static final Icon ICON_CLEAR_CACHE = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayCachePanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayCachePanel = DisplayCachePanel.class$("com.sap.engine.services.configuration.gui.DisplayCachePanel")) : class$com$sap$engine$services$configuration$gui$DisplayCachePanel).getResource("images/icon_clear_cache.gif"));
    private static final Icon ICON_REFRESH = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayCachePanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayCachePanel = DisplayCachePanel.class$("com.sap.engine.services.configuration.gui.DisplayCachePanel")) : class$com$sap$engine$services$configuration$gui$DisplayCachePanel).getResource("images/icon_refresh.gif"));
    private ConfigurationHandlerFactory _factory;
    private JPanel _displayCachePanel;
    private JList _cacheList;
    private JButton _refreshCacheButton;
    private JButton _clearCacheButton;
    private JLabel _cacheHitrate;
    private DecimalFormat _numberFormat = new DecimalFormat("#0.##");
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$DisplayCachePanel;

    public DisplayCachePanel(ConfigurationContext configurationContext) {
        try {
            this._factory = configurationContext;
            String[] cacheContent = this.indentList(this._factory.getConfigurationController().listCache());
            this._cacheList = new JList<String>(cacheContent);
            JScrollPane scrollableList = new JScrollPane(this._cacheList, 20, 30);
            double hitrate = this._factory.getConfigurationController().getCacheHitRate();
            this._cacheHitrate = new JLabel("Cache hit rate: " + this._numberFormat.format(hitrate) + "%");
            JPanel hitratePanel = ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._cacheHitrate});
            this._refreshCacheButton = ComponentFactory.createButton((String)"Refresh", (Icon)ICON_REFRESH, (ActionListener)this, (String)"Refresh the display");
            this._clearCacheButton = ComponentFactory.createButton((String)"Clear cache", (Icon)ICON_CLEAR_CACHE, (ActionListener)this, (String)"Show all details for the selected blocking lock");
            JPanel buttons = ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._refreshCacheButton, this._clearCacheButton});
            this._displayCachePanel = ComponentFactory.createVerticalPanel((JComponent)hitratePanel, (JComponent)scrollableList, (JComponent)buttons);
            this.setLayout(new BorderLayout());
            this.add((Component)this._displayCachePanel, "Center");
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public void actionPerformed(ActionEvent event) {
        block5: {
            try {
                Object source = event.getSource();
                if (source == this._refreshCacheButton) {
                    this.refreshCache();
                    break block5;
                }
                if (source != this._clearCacheButton) break block5;
                try {
                    this._factory.getConfigurationController().clearCache();
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.refreshCache();
                    throw throwable;
                }
                this.refreshCache();
                {
                }
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
        try {
            if (tabbedPane.getSelectedComponent() == this) {
                this.refreshCache();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ComponentFactory.createTextView((String)("Error while refreshing cache" + ex.getMessage())), "Error", 0);
        }
    }

    private void refreshCache() throws ConfigurationException {
        String[] cacheContent = this.indentList(this._factory.getConfigurationController().listCache());
        this._cacheList.setListData(cacheContent);
        double hitrate = this._factory.getConfigurationController().getCacheHitRate();
        this._cacheHitrate.setText("Cache hit rate: " + this._numberFormat.format(hitrate) + "%");
    }

    private String[] indentList(String[] list) {
        int i = 0;
        while (i < list.length) {
            String spaces = "";
            String entry = list[i];
            int j = 0;
            while (j < entry.length()) {
                if (entry.charAt(j) == '/') {
                    spaces = spaces + "  ";
                }
                ++j;
            }
            list[i] = spaces + entry;
            ++i;
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

