/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.gui.SortTable;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.BlockingLockDetailPanel;
import com.sap.engine.services.configuration.gui.BlockingLockTableModel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class DisplayBlockingLocksPanel
extends BasePanel
implements ActionListener,
ListSelectionListener {
    private static final Icon ICON_SHOW_DETAILS = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel = DisplayBlockingLocksPanel.class$("com.sap.engine.services.configuration.gui.DisplayBlockingLocksPanel")) : class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel).getResource("images/icon_show_details.gif"));
    private static final Icon ICON_REFRESH = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel = DisplayBlockingLocksPanel.class$("com.sap.engine.services.configuration.gui.DisplayBlockingLocksPanel")) : class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel).getResource("images/icon_refresh.gif"));
    private static final Icon ICON_REMOVE_LOCK = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel = DisplayBlockingLocksPanel.class$("com.sap.engine.services.configuration.gui.DisplayBlockingLocksPanel")) : class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel).getResource("images/icon_remove_lock.gif"));
    private ConfigurationHandlerFactory _factory;
    private JPanel _blockingLocksPanel;
    private SortTable _blockingLocksTable;
    private BlockingLockTableModel _blockingLocksTableModel;
    private JButton _blockingLocksRefreshButton;
    private JButton _blockingLocksDetailSelectedButton;
    private JButton _blockingLocksDeleteSelectedButton;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$DisplayBlockingLocksPanel;

    public DisplayBlockingLocksPanel(ConfigurationContext configurationContext) {
        this._factory = configurationContext;
        this._blockingLocksTableModel = new BlockingLockTableModel();
        this._blockingLocksTable = ComponentFactory.createSortableTable((AbstractTableModel)this._blockingLocksTableModel);
        this._blockingLocksTable.getSelectionModel().addListSelectionListener(this);
        this._blockingLocksTableModel.setColumnModel(this._blockingLocksTable.getColumnModel());
        this._blockingLocksTable.getTableHeader().setReorderingAllowed(false);
        this._blockingLocksTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollableTable = new JScrollPane((Component)this._blockingLocksTable, 20, 30);
        this._blockingLocksRefreshButton = ComponentFactory.createButton((String)"Refresh", (Icon)ICON_REFRESH, (ActionListener)this, (String)"Refresh the display");
        this._blockingLocksDetailSelectedButton = ComponentFactory.createButton((String)"Show details", (Icon)ICON_SHOW_DETAILS, (ActionListener)this, (String)"Show all details for the selected blocking lock");
        this._blockingLocksDetailSelectedButton.setEnabled(false);
        this._blockingLocksDeleteSelectedButton = ComponentFactory.createButton((String)"Remove selected blocking locks", (Icon)ICON_REMOVE_LOCK, (ActionListener)this, (String)"Remove the selected blocking locks");
        this._blockingLocksDeleteSelectedButton.setEnabled(false);
        JPanel buttons = ComponentFactory.createHorizontalGridPanel((JComponent[])new JComponent[]{this._blockingLocksRefreshButton, this._blockingLocksDetailSelectedButton, this._blockingLocksDeleteSelectedButton});
        this._blockingLocksPanel = ComponentFactory.createVerticalPanel(null, (JComponent)scrollableTable, (JComponent)buttons);
        this.setLayout(new BorderLayout());
        this.add((Component)this._blockingLocksPanel, "Center");
    }

    private BlockingLock[] getSelectedConfigurations() {
        if (this._blockingLocksTable.getSelectedRowCount() == 0) {
            return new BlockingLock[0];
        }
        int[] selectedRows = this._blockingLocksTable.getSelectedRows();
        BlockingLock[] allRows = this._blockingLocksTableModel.getValues();
        BlockingLock[] result = new BlockingLock[selectedRows.length];
        int i = 0;
        while (i < selectedRows.length) {
            result[i] = allRows[this._blockingLocksTable.getDataIndex(selectedRows[i])];
            ++i;
        }
        return result;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this._blockingLocksTable.getSelectedRowCount() == 0) {
            this._blockingLocksDeleteSelectedButton.setEnabled(false);
        } else {
            this._blockingLocksDeleteSelectedButton.setEnabled(true);
        }
        if (this._blockingLocksTable.getSelectedRowCount() != 1) {
            this._blockingLocksDetailSelectedButton.setEnabled(false);
        } else {
            this._blockingLocksDetailSelectedButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        block10: {
            try {
                Object source = event.getSource();
                if (source == this._blockingLocksRefreshButton) {
                    BlockingLock[] values = this._factory.getConfigurationController().getBlockingLockInfo();
                    this._blockingLocksTableModel.setValues(values);
                    break block10;
                }
                if (source == this._blockingLocksDeleteSelectedButton) {
                    int result = JOptionPane.showConfirmDialog(this, "You are about to delete the selected blocking lock.\nIf this is done carelessly it can cause inconsistencies.\nDo you really want to proceed?", "Really delete?", 2, 3);
                    if (result != 0) {
                        return;
                    }
                    try {
                        BlockingLock[] selected = this.getSelectedConfigurations();
                        int i = 0;
                        while (i < selected.length) {
                            this._factory.getConfigurationController().removeBlockingLock(selected[i]);
                            ++i;
                        }
                        Object var7_11 = null;
                        this._blockingLocksRefreshButton.doClick();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        this._blockingLocksRefreshButton.doClick();
                        throw throwable;
                    }
                }
                if (source == this._blockingLocksDetailSelectedButton) {
                    BlockingLock[] selected = this.getSelectedConfigurations();
                    if (selected.length == 0) {
                        return;
                    }
                    BlockingLock blockingLock = selected[0];
                    BlockingLockDetailPanel detailPanel = new BlockingLockDetailPanel(blockingLock);
                    JOptionPane.showMessageDialog(this, detailPanel, "Details", -1);
                }
            }
            catch (Exception e) {
                this.displayException(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

