/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.ConfigurationContext;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.services.configuration.gui.AbstractConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.BasePanel;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.ConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.CreateTreeNodePanel;
import com.sap.engine.services.configuration.gui.ExportPanel;
import com.sap.engine.services.configuration.gui.ImportPanel;
import com.sap.engine.services.configuration.gui.RootTreeNode;
import com.sap.engine.services.locking.gui.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DisplayAllConfigurationsPanel
extends BasePanel
implements MouseListener,
ActionListener,
TreeSelectionListener,
TreeWillExpandListener {
    protected static File FileChooserRoot = null;
    private static Icon ICON_VIEW_CHANGE_MODE = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_view_change_mode.gif"));
    private static Icon ICON_SHOW_DETAILS = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_show_details.gif"));
    private static Icon ICON_REFRESH = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_refresh.gif"));
    private static Icon ICON_CREATE = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_create.gif"));
    private static Icon ICON_CHANGE = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_change.gif"));
    private static Icon ICON_DELETE = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_delete.gif"));
    private static Icon ICON_EXPORT = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_export.gif"));
    private static Icon ICON_IMPORT = new ImageIcon((class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel == null ? (class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel = DisplayAllConfigurationsPanel.class$("com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel")) : class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel).getResource("images/icon_import.gif"));
    private static final String ONLINE_EDIT_WARNING = "You are about to switch to the edit mode.\nIf you directly modify the configuration structure this can cause problems.\nDo you really want to proceed?";
    private static final String OFFLINE_EDIT_WARNING = "You are about to switch to the edit mode.\nIt is very important that all dispatcher and server nodes in the cluster are shut down before you proceed. \nOtherwise any change in the configuration structure may lead to an inconsistency.\nDo you really want to proceed?";
    private ConfigurationHandlerFactoryExtension _factory;
    private JPanel _hierarchyPanel;
    private JTree _hierarchyTree;
    private DefaultTreeModel _hierarchyTreeModel;
    private JButton _hierarchyRefreshSelectedButton;
    private JButton _hierarchyChangeOrDetailsSelectedButton;
    private JButton _hierarchyDeleteSelectedButton;
    private JButton _hierarchyCreateButton;
    private JButton _switchModeButton;
    private JButton _exportButton;
    private JButton _importButton;
    private JPopupMenu _popupMenu;
    private JMenuItem _hierarchyRefreshMenuItem;
    private JMenuItem _hierarchyChangeMenuItem;
    private JMenuItem _hierarchyDeleteMenuItem;
    private JMenuItem _hierarchyCreateMenuItem;
    private JMenuItem _hierarchyCacheModeMenuItem;
    private JMenuItem _hierarchyShowDetailsMenuItem;
    private JMenuItem _exportMenuItem;
    private JMenuItem _importMenuItem;
    private boolean _editMode = false;
    private boolean _online;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$DisplayAllConfigurationsPanel;

    public DisplayAllConfigurationsPanel(ConfigurationContext configurationContext, boolean online) {
        this._online = online;
        this._factory = configurationContext;
        this.initHierarchyPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this._hierarchyPanel, "Center");
    }

    protected final ConfigurationHandlerFactoryExtension getConfigurationHandlerFactoryExtension() {
        return this._factory;
    }

    protected final DefaultTreeModel getTreeModel() {
        return this._hierarchyTreeModel;
    }

    protected final JTree getTree() {
        return this._hierarchyTree;
    }

    private void initHierarchyPanel() {
        RootTreeNode root = new RootTreeNode(this);
        this._hierarchyTreeModel = new DefaultTreeModel(root, true);
        this._hierarchyTree = new JTree(this._hierarchyTreeModel);
        this._hierarchyTree.setCellRenderer(new BaseTreeCellRenderer());
        this._hierarchyTree.getSelectionModel().setSelectionMode(1);
        this._hierarchyTree.addTreeSelectionListener(this);
        this._hierarchyTree.addTreeWillExpandListener(this);
        this._hierarchyTree.addMouseListener(this);
        JScrollPane scrollableTree = new JScrollPane(this._hierarchyTree, 20, 30);
        this._switchModeButton = ComponentFactory.createButton(null, (Icon)ICON_VIEW_CHANGE_MODE, (ActionListener)this, (String)"Switch between view and edit mode");
        this._switchModeButton.setEnabled(true);
        this._hierarchyRefreshSelectedButton = ComponentFactory.createButton(null, (Icon)ICON_REFRESH, (ActionListener)this, (String)"Refresh everything below the selected node");
        this._hierarchyChangeOrDetailsSelectedButton = ComponentFactory.createButton(null, (Icon)ICON_SHOW_DETAILS, (ActionListener)this, (String)"Show the details of the selected node");
        this._hierarchyDeleteSelectedButton = ComponentFactory.createButton(null, (Icon)ICON_DELETE, (ActionListener)this, (String)"Delete the selected node");
        this._hierarchyCreateButton = ComponentFactory.createButton(null, (Icon)ICON_CREATE, (ActionListener)this, (String)"Create a node below the selected node");
        this._exportButton = ComponentFactory.createButton(null, (Icon)ICON_EXPORT, (ActionListener)this, (String)"Export this configuration and the subtree below it to a file");
        this._importButton = ComponentFactory.createButton(null, (Icon)ICON_IMPORT, (ActionListener)this, (String)"Import the content of an export file into or below this node");
        JToolBar buttons = new JToolBar();
        buttons.add(this._switchModeButton);
        buttons.add(this._hierarchyRefreshSelectedButton);
        buttons.addSeparator();
        buttons.add(this._hierarchyChangeOrDetailsSelectedButton);
        buttons.add(this._hierarchyCreateButton);
        buttons.add(this._hierarchyDeleteSelectedButton);
        buttons.addSeparator();
        if (!this._online) {
            buttons.add(this._exportButton);
            buttons.add(this._importButton);
        }
        this._hierarchyPanel = ComponentFactory.createVerticalPanel((JComponent)buttons, (JComponent)scrollableTree, null);
        this.enableControls(null);
        this._popupMenu = new JPopupMenu();
        this._hierarchyCreateMenuItem = new JMenuItem("Create sub-node", ICON_CREATE);
        this._hierarchyCreateMenuItem.addActionListener(this);
        this._hierarchyDeleteMenuItem = new JMenuItem("Delete", ICON_DELETE);
        this._hierarchyDeleteMenuItem.addActionListener(this);
        this._hierarchyCacheModeMenuItem = new JMenuItem("Set caching mode", ICON_CHANGE);
        this._hierarchyCacheModeMenuItem.addActionListener(this);
        this._hierarchyRefreshMenuItem = new JMenuItem("Refresh", ICON_REFRESH);
        this._hierarchyRefreshMenuItem.addActionListener(this);
        this._hierarchyChangeMenuItem = new JMenuItem("Change", ICON_CHANGE);
        this._hierarchyChangeMenuItem.addActionListener(this);
        this._hierarchyShowDetailsMenuItem = new JMenuItem("Show details", ICON_SHOW_DETAILS);
        this._hierarchyShowDetailsMenuItem.addActionListener(this);
        this._exportMenuItem = new JMenuItem("Export", ICON_EXPORT);
        this._exportMenuItem.addActionListener(this);
        this._importMenuItem = new JMenuItem("Import", ICON_IMPORT);
        this._importMenuItem.addActionListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            TreePath path = this._hierarchyTree.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return;
            }
            BaseTreeNode node = (BaseTreeNode)path.getLastPathComponent();
            if (!(node instanceof ConfigurationTreeNode) && !(node instanceof RootTreeNode)) {
                if (this._editMode) {
                    node.changeNode();
                } else {
                    node.showDetailsNode();
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void maybeShowPopup(MouseEvent e) {
        TreePath path;
        if (e.isPopupTrigger() && (path = this._hierarchyTree.getPathForLocation(e.getX(), e.getY())) != null) {
            BaseTreeNode node = (BaseTreeNode)path.getLastPathComponent();
            if (!this._hierarchyTree.isPathSelected(path)) {
                this._hierarchyTree.setSelectionPath(path);
            }
            if (node instanceof ConfigurationTreeNode) {
                this._popupMenu.removeAll();
                if (this._editMode) {
                    this._popupMenu.add(this._hierarchyCreateMenuItem);
                    this._popupMenu.add(this._hierarchyCacheModeMenuItem);
                    this._popupMenu.add(this._hierarchyDeleteMenuItem);
                    if (!this._online) {
                        this._popupMenu.add(this._importMenuItem);
                    }
                } else {
                    this._popupMenu.add(this._hierarchyShowDetailsMenuItem);
                }
                if (!this._online) {
                    this._popupMenu.add(this._exportMenuItem);
                }
                this._popupMenu.add(this._hierarchyRefreshMenuItem);
                this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (node instanceof RootTreeNode) {
                this._popupMenu.removeAll();
                if (this._editMode) {
                    this._popupMenu.add(this._hierarchyCreateMenuItem);
                }
                this._popupMenu.add(this._hierarchyRefreshMenuItem);
                this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this._popupMenu.removeAll();
                if (this._editMode) {
                    this._popupMenu.add(this._hierarchyChangeMenuItem);
                    this._popupMenu.add(this._hierarchyDeleteMenuItem);
                } else {
                    this._popupMenu.add(this._hierarchyShowDetailsMenuItem);
                }
                this._popupMenu.add(this._hierarchyRefreshMenuItem);
                this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this._hierarchyRefreshSelectedButton || source == this._hierarchyRefreshMenuItem) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                node.refreshNode();
            } else if (source == this._hierarchyChangeOrDetailsSelectedButton) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                if (this._editMode) {
                    node.changeNode();
                } else {
                    node.showDetailsNode();
                }
            } else if (source == this._hierarchyChangeMenuItem || source == this._hierarchyCacheModeMenuItem) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                node.changeNode();
            } else if (source == this._hierarchyShowDetailsMenuItem) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                node.showDetailsNode();
            } else if (source == this._hierarchyDeleteSelectedButton || source == this._hierarchyDeleteMenuItem) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                int result = JOptionPane.showConfirmDialog(this, "You are about to delete the selected node '" + node.getName() + "'.\nIf this is done carelessly it can cause problems.\nDo you really want to proceed?", "Really delete?", 2, 3);
                if (result != 0) {
                    return;
                }
                node.deleteNode();
            } else if (source == this._hierarchyCreateButton || source == this._hierarchyCreateMenuItem) {
                BaseTreeNode node = (BaseTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                CreateTreeNodePanel createPanel = new CreateTreeNodePanel(node, true);
                JDialog dialog = ComponentFactory.createDialog((Component)this, (Component)createPanel, (String)"Create", (boolean)true);
                ((Component)dialog).setVisible(true);
            } else if (source == this._switchModeButton) {
                if (this._editMode) {
                    this._hierarchyChangeOrDetailsSelectedButton.setIcon(ICON_SHOW_DETAILS);
                    this._editMode = false;
                } else {
                    String message = this._online ? ONLINE_EDIT_WARNING : OFFLINE_EDIT_WARNING;
                    int result = JOptionPane.showConfirmDialog(this, message, "Switch to Edit mode", 0, 2);
                    if (result != 0) {
                        return;
                    }
                    this._hierarchyChangeOrDetailsSelectedButton.setIcon(ICON_CHANGE);
                    this._editMode = true;
                }
                this._hierarchyChangeOrDetailsSelectedButton.setVisible(false);
                this._hierarchyChangeOrDetailsSelectedButton.setVisible(true);
                this.enableControls(this._hierarchyTree.getLastSelectedPathComponent());
            } else if (source == this._exportButton || source == this._exportMenuItem) {
                AbstractConfigurationTreeNode node = (AbstractConfigurationTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                ExportPanel exportPanel = new ExportPanel(node, this._online);
                JDialog dialog = ComponentFactory.createDialog((Component)this, (Component)exportPanel, (String)"Export configuration", (boolean)true);
                ((Component)dialog).setVisible(true);
            } else if (source == this._importButton || source == this._importMenuItem) {
                AbstractConfigurationTreeNode node = (AbstractConfigurationTreeNode)this._hierarchyTree.getLastSelectedPathComponent();
                ImportPanel importPanel = new ImportPanel(node, this._online);
                JDialog dialog = ComponentFactory.createDialog((Component)this, (Component)importPanel, (String)"Import configuration", (boolean)true);
                ((Component)dialog).setVisible(true);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public void treeWillExpand(TreeExpansionEvent e) {
        BaseTreeNode node = (BaseTreeNode)e.getPath().getLastPathComponent();
        node.loadChildrenDisplayException(false);
    }

    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object node = this._hierarchyTree.getLastSelectedPathComponent();
        this.enableControls(node);
    }

    private void enableControls(Object node) {
        if (node == null) {
            this._hierarchyRefreshSelectedButton.setEnabled(false);
            this._hierarchyChangeOrDetailsSelectedButton.setEnabled(false);
            this._hierarchyDeleteSelectedButton.setEnabled(false);
            this._hierarchyCreateButton.setEnabled(false);
            this._exportButton.setEnabled(false);
            this._importButton.setEnabled(false);
        } else {
            this._hierarchyRefreshSelectedButton.setEnabled(true);
            if (node instanceof RootTreeNode) {
                this._hierarchyChangeOrDetailsSelectedButton.setEnabled(false);
            } else {
                this._hierarchyChangeOrDetailsSelectedButton.setEnabled(true);
            }
            if (!this._editMode || node instanceof RootTreeNode) {
                this._hierarchyDeleteSelectedButton.setEnabled(false);
            } else {
                this._hierarchyDeleteSelectedButton.setEnabled(true);
            }
            if (this._editMode && (node instanceof RootTreeNode || node instanceof ConfigurationTreeNode)) {
                this._hierarchyCreateButton.setEnabled(true);
            } else {
                this._hierarchyCreateButton.setEnabled(false);
            }
            if (node instanceof AbstractConfigurationTreeNode && !this._online) {
                this._exportButton.setEnabled(true);
                if (this._editMode) {
                    this._importButton.setEnabled(true);
                } else {
                    this._importButton.setEnabled(false);
                }
            } else {
                this._exportButton.setEnabled(false);
                this._importButton.setEnabled(false);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

