/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.frame.core.locking.Util;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.Constants;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.locking.gui.ComponentFactory;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public abstract class BaseTreeNode
extends DefaultMutableTreeNode
implements Constants {
    public static final char DIRECTORY_SEPARATOR = '/';
    public static final Util UTIL = new Util();
    private DisplayAllConfigurationsPanel _editor;
    private String _name;
    private String _fullParentName;
    private String _fullName;

    public BaseTreeNode(DisplayAllConfigurationsPanel editor, String fullParentName, String name) {
        this._editor = editor;
        this._fullParentName = fullParentName;
        this._name = name;
    }

    protected final DisplayAllConfigurationsPanel getEditor() {
        return this._editor;
    }

    protected final ConfigurationHandlerFactoryExtension getFactory() {
        return this._editor.getConfigurationHandlerFactoryExtension();
    }

    protected final DefaultTreeModel getModel() {
        return this._editor.getTreeModel();
    }

    protected final String getName() {
        return this._name;
    }

    protected final String getFullParentName() {
        return this._fullParentName;
    }

    protected final String getFullName() {
        if (this._fullName == null) {
            if (this._fullParentName == null) {
                this._fullName = this._name;
            } else {
                StringBuffer buffer = new StringBuffer(this._fullParentName.length() + 1 + this._name.length());
                buffer.append(this._fullParentName).append('/').append(this._name);
                this._fullName = buffer.toString();
            }
        }
        return this._fullName;
    }

    protected void loadDisplayException(boolean forceReload) {
        try {
            this.load(forceReload);
        }
        catch (Exception e) {
            this.getEditor().displayException(e);
            this.refreshAsGoodAsPossible();
        }
    }

    protected void loadChildrenDisplayException(boolean forceReload) {
        try {
            this.loadChildren(forceReload);
        }
        catch (Exception e) {
            this.getEditor().displayException(e);
            this.refreshAsGoodAsPossible();
        }
    }

    protected void loadRecursive(boolean forceReload) throws Exception {
        try {
            this.load(forceReload);
        }
        catch (Exception e) {
            if (this.getParent() != null) {
                ((BaseTreeNode)this.getParent()).refreshNodeInternal();
            }
            throw e;
        }
    }

    protected void refreshNodeInternal() throws Exception {
        this.loadRecursive(true);
    }

    protected void refreshNode() {
        this.loadDisplayException(true);
    }

    protected void closeAllConfigsInHandler(ConfigurationHandler handler) {
        try {
            handler.closeAllConfigurations();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getEditor(), ComponentFactory.createTextView((String)"Error while closing configuration"), "Error", 0);
        }
    }

    protected void refreshAsGoodAsPossible() {
        try {
            ((BaseTreeNode)this.getParent()).refreshNodeInternal();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getEditor(), ComponentFactory.createTextView((String)"Not the whole configuration tree could be refreshed"), "Information", 1);
        }
    }

    protected abstract void load(boolean var1) throws Exception;

    protected abstract void loadChildren(boolean var1) throws Exception;

    protected abstract void deleteNode();

    protected abstract void changeNode();

    protected abstract void showDetailsNode();

    protected abstract void createConfigurationNode(String var1, Integer var2, int var3);

    protected abstract void setIcons(BaseTreeCellRenderer var1);
}

