/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.gui;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationInfo;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import com.sap.engine.services.configuration.gui.BaseTreeCellRenderer;
import com.sap.engine.services.configuration.gui.BaseTreeNode;
import com.sap.engine.services.configuration.gui.ConfigurationTreeNode;
import com.sap.engine.services.configuration.gui.Constants;
import com.sap.engine.services.configuration.gui.DisplayAllConfigurationsPanel;
import com.sap.engine.services.configuration.gui.FileEntryTreeNode;
import com.sap.engine.services.configuration.gui.PropertySheetTreeNode;
import com.sap.engine.services.configuration.gui.ValueEntryTreeNode;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public abstract class AbstractConfigurationTreeNode
extends BaseTreeNode
implements Constants {
    private static final Category CATEGORY = Category.getCategory((String)"/System/Server");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$configuration$gui$AbstractConfigurationTreeNode == null ? (class$com$sap$engine$services$configuration$gui$AbstractConfigurationTreeNode = AbstractConfigurationTreeNode.class$("com.sap.engine.services.configuration.gui.AbstractConfigurationTreeNode")) : class$com$sap$engine$services$configuration$gui$AbstractConfigurationTreeNode));
    private static final Icon ICON_CONFIGURATION = new ImageIcon((class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer == null ? (class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer = AbstractConfigurationTreeNode.class$("com.sap.engine.services.configuration.gui.BaseTreeCellRenderer")) : class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer).getResource("images/configuration.gif"));
    private static final Icon ICON_CONFIGURATION_READALL = new ImageIcon((class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer == null ? (class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer = AbstractConfigurationTreeNode.class$("com.sap.engine.services.configuration.gui.BaseTreeCellRenderer")) : class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer).getResource("images/configuration_readall.gif"));
    private static final Icon ICON_CONFIGURATION_CACHEON = new ImageIcon((class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer == null ? (class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer = AbstractConfigurationTreeNode.class$("com.sap.engine.services.configuration.gui.BaseTreeCellRenderer")) : class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer).getResource("images/configuration_cacheon.gif"));
    private static final Icon ICON_CONFIGURATION_READALL_CACHEON = new ImageIcon((class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer == null ? (class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer = AbstractConfigurationTreeNode.class$("com.sap.engine.services.configuration.gui.BaseTreeCellRenderer")) : class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer).getResource("images/configuration_readall_cacheon.gif"));
    private boolean _loaded = false;
    private boolean _loadedChildren = false;
    private int _cacheMode = 0;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$AbstractConfigurationTreeNode;
    static /* synthetic */ Class class$com$sap$engine$services$configuration$gui$BaseTreeCellRenderer;

    public AbstractConfigurationTreeNode(DisplayAllConfigurationsPanel editor, String fullParentName, String name, int initialCacheMode) {
        super(editor, fullParentName, name);
        this._cacheMode = initialCacheMode;
        this._loaded = true;
        this.initialize();
    }

    protected void load(boolean forceReload) throws Exception {
        if (this._loaded && !forceReload) {
            return;
        }
        this._loaded = true;
        ConfigurationHandler handler = null;
        try {
            handler = this.getFactory().getConfigurationHandler();
            Configuration configuration = handler.openConfiguration(this.getFullName(), 0);
            this._cacheMode = configuration.getCacheMode();
            this.loadChildren(forceReload);
            Object var5_4 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
                this.getModel().nodeChanged(this);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeAllConfigsInHandler(handler);
            if (forceReload && this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
                this.getModel().nodeChanged(this);
            }
            throw throwable;
        }
    }

    protected void loadChildren(boolean forceReload) throws Exception {
        if (this._loadedChildren && !forceReload) {
            return;
        }
        this._loadedChildren = true;
        this.removeAllChildren();
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                int i;
                handler = this.getFactory().getConfigurationHandlerExtension();
                ConfigurationExtension configuration = handler.openConfigurationExtension(this.getFullName(), 0);
                ConfigurationInfo[] configInfo = configuration.getAllSubConfigurationInfo();
                int[] allTypes = new int[]{0, 1};
                int k = 0;
                while (k < allTypes.length) {
                    Object[] nextConfigInfo = this.filterConfigurationInfos(configInfo, allTypes[k]);
                    Arrays.sort(nextConfigInfo);
                    i = 0;
                    while (i < nextConfigInfo.length) {
                        if (nextConfigInfo[i].getType() == 0) {
                            this.addChildTreeNode(new ConfigurationTreeNode(this.getEditor(), this.getFullName(), nextConfigInfo[i].getName(), nextConfigInfo[i].getCacheMode()));
                        } else if (nextConfigInfo[i].getType() == 1) {
                            this.addChildTreeNode(new PropertySheetTreeNode(this.getEditor(), this.getFullName(), nextConfigInfo[i].getName(), nextConfigInfo[i].getCacheMode()));
                        } else {
                            throw new SAPConfigurationIllegalArgumentException("configuration_1201", new Object[]{new Integer(nextConfigInfo[i].getType())});
                        }
                        ++i;
                    }
                    ++k;
                }
                Object[] names = configuration.getAllFileEntryNames();
                Arrays.sort(names);
                i = 0;
                while (i < names.length) {
                    this.addChildTreeNode(new FileEntryTreeNode(this.getEditor(), this.getFullName(), (String)names[i]));
                    ++i;
                }
                names = configuration.getAllConfigEntryNames();
                Arrays.sort(names);
                int i2 = 0;
                while (i2 < names.length) {
                    this.addChildTreeNode(new ValueEntryTreeNode(this.getEditor(), this.getFullName(), (String)names[i2], configuration.getConfigEntryWrapper((String)names[i2])));
                    ++i2;
                }
            }
            catch (Exception e) {
                this.removeAllChildren();
                throw e;
            }
            Object var11_11 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            if (this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            if (this.getModel() != null) {
                this.getModel().nodeStructureChanged(this);
            }
            throw throwable;
        }
    }

    public int getCacheMode() {
        this.loadDisplayException(false);
        return this._cacheMode;
    }

    public TreeNode getChildAt(int childIndex) {
        this.loadDisplayException(false);
        return super.getChildAt(childIndex);
    }

    public int getChildCount() {
        this.loadDisplayException(false);
        return super.getChildCount();
    }

    public int getIndex(TreeNode node) {
        this.loadDisplayException(false);
        return super.getIndex(node);
    }

    public Enumeration children() {
        this.loadDisplayException(false);
        return super.children();
    }

    protected void deleteNode() {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullName(), 1);
                config.deleteConfiguration();
                handler.commit();
                CATEGORY.infoT(LOCATION, "Deleted configuration " + this.getFullName());
                ((BaseTreeNode)this.getParent()).refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var4_5 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var4_4 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void changeNode() {
        ConfigurationHandlerExtension handler;
        block8: {
            block7: {
                handler = null;
                try {
                    try {
                        handler = this.getFactory().getConfigurationHandlerExtension();
                        ConfigurationExtension config = handler.openConfigurationExtension(this.getFullName(), 1);
                        this.refreshNode();
                        Object editor = this.createOwnEditor(config, true);
                        JOptionPane jOptionPane = new JOptionPane(editor, -1, 2);
                        JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Change Configuration");
                        jDialog.setResizable(true);
                        jDialog.show();
                        Object obj = jOptionPane.getValue();
                        if (jOptionPane.getValue() == null) {
                            Object var9_8 = null;
                            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
                            return;
                        }
                        int result = (Integer)obj;
                        if (result != 0) {
                            break block7;
                        }
                        this.overtakeChangesFromOwnEditor((Configuration)config, editor);
                        handler.commit();
                        CATEGORY.infoT(LOCATION, "Changed configuration " + this.getFullName());
                        this.refreshNode();
                        break block8;
                    }
                    catch (Exception e) {
                        this.getEditor().displayException(e);
                        this.refreshAsGoodAsPossible();
                        Object var9_11 = null;
                        this.closeAllConfigsInHandler((ConfigurationHandler)handler);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.closeAllConfigsInHandler((ConfigurationHandler)handler);
                    throw throwable;
                }
            }
            Object var9_9 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            return;
        }
        Object var9_10 = null;
        this.closeAllConfigsInHandler((ConfigurationHandler)handler);
    }

    protected void showDetailsNode() {
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandlerExtension();
                ConfigurationExtension config = handler.openConfigurationExtension(this.getFullName(), 0);
                this.refreshNode();
                Object editor = this.createOwnEditor(config, false);
                JOptionPane jOptionPane = new JOptionPane(editor, -1);
                JDialog jDialog = jOptionPane.createDialog(this.getEditor(), "Display configuration");
                jDialog.setResizable(true);
                jDialog.show();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var7_8 = null;
                this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            }
            Object var7_7 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            throw throwable;
        }
    }

    protected void createValueEntryNode(String name, String valueClass, Object value) {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullName(), 1);
                config.addConfigEntry(name, value);
                handler.commit();
                CATEGORY.infoT(LOCATION, "Created config entry '" + name + "' in configuration " + this.getFullName());
                this.refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var7_8 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var7_7 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void createFileEntryNode(String name, byte[] value) {
        ConfigurationHandlerExtension handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandlerExtension();
                ConfigurationExtension config = handler.openConfigurationExtension(this.getFullName(), 1);
                config.addFileAsBytes(name, value);
                handler.commit();
                CATEGORY.infoT(LOCATION, "Created file entry '" + name + "' in configuration " + this.getFullName());
                this.refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var6_7 = null;
                this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            }
            Object var6_6 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.closeAllConfigsInHandler((ConfigurationHandler)handler);
            throw throwable;
        }
    }

    protected void createConfigurationNode(String name, Integer cacheMode, int type) {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullName(), 1);
                Configuration subConfig = config.createSubConfiguration(name, type);
                if (cacheMode != null) {
                    subConfig.setCacheMode(cacheMode.intValue());
                }
                handler.commit();
                CATEGORY.infoT(LOCATION, "Created subconfiguration '" + name + "' in configuration " + this.getFullName());
                this.refreshNode();
            }
            catch (Exception e) {
                this.getEditor().displayException(e);
                this.refreshAsGoodAsPossible();
                Object var8_9 = null;
                this.closeAllConfigsInHandler(handler);
            }
            Object var8_8 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void export(String destFilePath) throws Exception {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullName(), 1);
                config.export(destFilePath);
                handler.commit();
                CATEGORY.infoT(LOCATION, "Exported subtree under " + this.getFullName() + " to file " + destFilePath);
                this.refreshNode();
            }
            catch (Exception e) {
                handler.rollback();
                this.refreshAsGoodAsPossible();
                throw e;
            }
            Object var5_5 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    protected void importConfig(String srcFilePath, int importMode) throws Exception {
        ConfigurationHandler handler = null;
        try {
            try {
                handler = this.getFactory().getConfigurationHandler();
                Configuration config = handler.openConfiguration(this.getFullName(), 1);
                if (importMode == 1) {
                    config.importAsSubConfiguration(srcFilePath);
                } else {
                    config.importContent(srcFilePath);
                }
                handler.commit();
                CATEGORY.infoT(LOCATION, "Executed an import to " + this.getFullName());
                this.refreshNode();
            }
            catch (Exception e) {
                handler.rollback();
                this.refreshAsGoodAsPossible();
                throw e;
            }
            Object var6_6 = null;
            this.closeAllConfigsInHandler(handler);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeAllConfigsInHandler(handler);
            throw throwable;
        }
    }

    private ConfigurationInfo[] filterConfigurationInfos(ConfigurationInfo[] source, int type) {
        int size = 0;
        int i = 0;
        while (i < source.length) {
            if (source[i].getType() == type) {
                ++size;
            }
            ++i;
        }
        ConfigurationInfo[] result = new ConfigurationInfo[size];
        size = 0;
        int i2 = 0;
        while (i2 < source.length) {
            if (source[i2].getType() == type) {
                result[size++] = source[i2];
            }
            ++i2;
        }
        return result;
    }

    protected abstract Object createOwnEditor(ConfigurationExtension var1, boolean var2) throws Exception;

    protected abstract void overtakeChangesFromOwnEditor(Configuration var1, Object var2) throws Exception;

    protected abstract void setIcons(BaseTreeCellRenderer var1);

    protected abstract void initialize();

    protected abstract void addChildTreeNode(BaseTreeNode var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

