/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import com.sap.engine.services.configuration.command.test.Test;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class TestCommand
extends AbstractCommand {
    private Hashtable m_runningTests = new Hashtable();
    private static final String NAME = "test";
    private static final String DESCRIPTION = "Shows information about the current cache state";
    private static final String USAGE = "Usage: test name (start|stop) number_of_threads\nwhere name is the name of the test class which must be located in com.sap.engine.services.configuration.command.test\n";
    private ConfigurationHandlerFactoryExtension m_factory = this.getConfigurationRuntime().getConfigurationContext();

    public TestCommand(ConfigurationRuntimeInterface runtime) {
        super(runtime);
    }

    public String getUsage() {
        return USAGE;
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintStream out = new PrintStream(output);
        if (params.length < 2) {
            out.println(this.getUsage());
            return;
        }
        String[] tstParams = new String[params.length - 3];
        int i = 0;
        while (i < params.length - 3) {
            tstParams[i] = params[i + 3];
            ++i;
        }
        this.doTests(out, params[0], params[1], Integer.parseInt(params[2]), tstParams);
    }

    private void doTests(PrintStream out, String name, String cmd, int threadCount, String[] params) {
        if (cmd.equals("start")) {
            if (this.m_runningTests.containsKey(name)) {
                out.println(name + " already running !!!");
            } else {
                try {
                    Test test = new Test(name, threadCount, params, (ConfigurationHandlerFactory)this.m_factory);
                    this.m_runningTests.put(name, test);
                    test.runTests(out);
                    out.println(name + " started");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else if (cmd.equals("stop")) {
            Test test = (Test)this.m_runningTests.get(name);
            if (test == null) {
                out.println(name + " not running !!!");
            } else {
                test.stopTests();
                this.m_runningTests.remove(name);
                out.println(name + " stopped!");
            }
        } else {
            out.println(this.getUsage());
        }
    }
}

