/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StorageStatisticsCommand
extends AbstractCommand {
    private static final String NAME = "storage_statistics";
    private static final String DESCRIPTION = "Displays the number of connections in the database connection pool of the ConfigurationManager.";
    private static final String USAGE = "Usage: storage_statistics";

    public StorageStatisticsCommand(ConfigurationRuntimeInterface configurationRuntimeInterface) {
        super(configurationRuntimeInterface);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        try {
            Controller controller = this.getConfigurationRuntime().getConfigurationContext().getConfigurationController();
            int[] stats = controller.getDBPoolStatistics();
            out.println();
            out.println("Database connections pooled by ConfigurationManager:");
            out.println("Total connections: " + stats[0]);
            out.println("Busy connections: " + stats[1]);
            out.println("Idle connections: " + stats[2]);
            out.println("Peak of used connections: " + stats[3]);
            out.println();
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

