/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import com.sap.engine.services.locking.command.OptionParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class ListConfigCommand
extends AbstractCommand {
    private static final String NAME = "list_config";
    private static final String DESCRIPTION = "Displays a list of the parameters and files in the specified configuration object.";
    private static final String USAGE = "Usage: list_config [options] <path>\n    <path>      The path to the configuration object that contains the files and parameters you want to view\n\nwhere options include:\n    -d  -detail              Displays details about all entries in the configuration object\n    -nv -novalues            Does not display key-value pairs\n    -nf -nofiles             Does not display files\n    -nc -noconfigurations    Does not display sub-configurations\n\n";

    public ListConfigCommand(ConfigurationRuntimeInterface configurationRuntimeInterface) {
        super(configurationRuntimeInterface);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    /*
     * Loose catch block
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        block11: {
            String path;
            PrintStream out = new PrintStream(os);
            OptionParser.FlagOption noValues = new OptionParser.FlagOption(new String[]{"nv", "novalues"});
            OptionParser.FlagOption noFiles = new OptionParser.FlagOption(new String[]{"nf", "nofiles"});
            OptionParser.FlagOption noConfigurations = new OptionParser.FlagOption(new String[]{"nc", "noconfigurations"});
            OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
            OptionParser.Option[] options = new OptionParser.Option[]{detail, noValues, noFiles, noConfigurations};
            try {
                String[] remaining = OptionParser.parse((String[])params, (OptionParser.Option[])options);
                if (remaining.length != 1) {
                    throw new SAPConfigurationIllegalArgumentException("configuration_1200");
                }
                path = remaining[0];
            }
            catch (Exception e) {
                out.println("Syntax error in command " + this.getName());
                out.println(this.getUsage());
                return;
            }
            ConfigurationHandlerExtension configurationHandler = null;
            configurationHandler = this.getConfigurationRuntime().getConfigurationContext().getConfigurationHandlerExtension();
            ConfigurationExtension configuration = configurationHandler.openConfigurationExtension(path, 0);
            this.displayConfiguration(out, configuration, detail.getValue(), noValues.getValue(), noFiles.getValue(), noConfigurations.getValue());
            Object var15_16 = null;
            try {
                configurationHandler.closeAllConfigurations();
            }
            catch (Exception e2) {
                out.println("Error while closing the configuration: " + e2.getMessage());
            }
            break block11;
            {
                catch (Exception e) {
                    this.displayException(out, e);
                    Object var15_17 = null;
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (Exception e2) {
                        out.println("Error while closing the configuration: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                }
                catch (Exception e2) {
                    out.println("Error while closing the configuration: " + e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    private void displayConfiguration(PrintStream out, ConfigurationExtension configuration, boolean detail, boolean noValues, boolean noFiles, boolean noConfigurations) throws Exception {
        Object value;
        int i;
        int numberOfDisplays = 3 - (noValues ? 1 : 0) - (noFiles ? 1 : 0) - (noConfigurations ? 1 : 0);
        if (numberOfDisplays == 0) {
            return;
        }
        if (!noConfigurations) {
            String[] configNames = configuration.getAllSubConfigurationNames();
            i = 0;
            while (i < configNames.length) {
                if (numberOfDisplays != 1) {
                    out.print("[config]  ");
                }
                out.println(configNames[i]);
                ++i;
            }
        }
        if (!noValues) {
            String[] valueNames = configuration.getAllConfigEntryNames();
            i = 0;
            while (i < valueNames.length) {
                if (numberOfDisplays != 1) {
                    out.print("[value]   ");
                }
                if (!detail) {
                    out.println(valueNames[i]);
                } else {
                    value = configuration.getConfigEntryWrapper(valueNames[i]);
                    out.println(valueNames[i] + "=" + AbstractCommand.getPrintableValue(value) + "  (" + AbstractCommand.getPrintableValueClass(value) + ")");
                }
                ++i;
            }
        }
        if (!noFiles) {
            String[] fileNames = configuration.getAllFileEntryNames();
            i = 0;
            while (i < fileNames.length) {
                if (numberOfDisplays != 1) {
                    out.print("[file]    ");
                }
                if (!detail) {
                    out.println(fileNames[i]);
                } else {
                    value = configuration.getFileAsBytes(fileNames[i]);
                    out.println(fileNames[i] + "  (length=" + ((Object)value).length + ")");
                }
                ++i;
            }
        }
    }
}

