/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.admin.BlockingLock;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerFactoryExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class InternalLocksCommand
extends AbstractCommand {
    private static final String NAME = "internal_locks";
    private static final String DESCRIPTION = "List and/or remove internal locks of the configuration manager.";
    private static final String USAGE = "Usage: internal_locks [options]\n\nwhere options include:\n    -l -list     List all current internal locks\n    -r -remove   First list all current internal locks, then pick one for removal\n\n";
    private ConfigurationHandlerFactoryExtension m_factory = this.getConfigurationRuntime().getConfigurationContext();

    public InternalLocksCommand(ConfigurationRuntimeInterface runtime) {
        super(runtime);
    }

    public String getUsage() {
        return USAGE;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        PrintStream out = new PrintStream(output);
        if (params.length != 1) {
            out.println(this.getUsage());
            return;
        }
        if (params[0].equalsIgnoreCase("-list") || params[0].equalsIgnoreCase("-l")) {
            this.displayLockList(output);
        } else if (params[0].equalsIgnoreCase("-remove") || params[0].equalsIgnoreCase("-r")) {
            BlockingLock[] locks = this.displayLockList(output);
            this.removeLock(locks, input, output);
        } else {
            out.println(this.getUsage());
        }
    }

    public String getName() {
        return NAME;
    }

    private BlockingLock[] displayLockList(OutputStream os) {
        PrintStream out = new PrintStream(os);
        Controller controller = null;
        try {
            controller = this.m_factory.getConfigurationController();
            BlockingLock[] locks = controller.getBlockingLockInfo();
            if (locks.length == 0) {
                out.println("No internal locks.");
                return null;
            }
            out.println("\nLINE FORMAT: Lock #: ClusterNode ID, Owner transaction ID, Path of configuration, Access mode, Number of waiters, Time blocked\n");
            int i = 0;
            while (i < locks.length) {
                String accessMode = locks[i].getAccessMode() == 0 ? "READ" : "WRITE";
                out.println(i + ": " + locks[i].getClusterNodeID() + ", " + locks[i].getLockOwnerTransactionID() + ", " + locks[i].getBlockedConfigurationPath() + ", " + accessMode + ", " + locks[i].getNumberOfWaiters() + ", " + locks[i].getBlockingTime());
                ++i;
            }
            out.println();
            return locks;
        }
        catch (Exception e) {
            this.displayException(out, e);
            return null;
        }
    }

    private void removeLock(BlockingLock[] locks, InputStream is, OutputStream os) {
        if (locks == null) {
            return;
        }
        PrintStream out = new PrintStream(os);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        Controller controller = null;
        try {
            int nrForDelete;
            controller = this.m_factory.getConfigurationController();
            out.print("Enter lock # to be removed: ");
            String lockNumber = in.readLine();
            if (lockNumber == "") {
                throw new SAPConfigurationIllegalArgumentException("configuration_1203");
            }
            try {
                nrForDelete = Integer.parseInt(lockNumber);
            }
            catch (NumberFormatException e) {
                throw new SAPConfigurationIllegalArgumentException("configuration_1203");
            }
            if (nrForDelete < 0 || nrForDelete > locks.length - 1) {
                throw new SAPConfigurationIllegalArgumentException("configuration_1204");
            }
            controller.removeBlockingLock(locks[nrForDelete]);
            out.println("\nLock removed.");
        }
        catch (Exception e) {
            this.displayException(out, e);
        }
    }
}

