/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.admin.ConfigurationExtension;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import com.sap.engine.services.configuration.command.AbstractCommand;
import com.sap.engine.services.configuration.exception.SAPConfigurationIllegalArgumentException;
import com.sap.engine.services.locking.command.OptionParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class GetConfigFileCommand
extends AbstractCommand {
    private static final String NAME = "show_config_file";
    private static final String DESCRIPTION = "Shows the contents of a file in a specified configuration object.";
    private static final String USAGE = "Usage: show_config_file [options] <path> <name>\n    <path>      The path to the configuration object\n    <name>      The name of the file that you want to view\n\nwhere options include:\n    -d -detail   Display detailed information\n\n";

    public GetConfigFileCommand(ConfigurationRuntimeInterface configurationRuntimeInterface) {
        super(configurationRuntimeInterface);
    }

    public final String getName() {
        return NAME;
    }

    public final String getUsage() {
        return USAGE;
    }

    public final String getDescription() {
        return DESCRIPTION;
    }

    /*
     * Loose catch block
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        block11: {
            String name;
            String path;
            PrintStream out = new PrintStream(os);
            OptionParser.FlagOption detail = new OptionParser.FlagOption(new String[]{"d", "detail"});
            OptionParser.Option[] options = new OptionParser.Option[]{detail};
            try {
                String[] remaining = OptionParser.parse((String[])params, (OptionParser.Option[])options);
                if (remaining.length != 2) {
                    throw new SAPConfigurationIllegalArgumentException("configuration_1200");
                }
                path = remaining[0];
                name = remaining[1];
            }
            catch (Exception e) {
                out.println("Syntax error in command " + this.getName());
                out.println(this.getUsage());
                return;
            }
            ConfigurationHandlerExtension configurationHandler = null;
            configurationHandler = this.getConfigurationRuntime().getConfigurationContext().getConfigurationHandlerExtension();
            ConfigurationExtension configuration = configurationHandler.openConfigurationExtension(path, 0);
            this.displayConfiguration(out, configuration, name, detail.getValue());
            Object var13_14 = null;
            try {
                configurationHandler.closeAllConfigurations();
            }
            catch (Exception e2) {
                out.println("Error while closing the configuration: " + e2.getMessage());
            }
            break block11;
            {
                catch (Exception e) {
                    this.displayException(out, e);
                    Object var13_15 = null;
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (Exception e2) {
                        out.println("Error while closing the configuration: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                }
                catch (Exception e2) {
                    out.println("Error while closing the configuration: " + e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    private void displayConfiguration(PrintStream out, ConfigurationExtension configuration, String name, boolean detail) throws Exception {
        byte[] value;
        try {
            value = configuration.getFileAsBytes(name);
        }
        catch (NameNotFoundException e) {
            out.println("Error: a file for the name '" + name + "' does not exist");
            return;
        }
        byte[] binary = value;
        out.println("file-length  = " + binary.length + "bytes");
        if (detail) {
            out.println("file-content = ");
            out.println(AbstractCommand.getPrintableText(binary));
        }
    }
}

