/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.configuration.command;

import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.StorageInformation;
import com.sap.engine.frame.core.configuration.admin.ConfigurationHandlerExtension;
import com.sap.engine.frame.core.configuration.admin.Controller;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.configuration.ConfigurationRuntimeInterface;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CallTraceCommand
implements Command {
    private static final String GROUP = "configuration";
    private static final String NAME = "call_trace";
    private static StringBuffer m_usageBuffer = new StringBuffer();
    private ConfigurationRuntimeInterface m_configurationRuntimeInterface = null;
    private ConfigurationHandlerExtension m_configurationHandler = null;
    private Controller m_configurationController = null;
    private StorageInformation m_storageInformation = null;
    private PrintStream m_globalOut = null;
    private String m_pathWithFileName = null;
    private boolean m_toFile = false;

    public CallTraceCommand(ConfigurationRuntimeInterface testRuntimeInterface) {
        this.m_configurationRuntimeInterface = testRuntimeInterface;
    }

    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        this.m_globalOut = new PrintStream(output, true);
        try {
            if (this.m_configurationHandler == null || this.m_configurationController == null || this.m_storageInformation == null) {
                this.m_configurationHandler = this.m_configurationRuntimeInterface.getConfigurationContext().getConfigurationHandlerExtension();
                this.m_configurationController = this.m_configurationRuntimeInterface.getConfigurationContext().getConfigurationController();
                this.m_storageInformation = this.m_configurationRuntimeInterface.getConfigurationContext().getStorageInformation();
            }
        }
        catch (ConfigurationException e) {
            this.m_globalOut.println("Error: " + e.getMessage());
            this.m_globalOut.println("       See log for details\n");
            e.printStackTrace(this.m_globalOut);
        }
        if (!this.parseArgs(params)) {
            this.m_globalOut.println(m_usageBuffer.toString());
            return;
        }
        if (this.m_toFile) {
            if (this.m_pathWithFileName.equals("")) {
                this.m_globalOut.println("Error: File name isn't correct!");
                return;
            }
            File f = new File(this.m_pathWithFileName);
            if (!f.isAbsolute()) {
                this.m_globalOut.println(this.m_pathWithFileName + " should be a absolute path!");
                return;
            }
            if (f.getName().equals("")) {
                this.m_globalOut.println("Error: File name isn't correct!");
                return;
            }
        }
        if (params[0].equalsIgnoreCase("-start")) {
            if (this.m_configurationController.isCommitTraceEnabled()) {
                this.m_globalOut.println("Info: call_trace is already started");
            } else {
                this.m_globalOut.println("Info: call_trace is started");
                this.m_configurationController.setCommitTrace(true);
            }
        } else if (params[0].equalsIgnoreCase("-stop")) {
            if (this.m_configurationController.isCommitTraceEnabled()) {
                this.m_globalOut.println("Info: call_trace is stopped");
                this.m_configurationController.setCommitTrace(false);
            } else {
                this.m_globalOut.println("Info: call_trace is already stopped");
            }
        } else if ((params[0].equalsIgnoreCase("-print") || params[0].equalsIgnoreCase("-p")) && !this.m_configurationController.isCommitTraceEnabled()) {
            this.m_globalOut.println("Info: call_trace isn't enabled. Please start it first!");
        } else if ((params[0].equalsIgnoreCase("-print") || params[0].equalsIgnoreCase("-p")) && this.m_configurationController.isCommitTraceEnabled()) {
            this.printStatistics(this.m_pathWithFileName, this.m_toFile, this.m_globalOut);
        } else if (params[0].equalsIgnoreCase("-reset") || params[0].equalsIgnoreCase("-r")) {
            this.m_configurationController.setCommitTrace(false);
            this.m_configurationController.setCommitTrace(true);
            this.m_globalOut.println("Info: call_trace is resetted.");
        } else if (params[0].equalsIgnoreCase("-status") || params[0].equalsIgnoreCase("-s")) {
            this.m_globalOut.println("Info: call_trace is currently switched " + this.isSwitchedOn());
        }
    }

    private boolean parseArgs(String[] args) {
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("-start") || args[0].equalsIgnoreCase("-stop") || args[0].equalsIgnoreCase("-reset") || args[0].equalsIgnoreCase("-r") || args[0].equalsIgnoreCase("-s") || args[0].equalsIgnoreCase("-status")) {
            return args.length == 1;
        }
        if (args[0].equalsIgnoreCase("-print") || args[0].equalsIgnoreCase("-p")) {
            if (args.length == 1) {
                this.m_toFile = false;
                return true;
            }
            if (args.length == 3) {
                if (args[1].equalsIgnoreCase("-file") || args[1].equalsIgnoreCase("-f")) {
                    this.m_pathWithFileName = args[2];
                    this.m_toFile = true;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public void printStatistics(String resultFileName, boolean printToFile, PrintStream outStream) {
        block35: {
            PrintWriter pw;
            OutputStreamWriter fw;
            block34: {
                fw = null;
                pw = null;
                StringBuffer strBuf = new StringBuffer();
                int FIRST_COL_LENGTH = 50;
                int SEC_THIRD_COL_LENGTH = 9;
                strBuf.append("\r\n");
                strBuf.append("***********************************************************\r\n");
                strBuf.append("\r\n");
                strBuf.append("Date             : " + new Date() + "\r\n");
                strBuf.append("DB-Vendor        : " + this.m_storageInformation.getStorageVendorId() + "\r\n");
                strBuf.append("Java VM          : " + System.getProperty("java.vm.name") + "\r\n");
                strBuf.append("Operating System : " + System.getProperty("os.name") + "\r\n");
                strBuf.append("OS-Version       : " + System.getProperty("os.version") + "\r\n");
                strBuf.append("OS-Patch         : " + System.getProperty("sun.os.patch.level") + "\r\n");
                strBuf.append("\r\n");
                strBuf.append("\r\n");
                String firLine = "";
                String secLine = "";
                int i = 0;
                while (i < (FIRST_COL_LENGTH - 6) / 2) {
                    firLine = firLine + " ";
                    secLine = secLine + " ";
                    ++i;
                }
                firLine = firLine + "      " + firLine + "|         | Commit  |         |";
                secLine = secLine + "Caller" + secLine + "|# Commits|time (ms)| # cfgs  |";
                String minusLine = "";
                int i2 = 0;
                while (i2 < firLine.length()) {
                    minusLine = minusLine + "-";
                    ++i2;
                }
                strBuf.append(firLine + "\r\n");
                strBuf.append(secLine + "\r\n");
                strBuf.append(minusLine + "\r\n");
                HashMap hashMap = this.m_configurationController.getCommitInfos();
                Set set = hashMap.keySet();
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    String theString = new String(str);
                    Object[] temp = (Object[])hashMap.get(str);
                    long count = (Long)temp[0];
                    long commitTime = (Long)temp[1];
                    long countCfgs = (Long)temp[2];
                    int idx = 0;
                    ArrayList<String> strList = new ArrayList<String>();
                    String delta = "";
                    String oldLine = "";
                    String theLine = "";
                    while ((idx = str.indexOf(".")) != -1) {
                        delta = str.substring(0, idx + 1);
                        if ((theLine = theLine + delta).length() >= FIRST_COL_LENGTH && theLine.length() - oldLine.length() < FIRST_COL_LENGTH) {
                            strList.add(oldLine);
                            theLine = delta;
                        } else if (theLine.length() >= FIRST_COL_LENGTH && theLine.length() - oldLine.length() >= FIRST_COL_LENGTH) {
                            strList.add(oldLine + delta.substring(0, FIRST_COL_LENGTH - oldLine.length()));
                            theLine = delta.substring(FIRST_COL_LENGTH - oldLine.length());
                        }
                        oldLine = new String(theLine);
                        str = str.substring(idx + 1);
                    }
                    if ((theLine + str).length() > FIRST_COL_LENGTH) {
                        strList.add(theLine);
                        if (str.length() >= FIRST_COL_LENGTH) {
                            int i3 = 0;
                            while (i3 <= str.length()) {
                                strList.add(str.substring(i3, i3 + FIRST_COL_LENGTH));
                                i3 += FIRST_COL_LENGTH;
                            }
                        }
                    } else {
                        strList.add(theLine + str);
                    }
                    String whiteSpaces = "";
                    int i4 = 0;
                    while (i4 < SEC_THIRD_COL_LENGTH) {
                        whiteSpaces = whiteSpaces + " ";
                        ++i4;
                    }
                    String firstCol = "";
                    String secondCol = "";
                    String thirdCol = "";
                    String fourthCol = "";
                    String secondColSpaces = "";
                    String thirdColSpaces = "";
                    String fourthColSpaces = "";
                    int lengthOfCount = SEC_THIRD_COL_LENGTH - String.valueOf(countCfgs).length();
                    int i5 = 0;
                    while (i5 < lengthOfCount / 2) {
                        fourthColSpaces = fourthColSpaces + " ";
                        ++i5;
                    }
                    fourthCol = lengthOfCount % 2 == 0 ? fourthColSpaces + countCfgs + fourthColSpaces : fourthColSpaces + countCfgs + fourthColSpaces + " ";
                    lengthOfCount = SEC_THIRD_COL_LENGTH - String.valueOf(count).length();
                    int i6 = 0;
                    while (i6 < lengthOfCount / 2) {
                        secondColSpaces = secondColSpaces + " ";
                        ++i6;
                    }
                    secondCol = lengthOfCount % 2 == 0 ? secondColSpaces + count + secondColSpaces : secondColSpaces + count + secondColSpaces + " ";
                    lengthOfCount = SEC_THIRD_COL_LENGTH - String.valueOf(commitTime).length();
                    int i7 = 0;
                    while (i7 < lengthOfCount / 2) {
                        thirdColSpaces = thirdColSpaces + " ";
                        ++i7;
                    }
                    thirdCol = lengthOfCount % 2 == 0 ? thirdColSpaces + commitTime + thirdColSpaces : thirdColSpaces + commitTime + thirdColSpaces + " ";
                    int i8 = 0;
                    while (i8 < strList.size()) {
                        String s = (String)strList.get(i8);
                        String firstColSpaces = "";
                        int j = 0;
                        while (j < FIRST_COL_LENGTH - s.length()) {
                            firstColSpaces = firstColSpaces + " ";
                            ++j;
                        }
                        s = s + firstColSpaces;
                        if (i8 == 0) {
                            strBuf.append(s + "|" + secondCol + "|" + thirdCol + "|" + fourthCol + "|\r\n");
                        } else {
                            strBuf.append(s + "|" + whiteSpaces + "|" + whiteSpaces + "|" + whiteSpaces + "|\r\n");
                        }
                        ++i8;
                    }
                    strBuf.append(minusLine + "\r\n");
                }
                if (printToFile) {
                    File theFile = new File(resultFileName);
                    theFile.getParentFile().mkdirs();
                    fw = new FileWriter(resultFileName, true);
                    pw = new PrintWriter((Writer)fw, true);
                    pw.println(strBuf.toString());
                    break block34;
                }
                outStream.println(strBuf.toString());
            }
            Object var49_47 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                if (pw != null) {
                    pw.close();
                }
                break block35;
            }
            catch (IOException e1) {
                e1.printStackTrace(this.m_globalOut);
            }
            break block35;
            {
                catch (IOException e) {
                    e.printStackTrace(this.m_globalOut);
                    Object var49_48 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        if (pw != null) {
                            pw.close();
                        }
                        break block35;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace(this.m_globalOut);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var49_49 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace(this.m_globalOut);
                }
                throw throwable;
            }
        }
    }

    private String isSwitchedOn() {
        if (this.m_configurationController.isCommitTraceEnabled()) {
            return "on";
        }
        return "off";
    }

    public String getGroup() {
        return GROUP;
    }

    public String getHelpMessage() {
        return m_usageBuffer.toString();
    }

    public String getName() {
        return NAME;
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    static {
        m_usageBuffer.append("Enables tracing of all ConfigurationManager commits.\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append("Usage: CALL_TRACE <-start|-stop>\n");
        m_usageBuffer.append("                  <-p> [-f filepath]\n");
        m_usageBuffer.append("                  <-r>\n");
        m_usageBuffer.append("                  <-s>\n");
        m_usageBuffer.append("\n");
        m_usageBuffer.append(" <-start|-stop>                    - Starts/Stops the tracing of the commits\n");
        m_usageBuffer.append(" <-p[rint]>                        - Prints the results of the current tracing session to screen\n");
        m_usageBuffer.append(" [-f[ile] filepath]                - For printing the output to a file you have to\n");
        m_usageBuffer.append("                                     declare the absolute path and the filename\n");
        m_usageBuffer.append(" <-r[eset]>                        - Resets the current results\n");
        m_usageBuffer.append(" <-s[tatus]>                       - Shows the curent state of the call_trace command\n");
    }
}

